/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.RemoteServerConnectionTester;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.RemoteServerCombo;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployToServerSettingsEditor<S extends ServerConfiguration, D extends DeploymentConfiguration>
extends SettingsEditor<DeployToServerRunConfiguration<S, D>> {
    private final DeploymentConfigurator<D, S> myDeploymentConfigurator;
    private final Project myProject;
    private final WithAutoDetectCombo<S> myServerCombo;
    private final JPanel myDeploymentSettingsComponent;
    private SettingsEditor<D> myDeploymentSettingsEditor;
    private DeploymentSource myLastSelectedSource;
    private RemoteServer<S> myLastSelectedServer;

    public DeployToServerSettingsEditor(@NotNull ServerType<S> type, @NotNull DeploymentConfigurator<D, S> deploymentConfigurator, @NotNull Project project) {
        if (type == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(0);
        }
        if (deploymentConfigurator == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(2);
        }
        this.myDeploymentConfigurator = deploymentConfigurator;
        this.myProject = project;
        this.myServerCombo = new WithAutoDetectCombo<S>(type);
        Disposer.register((Disposable)this, this.myServerCombo);
        this.myServerCombo.addChangeListener(e -> this.updateDeploymentSettingsEditor());
        this.myDeploymentSettingsComponent = new JPanel(new BorderLayout());
    }

    protected abstract DeploymentSource getSelectedSource();

    protected abstract void resetSelectedSourceFrom(@NotNull DeployToServerRunConfiguration<S, D> var1);

    protected final void updateDeploymentSettingsEditor() {
        RemoteServer selectedServer = this.myServerCombo.getSelectedServer();
        DeploymentSource selectedSource = this.getSelectedSource();
        if (Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource) && Comparing.equal(selectedServer, this.myLastSelectedServer)) {
            return;
        }
        if (!Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource)) {
            this.updateBeforeRunOptions(this.myLastSelectedSource, false);
            this.updateBeforeRunOptions(selectedSource, true);
        }
        if (selectedSource != null && selectedServer != null) {
            this.myDeploymentSettingsComponent.removeAll();
            this.myDeploymentSettingsEditor = this.myDeploymentConfigurator.createEditor(selectedSource, selectedServer);
            if (this.myDeploymentSettingsEditor != null) {
                Disposer.register((Disposable)this, this.myDeploymentSettingsEditor);
                this.myDeploymentSettingsComponent.add("Center", this.myDeploymentSettingsEditor.getComponent());
            }
        }
        this.myLastSelectedSource = selectedSource;
        this.myLastSelectedServer = selectedServer;
    }

    private void updateBeforeRunOptions(@Nullable DeploymentSource source, boolean selected2) {
        if (source != null) {
            DeploymentSourceType type = source.getType();
            type.updateBuildBeforeRunOption(this.myServerCombo, this.myProject, source, selected2);
        }
    }

    protected void resetEditorFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
        if (configuration == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(3);
        }
        this.myServerCombo.selectServerInCombo(configuration.getServerName());
        this.resetSelectedSourceFrom(configuration);
        D deploymentConfiguration = configuration.getDeploymentConfiguration();
        this.updateDeploymentSettingsEditor();
        if (deploymentConfiguration != null && this.myDeploymentSettingsEditor != null) {
            this.myDeploymentSettingsEditor.resetFrom(deploymentConfiguration);
        }
    }

    protected void applyEditorTo(@NotNull DeployToServerRunConfiguration<S, D> configuration) throws ConfigurationException {
        if (configuration == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(4);
        }
        this.updateDeploymentSettingsEditor();
        this.myServerCombo.validateAutoDetectedItem();
        configuration.setServerName(Optional.ofNullable(this.myServerCombo.getSelectedServer()).map(RemoteServer::getName).orElse(null));
        DeploymentSource deploymentSource = this.getSelectedSource();
        configuration.setDeploymentSource(deploymentSource);
        if (deploymentSource != null) {
            Object deployment = configuration.getDeploymentConfiguration();
            if (deployment == null) {
                deployment = this.myDeploymentConfigurator.createDefaultConfiguration(deploymentSource);
                configuration.setDeploymentConfiguration(deployment);
            }
            if (this.myDeploymentSettingsEditor != null) {
                this.myDeploymentSettingsEditor.applyTo(deployment);
            }
        } else {
            configuration.setDeploymentConfiguration(null);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        FormBuilder builder2 = FormBuilder.createFormBuilder().addLabeledComponent(CloudBundle.message((String)"label.text.server", (Object[])new Object[0]), this.myServerCombo);
        this.addDeploymentSourceUi(builder2);
        JPanel jPanel2 = builder2.addComponentFillVertically((JComponent)this.myDeploymentSettingsComponent, 4).getPanel();
        if (jPanel2 == null) {
            DeployToServerSettingsEditor.$$$reportNull$$$0(5);
        }
        return jPanel2;
    }

    protected abstract void addDeploymentSourceUi(FormBuilder var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentConfigurator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WithAutoDetectCombo<S extends ServerConfiguration>
    extends RemoteServerCombo<S> {
        private AutoDetectedItem myAutoDetectedItem;

        WithAutoDetectCombo(@NotNull ServerType<S> serverType) {
            if (serverType == null) {
                WithAutoDetectCombo.$$$reportNull$$$0(0);
            }
            super(serverType);
        }

        @Override
        @NotNull
        protected RemoteServerCombo.ServerItem getNoServersItem() {
            RemoteServerCombo.ServerItem serverItem = this.getServerType().canAutoDetectConfiguration() ? this.findOrCreateAutoDetectedItem() : super.getNoServersItem();
            if (serverItem == null) {
                WithAutoDetectCombo.$$$reportNull$$$0(1);
            }
            return serverItem;
        }

        protected AutoDetectedItem findOrCreateAutoDetectedItem() {
            if (this.myAutoDetectedItem == null) {
                this.myAutoDetectedItem = new AutoDetectedItem();
            }
            return this.myAutoDetectedItem;
        }

        public void validateAutoDetectedItem() throws RuntimeConfigurationException {
            if (this.myAutoDetectedItem != null && this.myAutoDetectedItem == this.getSelectedItem()) {
                this.myAutoDetectedItem.validateConnection();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$WithAutoDetectCombo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$WithAutoDetectCombo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNoServersItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class AutoDetectedItem
        extends RemoteServerCombo.ServerItemImpl {
            private final AtomicReference<TestConnectionState> myTestConnectionStateA;
            private volatile RemoteServer<S> myServerInstance;
            private volatile long myLastStartedTestConnectionMillis;

            AutoDetectedItem() {
                super(WithAutoDetectCombo.this, null);
                this.myTestConnectionStateA = new AtomicReference<TestConnectionState>(TestConnectionState.INITIAL);
                this.myLastStartedTestConnectionMillis = -1L;
            }

            @Override
            public void render(@NotNull SimpleColoredComponent ui) {
                if (ui == null) {
                    AutoDetectedItem.$$$reportNull$$$0(0);
                }
                ui.setIcon(WithAutoDetectCombo.this.getServerType().getIcon());
                boolean failed = this.myTestConnectionStateA.get() == TestConnectionState.FAILED;
                ui.append(CloudBundle.message((String)"remote.server.combo.auto.detected.server", (Object[])new Object[]{WithAutoDetectCombo.this.getServerType().getPresentableName()}), failed ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            }

            public void validateConnection() throws RuntimeConfigurationException {
                this.myTestConnectionStateA.get().validateConnection();
            }

            @Override
            public void onBrowseAction() {
                WithAutoDetectCombo.this.createAndEditNewServer();
            }

            @Override
            public void onItemChosen() {
                if (this.myServerInstance == null) {
                    this.myServerInstance = RemoteServersManager.getInstance().createServer(WithAutoDetectCombo.this.getServerType());
                    RemoteServerConnectionTester tester = new RemoteServerConnectionTester(this.myServerInstance);
                    this.setTestConnectionState(TestConnectionState.IN_PROGRESS);
                    this.myLastStartedTestConnectionMillis = System.currentTimeMillis();
                    tester.testConnection(this::connectionTested);
                }
            }

            @Override
            @Nullable
            public String getServerName() {
                return null;
            }

            @Override
            @Nullable
            public RemoteServer<S> findRemoteServer() {
                return this.myServerInstance;
            }

            private void setTestConnectionState(@NotNull TestConnectionState state) {
                boolean changed2;
                if (state == null) {
                    AutoDetectedItem.$$$reportNull$$$0(1);
                }
                boolean bl = changed2 = this.myTestConnectionStateA.getAndSet(state) != state;
                if (changed2) {
                    UIUtil.invokeLaterIfNeeded(WithAutoDetectCombo.this::fireStateChanged);
                }
            }

            private void connectionTested(boolean wasConnected, String errorStatus) {
                assert (this.myLastStartedTestConnectionMillis > 0L);
                this.waitABit(2000L);
                if (wasConnected) {
                    this.setTestConnectionState(TestConnectionState.SUCCESSFUL);
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (!Disposer.isDisposed((Disposable)WithAutoDetectCombo.this)) {
                            assert (this.myServerInstance != null);
                            RemoteServersManager.getInstance().addServer(this.myServerInstance);
                            WithAutoDetectCombo.this.refillModel(this.myServerInstance);
                        }
                        this.myServerInstance = null;
                    });
                } else {
                    this.setTestConnectionState(TestConnectionState.FAILED);
                    this.myServerInstance = null;
                }
            }

            private void waitABit(long maxTotalDelayMillis) {
                long THRESHOLD_MS = 50L;
                long naturalDelay = System.currentTimeMillis() - this.myLastStartedTestConnectionMillis;
                if (naturalDelay > 0L && naturalDelay + 50L < maxTotalDelayMillis) {
                    try {
                        Thread.sleep(maxTotalDelayMillis - naturalDelay - 50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.myLastStartedTestConnectionMillis = -1L;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ui";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$WithAutoDetectCombo$AutoDetectedItem";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "render";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setTestConnectionState";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static enum TestConnectionState {
            INITIAL{

                @Override
                public void validateConnection() throws RuntimeConfigurationException {
                }
            }
            ,
            IN_PROGRESS{

                @Override
                public void validateConnection() throws RuntimeConfigurationException {
                    throw new RuntimeConfigurationWarning(CloudBundle.message((String)"remote.server.combo.message.test.connection.in.progress", (Object[])new Object[0]));
                }
            }
            ,
            SUCCESSFUL{

                @Override
                public void validateConnection() throws RuntimeConfigurationException {
                }
            }
            ,
            FAILED{

                @Override
                public void validateConnection() throws RuntimeConfigurationException {
                    throw new RuntimeConfigurationError(CloudBundle.message((String)"remote.server.combo.message.test.connection.failed", (Object[])new Object[0]));
                }
            };


            public abstract void validateConnection() throws RuntimeConfigurationException;
        }
    }

    public static class LockedSource<S extends ServerConfiguration, D extends DeploymentConfiguration>
    extends DeployToServerSettingsEditor<S, D> {
        private final DeploymentSource myLockedSource;

        public LockedSource(@NotNull ServerType<S> type, @NotNull DeploymentConfigurator<D, S> deploymentConfigurator, @NotNull Project project, @NotNull DeploymentSource lockedSource) {
            if (type == null) {
                LockedSource.$$$reportNull$$$0(0);
            }
            if (deploymentConfigurator == null) {
                LockedSource.$$$reportNull$$$0(1);
            }
            if (project == null) {
                LockedSource.$$$reportNull$$$0(2);
            }
            if (lockedSource == null) {
                LockedSource.$$$reportNull$$$0(3);
            }
            super(type, deploymentConfigurator, project);
            this.myLockedSource = lockedSource;
        }

        @Override
        protected void addDeploymentSourceUi(FormBuilder formBuilder) {
        }

        @Override
        protected void resetSelectedSourceFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
            if (configuration == null) {
                LockedSource.$$$reportNull$$$0(4);
            }
            assert (configuration.getDeploymentSource() == this.myLockedSource);
        }

        @Override
        protected DeploymentSource getSelectedSource() {
            return this.myLockedSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentConfigurator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lockedSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$LockedSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetSelectedSourceFrom";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AnySource<S extends ServerConfiguration, D extends DeploymentConfiguration>
    extends DeployToServerSettingsEditor<S, D> {
        private final ComboBox<DeploymentSource> mySourceComboBox;
        private final SortedComboBoxModel<DeploymentSource> mySourceListModel = new SortedComboBoxModel(Comparator.comparing(DeploymentSource::getPresentableName, String.CASE_INSENSITIVE_ORDER));

        public AnySource(ServerType<S> type, DeploymentConfigurator<D, S> deploymentConfigurator, Project project) {
            super(type, deploymentConfigurator, project);
            this.mySourceListModel.addAll((Collection)deploymentConfigurator.getAvailableDeploymentSources());
            this.mySourceComboBox = new ComboBox(this.mySourceListModel);
            this.mySourceComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index) -> {
                if (value2 == null) {
                    return;
                }
                label2.setIcon(value2.getIcon());
                label2.setText(value2.getPresentableName());
            }));
            this.mySourceComboBox.addActionListener(e -> this.updateDeploymentSettingsEditor());
        }

        @Override
        protected DeploymentSource getSelectedSource() {
            return (DeploymentSource)this.mySourceListModel.getSelectedItem();
        }

        @Override
        protected void resetSelectedSourceFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
            if (configuration == null) {
                AnySource.$$$reportNull$$$0(0);
            }
            this.mySourceComboBox.setSelectedItem((Object)configuration.getDeploymentSource());
        }

        @Override
        protected void addDeploymentSourceUi(FormBuilder formBuilder) {
            formBuilder.addLabeledComponent(CloudBundle.message((String)"label.text.deployment", (Object[])new Object[0]), this.mySourceComboBox);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$AnySource", "resetSelectedSourceFrom"));
        }
    }
}

