/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.mac.growl.Growl;
import com.intellij.util.ArrayUtilRt;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

final class GrowlNotifications
implements SystemNotificationsImpl.Notifier {
    private static final Logger LOG = Logger.getInstance(GrowlNotifications.class);
    private static GrowlNotifications ourNotifications;
    private final Growl myGrowl = new Growl(ApplicationNamesInfo.getInstance().getFullProductName());
    private final Set<String> myNotifications = new TreeSet<String>();

    public static synchronized GrowlNotifications getInstance() {
        if (ourNotifications == null && JnaLoader.isLoaded()) {
            ourNotifications = new GrowlNotifications();
        }
        return ourNotifications;
    }

    private GrowlNotifications() {
        this.register();
    }

    private void register() {
        this.myGrowl.setAllowedNotifications(ArrayUtilRt.toStringArray(this.myNotifications));
        this.myGrowl.setDefaultNotifications(ArrayUtilRt.toStringArray(this.myNotifications));
        this.myGrowl.register();
    }

    @Override
    public void notify(@NotNull String name, @NotNull String title, @NotNull String description) {
        if (name == null) {
            GrowlNotifications.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GrowlNotifications.$$$reportNull$$$0(1);
        }
        if (description == null) {
            GrowlNotifications.$$$reportNull$$$0(2);
        }
        try {
            if (this.myNotifications.add(name)) {
                this.register();
            }
            this.myGrowl.notifyGrowlOf(name, title, description);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/GrowlNotifications";
        objectArray[2] = "notify";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

