/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.tree.ui.CompactPainter;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.ui.tree.ui.DispatchThreadValidator;
import com.intellij.ui.tree.ui.LoadingNodeRenderer;
import com.intellij.ui.tree.ui.TreeAction;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public final class DefaultTreeUI
extends BasicTreeUI {
    @ApiStatus.Internal
    public static final Key<Boolean> LARGE_MODEL_ALLOWED = Key.create((String)"allows to use large model (only for synchronous tree models)");
    @ApiStatus.Internal
    public static final Key<Boolean> AUTO_EXPAND_ALLOWED = Key.create((String)"allows to expand a single child node automatically in tests");
    private static final Logger LOG = Logger.getInstance(DefaultTreeUI.class);
    private static final Collection<Class<?>> SUSPICIOUS = ContainerUtil.createWeakSet();
    private final Control control = new DefaultControl();
    private final DispatchThreadValidator validator = new DispatchThreadValidator();

    @NotNull
    private static Control.Painter getPainter(@NotNull JTree tree) {
        Control.Painter painter;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(0);
        }
        if ((painter = (Control.Painter)ComponentUtil.getClientProperty((JComponent)tree, Control.Painter.KEY)) != null) {
            Control.Painter painter2 = painter;
            if (painter2 == null) {
                DefaultTreeUI.$$$reportNull$$$0(1);
            }
            return painter2;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null && (painter = (Control.Painter)application.getUserData(Control.Painter.KEY)) != null) {
            Control.Painter painter3 = painter;
            if (painter3 == null) {
                DefaultTreeUI.$$$reportNull$$$0(2);
            }
            return painter3;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        if (settings != null && settings.getCompactTreeIndents()) {
            Control.Painter painter4 = Control.Painter.COMPACT;
            if (painter4 == null) {
                DefaultTreeUI.$$$reportNull$$$0(3);
            }
            return painter4;
        }
        if (Registry.is((String)"ide.tree.painter.classic.compact")) {
            Control.Painter painter5 = Control.Painter.COMPACT;
            if (painter5 == null) {
                DefaultTreeUI.$$$reportNull$$$0(4);
            }
            return painter5;
        }
        if (Registry.is((String)"ide.tree.painter.compact.default")) {
            Control.Painter painter6 = CompactPainter.DEFAULT;
            if (painter6 == null) {
                DefaultTreeUI.$$$reportNull$$$0(5);
            }
            return painter6;
        }
        Control.Painter painter7 = Control.Painter.DEFAULT;
        if (painter7 == null) {
            DefaultTreeUI.$$$reportNull$$$0(6);
        }
        return painter7;
    }

    @Nullable
    private static Color getBackground(@NotNull JTree tree, @NotNull TreePath path, int row, boolean selected2) {
        BackgroundSupplier supplier2;
        Color background;
        Color background2;
        Color background3;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(7);
        }
        if (path == null) {
            DefaultTreeUI.$$$reportNull$$$0(8);
        }
        if (selected2) {
            return RenderingUtil.getSelectionBackground((JTree)tree);
        }
        if (row == TreeHoverListener.getHoveredRow((JTree)tree) && (background3 = RenderingUtil.getHoverBackground((JTree)tree)) != null) {
            return background3;
        }
        Object node = TreeUtil.getLastUserObject((TreePath)path);
        if (node instanceof ColoredItem && (background2 = ((ColoredItem)node).getColor()) != null) {
            return background2;
        }
        if (node instanceof BackgroundSupplier && (background = (supplier2 = (BackgroundSupplier)node).getElementBackground(row)) != null) {
            return background;
        }
        if (tree instanceof TreePathBackgroundSupplier && (background = (supplier2 = (TreePathBackgroundSupplier)tree).getPathBackground(path, row)) != null) {
            return background;
        }
        return null;
    }

    @ApiStatus.Internal
    public static void setBackground(@NotNull JTree tree, @NotNull Component component2, int row) {
        TreePath path;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(9);
        }
        if (component2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(10);
        }
        Color background = (path = tree.getPathForRow(row)) == null ? null : DefaultTreeUI.getBackground(tree, path, row, tree.isRowSelected(row));
        DefaultTreeUI.setBackground(tree, component2, background, true);
    }

    private static void setBackground(@NotNull JTree tree, @NotNull Component component2, @Nullable Color background, boolean opaque) {
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(11);
        }
        if (component2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(12);
        }
        if (component2 instanceof JComponent) {
            ((JComponent)component2).setOpaque(opaque);
        }
        if (background != null) {
            component2.setBackground(background);
        } else if (component2.isOpaque()) {
            component2.setBackground(RenderingUtil.getBackground((JTree)tree));
        }
    }

    private static boolean isSuspiciousRenderer(Component component2) {
        if (component2 instanceof JComponent) {
            Method method2 = ReflectionUtil.getMethod(component2.getClass(), (String)"validate", (Class[])new Class[0]);
            Class<?> type = method2 == null ? null : method2.getDeclaringClass();
            return Component.class.equals(type) || Container.class.equals(type);
        }
        return true;
    }

    private static boolean isLeadSelectionNeeded(@NotNull JTree tree, int row) {
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(13);
        }
        return 1 < tree.getSelectionCount() && tree.isRowSelected(row - 1) && tree.isRowSelected(row + 1);
    }

    private static boolean isLargeModelAllowed(@Nullable JTree tree) {
        return Registry.is((String)"ide.tree.large.model.allowed") || UIUtil.isClientPropertyTrue((Object)tree, LARGE_MODEL_ALLOWED);
    }

    private static boolean isAutoExpandAllowed(@NotNull JTree tree) {
        Boolean allowed;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(14);
        }
        return (allowed = (Boolean)UIUtil.getClientProperty((Object)tree, AUTO_EXPAND_ALLOWED)) != null ? allowed.booleanValue() : tree.isShowing();
    }

    public static ComponentUI createUI(JComponent component2) {
        assert (component2 instanceof JTree);
        return new DefaultTreeUI();
    }

    @Nullable
    private JTree getTree() {
        return this.tree;
    }

    @Nullable
    private Component getRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean focused) {
        Class<?> type;
        TreeCellRenderer renderer2;
        TreeCellRenderer treeCellRenderer = renderer2 = value2 instanceof LoadingNode ? LoadingNodeRenderer.SHARED : this.currentCellRenderer;
        if (renderer2 == null) {
            return null;
        }
        Component component2 = renderer2.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, focused);
        if (component2 == null) {
            return null;
        }
        CellRendererPane pane2 = this.rendererPane;
        if (pane2 != null && pane2 != component2.getParent()) {
            pane2.add(component2);
        }
        if (LOG.isDebugEnabled() && !SUSPICIOUS.contains(type = renderer2.getClass()) && DefaultTreeUI.isSuspiciousRenderer(component2) && SUSPICIOUS.add(type)) {
            LOG.debug("suspicious renderer " + type);
        }
        return component2;
    }

    private boolean isLeaf(@Nullable Object value2) {
        return value2 == null || this.treeModel.isLeaf(value2);
    }

    private boolean isValid(@Nullable JTree tree) {
        if (!this.validator.isValidThread()) {
            return false;
        }
        if (tree != null && tree == this.getTree()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException(tree != null ? "unexpected tree" : "undefined tree"));
        return false;
    }

    private void repaintPath(@Nullable TreePath path) {
        Rectangle bounds2 = this.getPathBounds(this.getTree(), path);
        if (bounds2 != null) {
            this.tree.repaint(0, bounds2.y, this.tree.getWidth(), bounds2.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractLayoutCache cache = this.treeState;
        if (cache == null) {
            return;
        }
        JTree tree = (JTree)c;
        if (!this.isValid(tree)) {
            return;
        }
        g = g.create();
        try {
            Rectangle paintBounds = g.getClipBounds();
            Insets insets = tree.getInsets();
            TreePath path = cache.getPathClosestTo(0, paintBounds.y - insets.top);
            int row = cache.getRowForPath(path);
            if (row >= 0) {
                Rectangle bounds2;
                Control.Painter painter = DefaultTreeUI.getPainter(tree);
                Rectangle buffer = new Rectangle();
                RenderingHelper helper = new RenderingHelper(tree);
                int maxPaintY = paintBounds.y + paintBounds.height;
                while (path != null && (bounds2 = cache.getBounds(path, buffer)) != null) {
                    bounds2.y += insets.top;
                    int depth = TreeUtil.getNodeDepth((JTree)tree, (TreePath)path);
                    boolean leaf = this.isLeaf(path.getLastPathComponent());
                    boolean expanded = !leaf && cache.getExpandedState(path);
                    boolean selected2 = tree.isRowSelected(row);
                    boolean focused = RenderingUtil.isFocused((JComponent)tree);
                    boolean lead = focused && row == this.getLeadSelectionRow();
                    Color background = DefaultTreeUI.getBackground(tree, path, row, selected2);
                    if (background != null) {
                        g.setColor(background);
                        g.fillRect(helper.getX(), bounds2.y, helper.getWidth(), bounds2.height);
                    }
                    int offset = painter.getRendererOffset(this.control, depth, leaf);
                    painter.paint(tree, g, insets.left, bounds2.y, offset, bounds2.height, this.control, depth, leaf, expanded, selected2 && focused);
                    if (this.editingComponent == null || this.editingRow != row) {
                        Object value2;
                        Component component2;
                        int width = helper.getX() + helper.getWidth() - insets.left - offset - helper.getRightMargin();
                        if (width > 0 && (component2 = this.getRenderer(tree, value2 = path.getLastPathComponent(), selected2, expanded, leaf, row, lead)) != null) {
                            if (width < bounds2.width && helper.isRendererShrinkingDisabled(row)) {
                                width = bounds2.width;
                            }
                            DefaultTreeUI.setBackground(tree, component2, background, false);
                            this.rendererPane.paintComponent(g, component2, tree, insets.left + offset, bounds2.y, width, bounds2.height, true);
                        }
                        if (!SystemInfo.isMac && lead && g instanceof Graphics2D) {
                            if (!selected2) {
                                g.setColor(DefaultTreeUI.getBackground(tree, path, row, true));
                                RectanglePainter.DRAW.paint((Graphics2D)g, helper.getX(), bounds2.y, helper.getWidth(), bounds2.height, (Object)0);
                            } else if (DefaultTreeUI.isLeadSelectionNeeded(tree, row)) {
                                g.setColor(RenderingUtil.getBackground((JTree)tree));
                                RectanglePainter.DRAW.paint((Graphics2D)g, helper.getX() + 1, bounds2.y + 1, helper.getWidth() - 2, bounds2.height - 2, (Object)0);
                            }
                        }
                    }
                    if (bounds2.y + bounds2.height >= maxPaintY) break;
                    path = cache.getPathForRow(++row);
                }
            }
            this.paintDropLine(g);
        }
        finally {
            g.dispose();
            this.rendererPane.removeAll();
        }
    }

    @Override
    protected void installDefaults() {
        JTree tree;
        super.installDefaults();
        if (!DefaultTreeUI.isLargeModelAllowed(this.getTree())) {
            this.largeModel = false;
        }
        if ((tree = this.getTree()) != null) {
            LookAndFeel.installBorder(tree, "Tree.border");
            if (tree.isForegroundSet()) {
                tree.setForeground(null);
            }
            if (UIManager.get("Tree.showsRootHandles") == null) {
                LookAndFeel.installProperty(tree, "showsRootHandles", Boolean.TRUE);
            }
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        TreeAction.installTo(this.tree.getActionMap());
        TreeAction.installTo(this.tree.getInputMap(0));
    }

    @Override
    protected boolean isToggleEvent(MouseEvent event) {
        if (!super.isToggleEvent(event)) {
            return false;
        }
        JTree tree = this.getTree();
        return tree != null && EditSourceOnDoubleClickHandler.isExpandPreferable((JTree)tree, (TreePath)tree.getSelectionPath());
    }

    @Override
    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        JTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        Rectangle bounds2 = this.getPathBounds(tree, path);
        if (bounds2 == null) {
            return false;
        }
        bounds2.x = DefaultTreeUI.getPainter(tree).getControlOffset(this.control, TreeUtil.getNodeDepth((JTree)tree, (TreePath)path), this.isLeaf(path.getLastPathComponent()));
        if (bounds2.x < 0) {
            return false;
        }
        Insets insets = tree.getInsets();
        bounds2.x += insets.left;
        bounds2.width = this.control.getWidth();
        int height = 2 + this.control.getHeight();
        if (height < bounds2.height) {
            bounds2.y += (bounds2.height - height) / 2;
            bounds2.height = height;
        }
        return bounds2.contains(mouseX, mouseY);
    }

    @Override
    protected int getRowX(int row, int depth) {
        JTree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        TreePath path = this.getPathForRow(tree, row);
        if (path == null) {
            return 0;
        }
        return DefaultTreeUI.getPainter(tree).getRendererOffset(this.control, TreeUtil.getNodeDepth((JTree)tree, (TreePath)path), this.isLeaf(path.getLastPathComponent()));
    }

    @Override
    protected void setRootVisible(boolean newValue2) {
        if (this.treeModel instanceof AsyncTreeModel) {
            UIUtil.invokeLaterIfNeeded(() -> super.setRootVisible(newValue2));
        } else {
            super.setRootVisible(newValue2);
        }
    }

    @Override
    protected void setLargeModel(boolean large) {
        super.setLargeModel(large && DefaultTreeUI.isLargeModelAllowed(this.getTree()));
    }

    @Override
    protected void setModel(TreeModel model2) {
        if (!DefaultTreeUI.isLargeModelAllowed(this.getTree())) {
            this.largeModel = false;
        }
        super.setModel(model2);
    }

    @Override
    protected void updateSize() {
        if (this.getTree() != null) {
            super.updateSize();
        }
    }

    @Override
    protected void completeEditing() {
        if (this.getTree() != null) {
            super.completeEditing();
        }
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new AbstractLayoutCache.NodeDimensions(){

            @Override
            public Rectangle getNodeDimensions(Object value2, int row, int depth, boolean expanded, Rectangle bounds2) {
                JTree tree = DefaultTreeUI.this.getTree();
                if (tree == null) {
                    return null;
                }
                boolean leaf = DefaultTreeUI.this.isLeaf(value2);
                Dimension size = null;
                if (DefaultTreeUI.this.editingComponent != null && DefaultTreeUI.this.editingRow == row) {
                    size = DefaultTreeUI.this.editingComponent.getPreferredSize();
                } else {
                    boolean selected2 = tree.isRowSelected(row);
                    Component component2 = DefaultTreeUI.this.getRenderer(tree, value2, selected2, expanded, leaf, row, false);
                    if (component2 != null) {
                        component2.validate();
                        size = component2.getPreferredSize();
                    }
                }
                if (size == null) {
                    return null;
                }
                int x = DefaultTreeUI.getPainter(tree).getRendererOffset(DefaultTreeUI.this.control, depth + TreeUtil.getDepthOffset((JTree)tree), leaf);
                int height = DefaultTreeUI.this.getRowHeight();
                if (height <= 0) {
                    height = size.height;
                }
                if (bounds2 == null) {
                    return new Rectangle(x, 0, size.width, height);
                }
                bounds2.x = x;
                bounds2.y = 0;
                bounds2.width = size.width;
                bounds2.height = height;
                return bounds2;
            }
        };
    }

    @Override
    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache(){

            @Override
            public void setExpandedState(TreePath path, boolean isExpanded) {
                int oldRowCount = this.getRowCount();
                super.setExpandedState(path, isExpanded);
                if (isExpanded) {
                    this.onSingleChildInserted(path, oldRowCount);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                int oldRowCount = this.getRowCount();
                super.treeNodesInserted(event);
                this.onSingleChildInserted(event.getTreePath(), oldRowCount);
            }

            private void onSingleChildInserted(TreePath path, int oldRowCount) {
                if (path == null || oldRowCount + 1 != this.getRowCount()) {
                    return;
                }
                JTree tree = DefaultTreeUI.this.getTree();
                if (tree == null || !DefaultTreeUI.isAutoExpandAllowed(tree) || !tree.isVisible(path)) {
                    return;
                }
                TreeModel model2 = tree.getModel();
                if (model2 instanceof AsyncTreeModel && 1 == model2.getChildCount(path.getLastPathComponent())) {
                    int pathCount = 1 + path.getPathCount();
                    for (int i2 = 0; i2 <= oldRowCount; ++i2) {
                        TreePath row = this.getPathForRow(i2);
                        if (row == null || pathCount != row.getPathCount() || !path.equals(row.getParentPath())) continue;
                        ((AsyncTreeModel)((Object)model2)).onValidThread(() -> tree.expandPath(row));
                        return;
                    }
                }
            }
        };
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            public void mouseDragged(MouseEvent event) {
                Object property = UIUtil.getClientProperty((Object)event.getSource(), (Object)"DnD Source");
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                Rectangle bounds2;
                int y;
                int x;
                TreePath path;
                JTree tree;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((tree = DefaultTreeUI.this.getTree()) != null && tree == event.getSource() && tree.isEnabled() && !event.isConsumed() && SwingUtilities.isLeftMouseButton(event) && (path = DefaultTreeUI.this.getClosestPathForLocation(tree, x = event.getX(), y = event.getY())) != null && !DefaultTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds2 = DefaultTreeUI.this.getPathBounds(tree, path)) != null && bounds2.y <= y && y <= bounds2.y + bounds2.height && (x = Math.max(bounds2.x, Math.min(x, bounds2.x + bounds2.width - 1))) != event.getX()) {
                    event = 3.convert((MouseEvent)event, (Component)tree, (int)x, (int)y);
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    3.$$$reportNull$$$0(1);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/tree/ui/DefaultTreeUI$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/tree/ui/DefaultTreeUI$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        final PropertyChangeListener parent = super.createPropertyChangeListener();
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String name = event.getPropertyName();
                if ("anchorSelectionPath".equals(name)) {
                    return;
                }
                if ("leadSelectionPath".equals(name)) {
                    DefaultTreeUI.this.updateLeadSelectionRow();
                    DefaultTreeUI.this.repaintPath((TreePath)event.getOldValue());
                    DefaultTreeUI.this.repaintPath((TreePath)event.getNewValue());
                } else if (parent != null) {
                    parent.propertyChange(event);
                }
            }
        };
    }

    @Override
    public Rectangle getPathBounds(JTree tree, TreePath path) {
        if (path == null || !this.isValid(tree)) {
            return null;
        }
        return super.getPathBounds(tree, path);
    }

    @Override
    public TreePath getPathForRow(JTree tree, int row) {
        if (!this.isValid(tree)) {
            return null;
        }
        return super.getPathForRow(tree, row);
    }

    @Override
    public int getRowForPath(JTree tree, TreePath path) {
        if (path == null || !this.isValid(tree)) {
            return -1;
        }
        return super.getRowForPath(tree, path);
    }

    @Override
    public int getRowCount(JTree tree) {
        if (!this.isValid(tree)) {
            return 0;
        }
        return super.getRowCount(tree);
    }

    @Override
    public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
        if (!this.isValid(tree)) {
            return null;
        }
        return super.getClosestPathForLocation(tree, x, y);
    }

    @Override
    public boolean isEditing(JTree tree) {
        if (!this.isValid(tree)) {
            return false;
        }
        return super.isEditing(tree);
    }

    @Override
    public boolean stopEditing(JTree tree) {
        if (!this.isValid(tree)) {
            return false;
        }
        return super.stopEditing(tree);
    }

    @Override
    public void cancelEditing(JTree tree) {
        if (!this.isValid(tree)) {
            return;
        }
        super.cancelEditing(tree);
    }

    @Override
    public void startEditingAtPath(JTree tree, TreePath path) {
        if (path == null || !this.isValid(tree)) {
            return;
        }
        super.startEditingAtPath(tree, path);
    }

    @Override
    public TreePath getEditingPath(JTree tree) {
        if (!this.isValid(tree)) {
            return null;
        }
        return super.getEditingPath(tree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/ui/DefaultTreeUI";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/ui/DefaultTreeUI";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPainter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPainter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBackground";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLeadSelectionNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpandAllowed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

