/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.DebugKt;
import org.jetbrains.kotlin.kotlinx.coroutines.DebugStringsKt;
import org.jetbrains.kotlin.kotlinx.coroutines.TimeSource;
import org.jetbrains.kotlin.kotlinx.coroutines.TimeSourceKt;
import org.jetbrains.kotlin.kotlinx.coroutines.internal.Symbol;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.CoroutineScheduler$WhenMappings;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.GlobalQueue;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.NonBlockingContext;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.Task;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.TaskContext;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.TaskImpl;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.TasksKt;
import org.jetbrains.kotlin.kotlinx.coroutines.scheduling.WorkQueue;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0000\u0018\u0000 \\2\u00020`2\u00020a:\u0003\\]^B+\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u001f\u001a\u00020\n2\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010 \u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b \u0010\u0011J\u0015\u0010\"\u001a\b\u0018\u00010!R\u00020\u0000H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0013H\u0082\b\u00a2\u0006\u0004\b$\u0010\u0015J\u0010\u0010%\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0004\b%\u0010\u0017J-\u0010'\u001a\u00020\u00132\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\f\u00a2\u0006\u0004\b'\u0010(J\u001b\u0010*\u001a\u00020\u00132\n\u0010)\u001a\u00060\u0018j\u0002`\u0019H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010,\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b,\u0010-J\u0010\u0010.\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0004\b.\u0010\u0017J\u001b\u00100\u001a\u00020\u00012\n\u0010/\u001a\u00060!R\u00020\u0000H\u0002\u00a2\u0006\u0004\b0\u00101J\u0015\u00102\u001a\b\u0018\u00010!R\u00020\u0000H\u0002\u00a2\u0006\u0004\b2\u0010#J\u001b\u00105\u001a\u00020\f2\n\u0010/\u001a\u00060!R\u00020\u0000H\u0000\u00a2\u0006\u0004\b3\u00104J+\u0010:\u001a\u00020\u00132\n\u0010/\u001a\u00060!R\u00020\u00002\u0006\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b8\u00109J\u0010\u0010;\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b;\u0010-J\u0015\u0010<\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b<\u0010=J\u0015\u0010?\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u0004\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010B\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bB\u0010CJ\u000f\u0010E\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\bD\u0010\u0015J\u000f\u0010F\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bF\u0010GJ\u0010\u0010H\u001a\u00020\fH\u0082\b\u00a2\u0006\u0004\bH\u0010IJ\u0019\u0010J\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\bJ\u0010KJ\u000f\u0010L\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bL\u0010IJ+\u0010M\u001a\u0004\u0018\u00010\n*\b\u0018\u00010!R\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010&\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bM\u0010NR\u0017\u0010\u0010\u001a\u00020\u00018\u00c2\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0017R\u0016\u0010\u0002\u001a\u00020\u00018\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010PR\u0017\u0010 \u001a\u00020\u00018\u00c2\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0017R\u0016\u0010S\u001a\u00020R8\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0016\u0010U\u001a\u00020R8\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010TR\u0016\u0010\u0005\u001a\u00020\u00048\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010VR\u0013\u0010W\u001a\u00020\f8F@\u0006\u00a2\u0006\u0006\u001a\u0004\bW\u0010IR\u0016\u0010\u0003\u001a\u00020\u00018\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010PR\u0016\u0010\u0007\u001a\u00020\u00068\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010XR\"\u0010Z\u001a\u000e\u0012\n\u0012\b\u0018\u00010!R\u00020\u00000Y8\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bZ\u0010[\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler;", "", "corePoolSize", "maxPoolSize", "", "idleWorkerKeepAliveNs", "", "schedulerName", "<init>", "(IIJLjava/lang/String;)V", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/Task;", "task", "", "addToGlobalQueue", "(Lkotlinx/coroutines/scheduling/Task;)Z", "state", "availableCpuPermits", "(J)I", "blockingTasks", "", "close", "()V", "createNewWorker", "()I", "Ljava/lang/Runnable;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Runnable;", "block", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/TaskContext;", "taskContext", "createTask$kotlinx_coroutines_core", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;)Lkotlinx/coroutines/scheduling/Task;", "createTask", "createdWorkers", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "currentWorker", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "decrementBlockingTasks", "decrementCreatedWorkers", "tailDispatch", "dispatch", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;Z)V", "command", "execute", "(Ljava/lang/Runnable;)V", "incrementBlockingTasks", "()J", "incrementCreatedWorkers", "worker", "parkedWorkersStackNextIndex", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;)I", "parkedWorkersStackPop", "parkedWorkersStackPush$kotlinx_coroutines_core", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;)Z", "parkedWorkersStackPush", "oldIndex", "newIndex", "parkedWorkersStackTopUpdate$kotlinx_coroutines_core", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;II)V", "parkedWorkersStackTopUpdate", "releaseCpuPermit", "runSafely", "(Lkotlinx/coroutines/scheduling/Task;)V", "timeout", "shutdown", "(J)V", "skipUnpark", "signalBlockingWork", "(Z)V", "signalCpuWork$kotlinx_coroutines_core", "signalCpuWork", "toString", "()Ljava/lang/String;", "tryAcquireCpuPermit", "()Z", "tryCreateWorker", "(J)Z", "tryUnpark", "submitToLocalQueue", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;Lkotlinx/coroutines/scheduling/Task;Z)Lkotlinx/coroutines/scheduling/Task;", "getAvailableCpuPermits", "I", "getCreatedWorkers", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/GlobalQueue;", "globalBlockingQueue", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/GlobalQueue;", "globalCpuQueue", "J", "isTerminated", "Ljava/lang/String;", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "workers", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "Companion", "Worker", "WorkerState", "kotlinx-coroutines-core", "Ljava/util/concurrent/Executor;", "Ljava/io/Closeable;"})
public final class CoroutineScheduler
implements Closeable,
Executor {
    @JvmField
    @NotNull
    public final GlobalQueue globalCpuQueue;
    @JvmField
    @NotNull
    public final GlobalQueue globalBlockingQueue;
    private volatile long parkedWorkersStack;
    private static final AtomicLongFieldUpdater parkedWorkersStack$FU;
    @JvmField
    @NotNull
    public final AtomicReferenceArray<Worker> workers;
    volatile long controlState;
    static final AtomicLongFieldUpdater controlState$FU;
    private volatile int _isTerminated;
    private static final AtomicIntegerFieldUpdater _isTerminated$FU;
    @JvmField
    public final int corePoolSize;
    @JvmField
    public final int maxPoolSize;
    @JvmField
    public final long idleWorkerKeepAliveNs;
    @JvmField
    @NotNull
    public final String schedulerName;
    @JvmField
    @NotNull
    public static final Symbol NOT_IN_STACK;
    public static final Companion Companion;

    private final boolean addToGlobalQueue(Task task) {
        Task $this$isBlocking$iv = task;
        boolean $i$f$isBlocking = false;
        return $this$isBlocking$iv.taskContext.getTaskMode() == 1 ? this.globalBlockingQueue.addLast(task) : this.globalCpuQueue.addLast(task);
    }

    public final void parkedWorkersStackTopUpdate$kotlinx_coroutines_core(@NotNull Worker worker, int oldIndex, int newIndex) {
        long updVersion;
        long top;
        int n;
        int updIndex;
        CoroutineScheduler $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (index == oldIndex) {
                if (newIndex == 0) {
                    n = this.parkedWorkersStackNextIndex(worker);
                    continue;
                }
                n = newIndex;
                continue;
            }
            n = index;
        } while ((updIndex = n) < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    public final boolean parkedWorkersStackPush$kotlinx_coroutines_core(@NotNull Worker worker) {
        int updIndex;
        long updVersion;
        long top;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return false;
        }
        CoroutineScheduler $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            updIndex = worker.getIndexInArray();
            boolean bl2 = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl3 = false;
                if (!(updIndex != 0)) {
                    throw (Throwable)((Object)new AssertionError());
                }
            }
            worker.setNextParkedWorker(this.workers.get(index));
        } while (!parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
        return true;
    }

    private final Worker parkedWorkersStackPop() {
        long updVersion;
        long top;
        Worker worker;
        int updIndex;
        CoroutineScheduler $this$loop$iv = this;
        boolean $i$f$loop = false;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            boolean bl = false;
            int index = (int)(top & 0x1FFFFFL);
            if (this.workers.get(index) == null) {
                return null;
            }
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((updIndex = this.parkedWorkersStackNextIndex(worker)) < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
        worker.setNextParkedWorker(NOT_IN_STACK);
        return worker;
    }

    private final int parkedWorkersStackNextIndex(Worker worker) {
        Object next = worker.getNextParkedWorker();
        while (next != NOT_IN_STACK) {
            if (next == null) {
                return 0;
            }
            Worker nextWorker = (Worker)next;
            int updIndex = nextWorker.getIndexInArray();
            if (updIndex != 0) {
                return updIndex;
            }
            next = nextWorker.getNextParkedWorker();
        }
        return -1;
    }

    private final int getCreatedWorkers() {
        int $i$f$getCreatedWorkers = 0;
        return (int)(this.controlState & 0x1FFFFFL);
    }

    public final boolean isTerminated() {
        return this._isTerminated != 0;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        CoroutineScheduler.dispatch$default(this, command, null, false, 6, null);
    }

    @Override
    public void close() {
        this.shutdown(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void shutdown(long timeout) {
        boolean bl6;
        if (!_isTerminated$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        Worker currentWorker = this.currentWorker();
        AtomicReferenceArray<Worker> lock$iv22 = this.workers;
        int $i$f$synchronized = 0;
        boolean bl2 = false;
        int n = 0;
        synchronized (lock$iv22) {
            bl6 = false;
            CoroutineScheduler this_$iv = this;
            boolean $i$f$getCreatedWorkers = false;
            n = (int)(this_$iv.controlState & 0x1FFFFFL);
        }
        int created = n;
        int lock$iv22 = 1;
        $i$f$synchronized = created;
        if (lock$iv22 <= $i$f$synchronized) {
            while (true) {
                Worker worker;
                void i;
                if (this.workers.get((int)i) == null) {
                    Intrinsics.throwNpe();
                }
                if (worker != currentWorker) {
                    while (worker.isAlive()) {
                        LockSupport.unpark(worker);
                        worker.join(timeout);
                    }
                    WorkerState state = worker.state;
                    bl6 = false;
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl3 = false;
                        if (!(state == WorkerState.TERMINATED)) {
                            throw (Throwable)((Object)new AssertionError());
                        }
                    }
                    worker.localQueue.offloadAllWorkTo(this.globalBlockingQueue);
                }
                if (i == $i$f$synchronized) break;
                ++i;
            }
        }
        this.globalBlockingQueue.close();
        this.globalCpuQueue.close();
        while (true) {
            Runnable runnable;
            Runnable runnable2;
            if ((runnable2 = currentWorker) == null || (runnable2 = runnable2.findTask(true)) == null) {
                runnable2 = runnable = (Task)this.globalCpuQueue.removeFirstOrNull();
            }
            if (runnable2 == null) {
                runnable = (Task)this.globalBlockingQueue.removeFirstOrNull();
            }
            if (runnable == null) {
                break;
            }
            Runnable task = runnable;
            this.runSafely((Task)task);
        }
        Worker worker = currentWorker;
        if (worker != null) {
            worker.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.TERMINATED);
        }
        boolean bl4 = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl5 = false;
            CoroutineScheduler this_$iv = this;
            boolean $i$f$getAvailableCpuPermits = false;
            CoroutineScheduler bl6 = this_$iv;
            long state$iv$iv = this_$iv.controlState;
            boolean $i$f$availableCpuPermits = false;
            if (!((int)((state$iv$iv & 0x7FFFFC0000000000L) >> 42) == this.corePoolSize)) {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        this.parkedWorkersStack = 0L;
        this.controlState = 0L;
    }

    public final void dispatch(@NotNull Runnable block, @NotNull TaskContext taskContext, boolean tailDispatch) {
        boolean bl = false;
        TimeSource timeSource = TimeSourceKt.getTimeSource();
        if (timeSource != null) {
            timeSource.trackTask();
        }
        Task task = this.createTask$kotlinx_coroutines_core(block, taskContext);
        Worker currentWorker = this.currentWorker();
        Task notAdded = this.submitToLocalQueue(currentWorker, task, tailDispatch);
        if (notAdded != null && !this.addToGlobalQueue(notAdded)) {
            throw (Throwable)new RejectedExecutionException(this.schedulerName + " was terminated");
        }
        boolean skipUnpark = tailDispatch && currentWorker != null;
        Task this_$iv = task;
        boolean $i$f$getMode = false;
        if (this_$iv.taskContext.getTaskMode() == 0) {
            if (skipUnpark) {
                return;
            }
            this.signalCpuWork$kotlinx_coroutines_core();
        } else {
            this.signalBlockingWork(skipUnpark);
        }
    }

    public static /* synthetic */ void dispatch$default(CoroutineScheduler coroutineScheduler, Runnable runnable, TaskContext taskContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            taskContext = NonBlockingContext.INSTANCE;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        coroutineScheduler.dispatch(runnable, taskContext, bl);
    }

    @NotNull
    public final Task createTask$kotlinx_coroutines_core(@NotNull Runnable block, @NotNull TaskContext taskContext) {
        long nanoTime = TasksKt.schedulerTimeSource.nanoTime();
        if (block instanceof Task) {
            ((Task)block).submissionTime = nanoTime;
            ((Task)block).taskContext = taskContext;
            return (Task)block;
        }
        return new TaskImpl(block, nanoTime, taskContext);
    }

    private final void signalBlockingWork(boolean skipUnpark) {
        CoroutineScheduler this_$iv = this;
        boolean $i$f$incrementBlockingTasks = false;
        long stateSnapshot = controlState$FU.addAndGet(this_$iv, 0x200000L);
        if (skipUnpark) {
            return;
        }
        if (this.tryUnpark()) {
            return;
        }
        if (this.tryCreateWorker(stateSnapshot)) {
            return;
        }
        this.tryUnpark();
    }

    public final void signalCpuWork$kotlinx_coroutines_core() {
        if (this.tryUnpark()) {
            return;
        }
        if (CoroutineScheduler.tryCreateWorker$default(this, 0L, 1, null)) {
            return;
        }
        this.tryUnpark();
    }

    private final boolean tryCreateWorker(long state) {
        CoroutineScheduler this_$iv = this;
        boolean $i$f$createdWorkers = false;
        int created = (int)(state & 0x1FFFFFL);
        CoroutineScheduler this_$iv2 = this;
        boolean $i$f$blockingTasks = false;
        int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
        int cpuWorkers = RangesKt.coerceAtLeast((int)(created - blocking), (int)0);
        if (cpuWorkers < this.corePoolSize) {
            int newCpuWorkers = this.createNewWorker();
            if (newCpuWorkers == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (newCpuWorkers > 0) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ boolean tryCreateWorker$default(CoroutineScheduler coroutineScheduler, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = coroutineScheduler.controlState;
        }
        return coroutineScheduler.tryCreateWorker(l);
    }

    private final boolean tryUnpark() {
        Worker worker;
        do {
            if (this.parkedWorkersStackPop() != null) continue;
            return false;
        } while (!Worker.workerCtl$FU.compareAndSet(worker, -1, 0));
        LockSupport.unpark(worker);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int createNewWorker() {
        AtomicReferenceArray<Worker> lock$iv = this.workers;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            void this_$iv;
            int cpuWorkers;
            block10: {
                int created;
                block9: {
                    block8: {
                        boolean bl3 = false;
                        if (!this.isTerminated()) break block8;
                        int n = -1;
                        return n;
                    }
                    long state = this.controlState;
                    CoroutineScheduler this_$iv2 = this;
                    boolean $i$f$createdWorkers = false;
                    created = (int)(state & 0x1FFFFFL);
                    CoroutineScheduler this_$iv3 = this;
                    boolean $i$f$blockingTasks = false;
                    int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
                    cpuWorkers = RangesKt.coerceAtLeast((int)(created - blocking), (int)0);
                    if (cpuWorkers < this.corePoolSize) break block9;
                    int n = 0;
                    return n;
                }
                if (created < this.maxPoolSize) break block10;
                int n = 0;
                return n;
            }
            CoroutineScheduler this_$iv22 = this;
            boolean $i$f$getCreatedWorkers22 = false;
            int newIndex = (int)(this_$iv22.controlState & 0x1FFFFFL) + 1;
            boolean this_$iv22 = newIndex > 0 && this.workers.get(newIndex) == null;
            $i$f$getCreatedWorkers22 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (!this_$iv22) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Worker worker = new Worker(newIndex);
            this.workers.set(newIndex, worker);
            CoroutineScheduler $i$f$getCreatedWorkers22 = this;
            int n = newIndex;
            boolean $i$f$incrementCreatedWorkers = false;
            void var15_27 = this_$iv;
            long state$iv$iv = controlState$FU.incrementAndGet(this_$iv);
            boolean $i$f$createdWorkers = false;
            int n2 = (int)(state$iv$iv & 0x1FFFFFL);
            boolean bl7 = n == n2;
            bl4 = false;
            boolean bl8 = false;
            bl8 = false;
            boolean bl9 = false;
            if (!bl7) {
                boolean bl10 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            worker.start();
            int n3 = cpuWorkers + 1;
            return n3;
        }
    }

    private final Task submitToLocalQueue(@Nullable Worker $this$submitToLocalQueue, Task task, boolean tailDispatch) {
        if ($this$submitToLocalQueue == null) {
            return task;
        }
        if ($this$submitToLocalQueue.state == WorkerState.TERMINATED) {
            return task;
        }
        Task this_$iv = task;
        boolean $i$f$getMode = false;
        if (this_$iv.taskContext.getTaskMode() == 0 && $this$submitToLocalQueue.state == WorkerState.BLOCKING) {
            return task;
        }
        $this$submitToLocalQueue.mayHaveLocalTasks = true;
        return $this$submitToLocalQueue.localQueue.add(task, tailDispatch);
    }

    private final Worker currentWorker() {
        Worker worker;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof Worker)) {
            thread = null;
        }
        Worker worker2 = (Worker)thread;
        if (worker2 != null) {
            Worker worker3 = worker2;
            boolean bl = false;
            boolean bl2 = false;
            Worker it = worker3;
            boolean bl3 = false;
            Worker this_$iv = it;
            boolean $i$f$getScheduler = false;
            worker = Intrinsics.areEqual((Object)this_$iv.CoroutineScheduler.this, (Object)this) ? worker3 : null;
        } else {
            worker = null;
        }
        return worker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        CoroutineScheduler worker;
        int parkedWorkers = 0;
        int blockingWorkers = 0;
        int cpuWorkers = 0;
        int dormant = 0;
        int terminated = 0;
        int n = 0;
        ArrayList queueSizes = new ArrayList();
        n = 1;
        int n2 = this.workers.length();
        while (n < n2) {
            void index;
            if (this.workers.get((int)index) == null) {
            } else {
                int queueSize = ((Worker)((Object)worker)).localQueue.getSize$kotlinx_coroutines_core();
                switch (CoroutineScheduler$WhenMappings.$EnumSwitchMapping$0[((Worker)((Object)worker)).state.ordinal()]) {
                    case 1: {
                        ++parkedWorkers;
                        break;
                    }
                    case 2: {
                        ++blockingWorkers;
                        Collection collection = queueSizes;
                        String string = String.valueOf(queueSize) + "b";
                        boolean bl = false;
                        collection.add(string);
                        break;
                    }
                    case 3: {
                        ++cpuWorkers;
                        Collection collection = queueSizes;
                        String string = String.valueOf(queueSize) + "c";
                        boolean bl = false;
                        collection.add(string);
                        break;
                    }
                    case 4: {
                        ++dormant;
                        if (queueSize <= 0) break;
                        Collection collection = queueSizes;
                        String string = String.valueOf(queueSize) + "d";
                        boolean bl = false;
                        collection.add(string);
                        break;
                    }
                    case 5: {
                        ++terminated;
                        break;
                    }
                }
            }
            ++index;
        }
        long state = this.controlState;
        worker = this;
        StringBuilder stringBuilder = new StringBuilder().append(this.schedulerName).append('@').append(DebugStringsKt.getHexAddress(this)).append('[').append("Pool Size {").append("core = ").append(this.corePoolSize).append(", ").append("max = ").append(this.maxPoolSize).append("}, ").append("Worker States {").append("CPU = ").append(cpuWorkers).append(", ").append("blocking = ").append(blockingWorkers).append(", ").append("parked = ").append(parkedWorkers).append(", ").append("dormant = ").append(dormant).append(", ").append("terminated = ").append(terminated).append("}, ").append("running workers queues = ").append(queueSizes).append(", ").append("global CPU queue size = ").append(this.globalCpuQueue.getSize()).append(", ").append("global blocking queue size = ").append(this.globalBlockingQueue.getSize()).append(", ").append("Control State {").append("created workers= ");
        boolean $i$f$createdWorkers = false;
        int n3 = (int)(state & 0x1FFFFFL);
        CoroutineScheduler this_$iv = this;
        stringBuilder = stringBuilder.append(n3).append(", ").append("blocking tasks = ");
        boolean $i$f$blockingTasks = false;
        n3 = (int)((state & 0x3FFFFE00000L) >> 21);
        StringBuilder stringBuilder2 = stringBuilder.append(n3).append(", ").append("CPUs acquired = ");
        this_$iv = this;
        n3 = this.corePoolSize;
        stringBuilder = stringBuilder2;
        boolean $i$f$availableCpuPermits = false;
        int n4 = (int)((state & 0x7FFFFC0000000000L) >> 42);
        return stringBuilder.append(n3 - n4).append("}]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runSafely(@NotNull Task task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
        }
        finally {
            boolean bl = false;
            TimeSource timeSource = TimeSourceKt.getTimeSource();
            if (timeSource != null) {
                timeSource.unTrackTask();
            }
        }
    }

    public CoroutineScheduler(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, @NotNull String schedulerName) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.schedulerName = schedulerName;
        boolean bl = this.corePoolSize >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Core pool size " + this.corePoolSize + " should be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.maxPoolSize >= this.corePoolSize;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Max pool size " + this.maxPoolSize + " should be greater than or equals to core pool size " + this.corePoolSize;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.maxPoolSize <= 0x1FFFFE;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Max pool size " + this.maxPoolSize + " should not exceed maximal supported number of threads 2097150";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.idleWorkerKeepAliveNs > 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "Idle worker keep alive time " + this.idleWorkerKeepAliveNs + " must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.globalCpuQueue = new GlobalQueue();
        this.globalBlockingQueue = new GlobalQueue();
        this.parkedWorkersStack = 0L;
        this.workers = new AtomicReferenceArray(this.maxPoolSize + 1);
        this.controlState = (long)this.corePoolSize << 42;
        this._isTerminated = 0;
    }

    static {
        Companion = new Companion(null);
        NOT_IN_STACK = new Symbol("NOT_IN_STACK");
        parkedWorkersStack$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack");
        controlState$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState");
        _isTerminated$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\b\u0080\u0004\u0018\u00002\u00020IB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0015\u0010\tJ\u000f\u0010\u0016\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0011\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b \u0010\u001dJ\u000f\u0010!\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b!\u0010\u001dJ\u000f\u0010\"\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\"\u0010\u0017J\u000f\u0010#\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b#\u0010\u001dJ\u0017\u0010(\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020$H\u0000\u00a2\u0006\u0004\b&\u0010'J\u0019\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b*\u0010\u0012J\u000f\u0010+\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b+\u0010\u001dR*\u0010,\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00018\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u0010\tR\u0016\u00102\u001a\u0002018\u0006@\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00107\u001a\u0002068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R$\u0010:\u001a\u0004\u0018\u0001098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010-R\u0014\u0010D\u001a\u00020A8\u00c6\u0002@\u0006\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0016\u0010E\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0016\u0010G\u001a\u0002068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u00108\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "", "index", "<init>", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;I)V", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;)V", "taskMode", "", "afterTask", "(I)V", "beforeTask", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/Task;", "task", "executeTask", "(Lkotlinx/coroutines/scheduling/Task;)V", "", "scanLocalQueue", "findAnyTask", "(Z)Lkotlinx/coroutines/scheduling/Task;", "findTask", "mode", "idleReset", "inStack", "()Z", "upperBound", "nextInt$kotlinx_coroutines_core", "(I)I", "nextInt", "park", "()V", "pollGlobalQueues", "()Lkotlinx/coroutines/scheduling/Task;", "run", "runWorker", "tryAcquireCpuPermit", "tryPark", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "newState", "tryReleaseCpu$kotlinx_coroutines_core", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;)Z", "tryReleaseCpu", "blockingOnly", "trySteal", "tryTerminateWorker", "indexInArray", "I", "getIndexInArray", "()I", "setIndexInArray", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/WorkQueue;", "localQueue", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/WorkQueue;", "mayHaveLocalTasks", "Z", "", "minDelayUntilStealableTaskNs", "J", "", "nextParkedWorker", "Ljava/lang/Object;", "getNextParkedWorker", "()Ljava/lang/Object;", "setNextParkedWorker", "(Ljava/lang/Object;)V", "rngState", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler;", "getScheduler", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "scheduler", "state", "Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "terminationDeadline", "kotlinx-coroutines-core", "Ljava/lang/Thread;"})
    public final class Worker
    extends Thread {
        private volatile int indexInArray;
        @JvmField
        @NotNull
        public final WorkQueue localQueue;
        @JvmField
        @NotNull
        public WorkerState state;
        @NotNull
        volatile int workerCtl;
        static final AtomicIntegerFieldUpdater workerCtl$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "workerCtl");
        private long terminationDeadline;
        @Nullable
        private volatile Object nextParkedWorker;
        private long minDelayUntilStealableTaskNs;
        private int rngState;
        @JvmField
        public boolean mayHaveLocalTasks;

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        public final void setIndexInArray(int index) {
            this.setName(CoroutineScheduler.this.schedulerName + "-worker-" + (index == 0 ? "TERMINATED" : String.valueOf(index)));
            this.indexInArray = index;
        }

        @Nullable
        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        public final void setNextParkedWorker(@Nullable Object object) {
            this.nextParkedWorker = object;
        }

        private final boolean tryAcquireCpuPermit() {
            boolean bl;
            if (this.state == WorkerState.CPU_ACQUIRED) {
                bl = true;
            } else {
                boolean bl2;
                block5: {
                    long update$iv;
                    long state$iv;
                    CoroutineScheduler this_$iv = CoroutineScheduler.this;
                    boolean $i$f$tryAcquireCpuPermit = false;
                    CoroutineScheduler $this$loop$iv$iv = this_$iv;
                    boolean $i$f$loop = false;
                    do {
                        state$iv = $this$loop$iv$iv.controlState;
                        boolean bl3 = false;
                        CoroutineScheduler this_$iv$iv = this_$iv;
                        boolean $i$f$availableCpuPermits = false;
                        int available$iv = (int)((state$iv & 0x7FFFFC0000000000L) >> 42);
                        if (available$iv != 0) continue;
                        bl2 = false;
                        break block5;
                    } while (!controlState$FU.compareAndSet(this_$iv, state$iv, update$iv = state$iv - 0x40000000000L));
                    bl2 = true;
                }
                if (bl2) {
                    this.state = WorkerState.CPU_ACQUIRED;
                    bl = true;
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean tryReleaseCpu$kotlinx_coroutines_core(@NotNull WorkerState newState) {
            boolean hadCpu;
            WorkerState previousState = this.state;
            boolean bl = hadCpu = previousState == WorkerState.CPU_ACQUIRED;
            if (hadCpu) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                boolean $i$f$releaseCpuPermit = false;
                controlState$FU.addAndGet(this_$iv, 0x40000000000L);
            }
            if (previousState != newState) {
                this.state = newState;
            }
            return hadCpu;
        }

        @Override
        public void run() {
            this.runWorker();
        }

        private final void runWorker() {
            boolean rescanned = false;
            while (!CoroutineScheduler.this.isTerminated() && this.state != WorkerState.TERMINATED) {
                Task task = this.findTask(this.mayHaveLocalTasks);
                if (task != null) {
                    rescanned = false;
                    this.minDelayUntilStealableTaskNs = 0L;
                    this.executeTask(task);
                    continue;
                }
                this.mayHaveLocalTasks = false;
                if (this.minDelayUntilStealableTaskNs != 0L) {
                    if (!rescanned) {
                        rescanned = true;
                        continue;
                    }
                    rescanned = false;
                    this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.PARKING);
                    Thread.interrupted();
                    LockSupport.parkNanos(this.minDelayUntilStealableTaskNs);
                    this.minDelayUntilStealableTaskNs = 0L;
                    continue;
                }
                this.tryPark();
            }
            this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.TERMINATED);
        }

        private final void tryPark() {
            if (!this.inStack()) {
                CoroutineScheduler.this.parkedWorkersStackPush$kotlinx_coroutines_core(this);
                return;
            }
            boolean bl = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl2 = false;
                if (!(this.localQueue.getSize$kotlinx_coroutines_core() == 0)) {
                    throw (Throwable)((Object)new AssertionError());
                }
            }
            this.workerCtl = -1;
            while (this.inStack() && !CoroutineScheduler.this.isTerminated() && this.state != WorkerState.TERMINATED) {
                this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.PARKING);
                Thread.interrupted();
                this.park();
            }
        }

        private final boolean inStack() {
            return this.nextParkedWorker != NOT_IN_STACK;
        }

        private final void executeTask(Task task) {
            Task this_$iv = task;
            boolean $i$f$getMode = false;
            int taskMode = this_$iv.taskContext.getTaskMode();
            this.idleReset(taskMode);
            this.beforeTask(taskMode);
            CoroutineScheduler.this.runSafely(task);
            this.afterTask(taskMode);
        }

        private final void beforeTask(int taskMode) {
            if (taskMode == 0) {
                return;
            }
            if (this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.BLOCKING)) {
                CoroutineScheduler.this.signalCpuWork$kotlinx_coroutines_core();
            }
        }

        private final void afterTask(int taskMode) {
            if (taskMode == 0) {
                return;
            }
            CoroutineScheduler this_$iv = CoroutineScheduler.this;
            boolean $i$f$decrementBlockingTasks = false;
            controlState$FU.addAndGet(this_$iv, -2097152L);
            WorkerState currentState = this.state;
            if (currentState != WorkerState.TERMINATED) {
                boolean bl = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl2 = false;
                    if (!(currentState == WorkerState.BLOCKING)) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                }
                this.state = WorkerState.DORMANT;
            }
        }

        public final int nextInt$kotlinx_coroutines_core(int upperBound) {
            int r = this.rngState;
            r ^= r << 13;
            r ^= r >> 17;
            r ^= r << 5;
            this.rngState = r;
            int mask = upperBound - 1;
            if ((mask & upperBound) == 0) {
                return r & mask;
            }
            return (r & Integer.MAX_VALUE) % upperBound;
        }

        private final void park() {
            if (this.terminationDeadline == 0L) {
                this.terminationDeadline = System.nanoTime() + CoroutineScheduler.this.idleWorkerKeepAliveNs;
            }
            LockSupport.parkNanos(CoroutineScheduler.this.idleWorkerKeepAliveNs);
            if (System.nanoTime() - this.terminationDeadline >= 0L) {
                this.terminationDeadline = 0L;
                this.tryTerminateWorker();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void tryTerminateWorker() {
            AtomicReferenceArray<Worker> lock$iv = CoroutineScheduler.this.workers;
            boolean $i$f$synchronized = false;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (lock$iv) {
                boolean bl3 = false;
                if (CoroutineScheduler.this.isTerminated()) {
                    return;
                }
                if (CoroutineScheduler.this.getCreatedWorkers() <= CoroutineScheduler.this.corePoolSize) {
                    return;
                }
                if (!workerCtl$FU.compareAndSet(this, -1, 1)) {
                    return;
                }
                int oldIndex = this.indexInArray;
                this.setIndexInArray(0);
                CoroutineScheduler.this.parkedWorkersStackTopUpdate$kotlinx_coroutines_core(this, oldIndex, 0);
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                boolean $i$f$decrementCreatedWorkers = false;
                CoroutineScheduler coroutineScheduler = this_$iv;
                long state$iv$iv = controlState$FU.getAndDecrement(this_$iv);
                boolean $i$f$createdWorkers = false;
                int lastIndex = (int)(state$iv$iv & 0x1FFFFFL);
                if (lastIndex != oldIndex) {
                    Worker worker = CoroutineScheduler.this.workers.get(lastIndex);
                    if (worker == null) {
                        Intrinsics.throwNpe();
                    }
                    Worker lastWorker = worker;
                    CoroutineScheduler.this.workers.set(oldIndex, lastWorker);
                    lastWorker.setIndexInArray(oldIndex);
                    CoroutineScheduler.this.parkedWorkersStackTopUpdate$kotlinx_coroutines_core(lastWorker, lastIndex, oldIndex);
                }
                CoroutineScheduler.this.workers.set(lastIndex, null);
                Unit unit = Unit.INSTANCE;
            }
            this.state = WorkerState.TERMINATED;
        }

        private final void idleReset(int mode) {
            this.terminationDeadline = 0L;
            if (this.state == WorkerState.PARKING) {
                boolean bl = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl2 = false;
                    if (!(mode == 1)) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                }
                this.state = WorkerState.BLOCKING;
            }
        }

        @Nullable
        public final Task findTask(boolean scanLocalQueue) {
            Task task;
            Task task2;
            Task task3;
            if (this.tryAcquireCpuPermit()) {
                return this.findAnyTask(scanLocalQueue);
            }
            if (scanLocalQueue) {
                task3 = this.localQueue.poll();
                if (task3 == null) {
                    task3 = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
                }
            } else {
                task3 = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            }
            if ((task2 = (task = task3)) == null) {
                task2 = this.trySteal(true);
            }
            return task2;
        }

        private final Task findAnyTask(boolean scanLocalQueue) {
            if (scanLocalQueue) {
                boolean globalFirst;
                boolean bl = globalFirst = this.nextInt$kotlinx_coroutines_core(2 * CoroutineScheduler.this.corePoolSize) == 0;
                if (globalFirst) {
                    Task task = this.pollGlobalQueues();
                    if (task != null) {
                        Task task2 = task;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Task it = task2;
                        boolean bl4 = false;
                        return it;
                    }
                }
                Task task = this.localQueue.poll();
                if (task != null) {
                    Task task3 = task;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Task it = task3;
                    boolean bl7 = false;
                    return it;
                }
                if (!globalFirst) {
                    Task task4 = this.pollGlobalQueues();
                    if (task4 != null) {
                        Task task5 = task4;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        Task it = task5;
                        boolean bl10 = false;
                        return it;
                    }
                }
            } else {
                Task task = this.pollGlobalQueues();
                if (task != null) {
                    Task task6 = task;
                    boolean bl = false;
                    boolean bl11 = false;
                    Task it = task6;
                    boolean bl12 = false;
                    return it;
                }
            }
            return this.trySteal(false);
        }

        private final Task pollGlobalQueues() {
            if (this.nextInt$kotlinx_coroutines_core(2) == 0) {
                Task task = (Task)CoroutineScheduler.this.globalCpuQueue.removeFirstOrNull();
                if (task != null) {
                    Task task2 = task;
                    boolean bl = false;
                    boolean bl2 = false;
                    Task it = task2;
                    boolean bl3 = false;
                    return it;
                }
                return (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            }
            Task task = (Task)CoroutineScheduler.this.globalBlockingQueue.removeFirstOrNull();
            if (task != null) {
                Task task3 = task;
                boolean bl = false;
                boolean bl4 = false;
                Task it = task3;
                boolean bl5 = false;
                return it;
            }
            return (Task)CoroutineScheduler.this.globalCpuQueue.removeFirstOrNull();
        }

        private final Task trySteal(boolean blockingOnly) {
            int created;
            boolean bl = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl2 = false;
                if (!(this.localQueue.getSize$kotlinx_coroutines_core() == 0)) {
                    throw (Throwable)((Object)new AssertionError());
                }
            }
            if ((created = CoroutineScheduler.this.getCreatedWorkers()) < 2) {
                return null;
            }
            int currentIndex = this.nextInt$kotlinx_coroutines_core(created);
            long minDelay = Long.MAX_VALUE;
            boolean bl3 = false;
            int n = 0;
            int n2 = created;
            for (n = 0; n < n2; ++n) {
                long l;
                long stealResult;
                Worker worker;
                int it = n;
                boolean bl4 = false;
                if (++currentIndex > created) {
                    currentIndex = 1;
                }
                if ((worker = CoroutineScheduler.this.workers.get(currentIndex)) == null || worker == this) continue;
                boolean bl5 = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl6 = false;
                    if (!(this.localQueue.getSize$kotlinx_coroutines_core() == 0)) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                }
                long l2 = stealResult = blockingOnly ? this.localQueue.tryStealBlockingFrom(worker.localQueue) : this.localQueue.tryStealFrom(worker.localQueue);
                if (stealResult == -1L) {
                    return this.localQueue.poll();
                }
                if (stealResult <= 0L) continue;
                long l3 = minDelay;
                boolean bl7 = false;
                minDelay = l = Math.min(l3, stealResult);
            }
            this.minDelayUntilStealableTaskNs = minDelay != Long.MAX_VALUE ? minDelay : 0L;
            return null;
        }

        private Worker() {
            this.setDaemon(true);
            this.localQueue = new WorkQueue();
            this.state = WorkerState.DORMANT;
            this.workerCtl = 0;
            this.nextParkedWorker = NOT_IN_STACK;
            this.rngState = Random.Default.nextInt();
        }

        public Worker(int index) {
            this();
            this.setIndexInArray(index);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "", "(Ljava/lang/String;I)V", "CPU_ACQUIRED", "BLOCKING", "PARKING", "DORMANT", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class WorkerState
    extends Enum<WorkerState> {
        public static final /* enum */ WorkerState CPU_ACQUIRED;
        public static final /* enum */ WorkerState BLOCKING;
        public static final /* enum */ WorkerState PARKING;
        public static final /* enum */ WorkerState DORMANT;
        public static final /* enum */ WorkerState TERMINATED;
        private static final /* synthetic */ WorkerState[] $VALUES;

        static {
            WorkerState[] workerStateArray = new WorkerState[5];
            WorkerState[] workerStateArray2 = workerStateArray;
            workerStateArray[0] = CPU_ACQUIRED = new WorkerState();
            workerStateArray[1] = BLOCKING = new WorkerState();
            workerStateArray[2] = PARKING = new WorkerState();
            workerStateArray[3] = DORMANT = new WorkerState();
            workerStateArray[4] = TERMINATED = new WorkerState();
            $VALUES = workerStateArray;
        }

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/scheduling/CoroutineScheduler$Companion;", "", "()V", "BLOCKING_MASK", "", "BLOCKING_SHIFT", "", "CLAIMED", "CPU_PERMITS_MASK", "CPU_PERMITS_SHIFT", "CREATED_MASK", "MAX_SUPPORTED_POOL_SIZE", "MIN_SUPPORTED_POOL_SIZE", "NOT_IN_STACK", "Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/Symbol;", "PARKED", "PARKED_INDEX_MASK", "PARKED_VERSION_INC", "PARKED_VERSION_MASK", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

