/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dsl;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependencyRepository;
import com.intellij.externalSystem.ExternalDependencyModificator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomRepositories;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;
import org.jetbrains.idea.maven.dsl.MavenDependencyModificatorKt;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J.\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010$0#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010(\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010,\u001a\u0004\u0018\u00010\u001d2\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010.\u001a\u0004\u0018\u00010\u001dH\u0002J \u0010/\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0016J&\u00102\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d042\u0006\u00105\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/idea/maven/dsl/MavenDependencyModificator;", "Lcom/intellij/externalSystem/ExternalDependencyModificator;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "myProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "addDependenciesTagIfNotExists", "", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "model", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "addDependency", "module", "Lcom/intellij/openapi/module/Module;", "descriptor", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "addRepositoriesTagIfNotExists", "addRepository", "repository", "Lcom/intellij/buildsystem/model/unified/UnifiedDependencyRepository;", "addTagIfNotExists", "element", "Lorg/jetbrains/idea/maven/dom/MavenDomElement;", "elementsBefore", "", "", "declaredDependencies", "", "declaredRepositories", "deleteRepository", "getDependenciesModel", "Lkotlin/Pair;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "groupId", "artifactId", "removeDependency", "saveFile", "Lorg/jetbrains/annotations/NotNull;", "supports", "", "toMavenScope", "scope", "managedScope", "updateDependency", "oldDescriptor", "newDescriptor", "updateVariableOrValue", "domValue", "Lcom/intellij/util/xml/GenericDomValue;", "newValue", "intellij.maven"})
public final class MavenDependencyModificator
implements ExternalDependencyModificator {
    private final MavenProjectsManager myProjectsManager;
    private final PsiDocumentManager myDocumentManager;
    private final Project myProject;

    private final void addDependenciesTagIfNotExists(XmlFile psiFile, MavenDomProjectModel model2) {
        MavenDomDependencies mavenDomDependencies = model2.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"model.dependencies");
        this.addTagIfNotExists(psiFile, mavenDomDependencies, MavenDependencyModificatorKt.getElementsBeforeDependencies());
    }

    private final void addRepositoriesTagIfNotExists(XmlFile psiFile, MavenDomProjectModel model2) {
        MavenDomRepositories mavenDomRepositories = model2.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories, (String)"model.repositories");
        this.addTagIfNotExists(psiFile, mavenDomRepositories, MavenDependencyModificatorKt.getElementsBeforeRepositories());
    }

    /*
     * WARNING - void declaration
     */
    private final void addTagIfNotExists(XmlFile psiFile, MavenDomElement element, Set<String> elementsBefore) {
        Object v1;
        XmlTag rootTag;
        block8: {
            void $this$mapNotNullTo$iv$iv;
            PsiElement[] children;
            block10: {
                block9: {
                    if (element.exists()) {
                        return;
                    }
                    rootTag = psiFile.getRootTag();
                    if (rootTag == null) {
                        element.ensureTagExists();
                        return;
                    }
                    children = rootTag.getChildren();
                    if (children == null) break block9;
                    PsiElement[] psiElementArray = children;
                    boolean bl = false;
                    if (!(psiElementArray.length == 0)) break block10;
                }
                element.ensureTagExists();
                return;
            }
            PsiElement[] $this$mapNotNull$iv = children;
            boolean $i$f$mapNotNull = false;
            PsiElement[] psiElementArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var14_17 = $this$forEach$iv$iv$iv;
            int n = ((void)var14_17).length;
            for (int i = 0; i < n; ++i) {
                XmlTag xmlTag;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var14_17[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                Object v0 = it;
                if (!(v0 instanceof XmlTag)) {
                    v0 = null;
                }
                if ((XmlTag)v0 == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                XmlTag it$iv$iv = xmlTag;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List $this$lastOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                XmlTag it = (XmlTag)element$iv;
                boolean bl = false;
                if (!elementsBefore.contains(it.getName())) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        XmlTag lastOrNull = v1;
        XmlTag child = rootTag.createChildTag(element.getXmlElementName(), rootTag.getNamespace(), null, false);
        rootTag.addAfter((PsiElement)child, (PsiElement)lastOrNull);
    }

    private final Pair<MavenDomProjectModel, MavenDomDependency> getDependenciesModel(Module module, String groupId, String artifactId) {
        MavenProject mavenProject = this.myProjectsManager.findProject(module);
        if (mavenProject == null) {
            throw (Throwable)new IllegalArgumentException(MavenProjectBundle.message("maven.project.not.found.for", module.getName()));
        }
        MavenProject project = mavenProject;
        Object object = ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Pair<? extends MavenDomProjectModel, ? extends MavenDomDependency>, Throwable>(this, project, module, groupId, artifactId){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenProject $project;
            final /* synthetic */ Module $module;
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;

            public final Pair<MavenDomProjectModel, MavenDomDependency> compute() {
                MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(MavenDependencyModificator.access$getMyProject$p(this.this$0), this.$project.getFile());
                if (mavenDomProjectModel == null) {
                    throw (Throwable)new IllegalStateException(MavenProjectBundle.message("maven.model.error", this.$module.getName()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026del.error\", module.name))");
                MavenDomProjectModel model2 = mavenDomProjectModel;
                MavenDomDependency managedDependency = MavenDependencyCompletionUtil.findManagedDependency(model2, MavenDependencyModificator.access$getMyProject$p(this.this$0), this.$groupId, this.$artifactId);
                return new Pair((Object)model2, (Object)managedDependency);
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$project = mavenProject;
                this.$module = module;
                this.$groupId = string;
                this.$artifactId = string2;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Pair<\u2026 managedDependency)\n    }");
        return (Pair)object;
    }

    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.myProjectsManager.isMavenizedModule(module);
    }

    /*
     * WARNING - void declaration
     */
    public void addDependency(@NotNull Module module, @NotNull UnifiedDependency descriptor2) {
        void model2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        String string = descriptor2.getCoordinates().getGroupId();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        string = descriptor2.getCoordinates().getVersion();
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (string == null) {
            boolean bl5 = false;
            String string3 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        string = descriptor2.getCoordinates().getArtifactId();
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (string == null) {
            boolean bl6 = false;
            String string4 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        MavenId mavenId = MavenDependencyModificatorKt.access$toMavenId(descriptor2.getCoordinates());
        String string5 = mavenId.getGroupId();
        Intrinsics.checkNotNull((Object)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"mavenId.groupId!!");
        String string6 = mavenId.getArtifactId();
        Intrinsics.checkNotNull((Object)string6);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"mavenId.artifactId!!");
        Pair<MavenDomProjectModel, MavenDomDependency> pair = this.getDependenciesModel(module, string5, string6);
        MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)pair.component1();
        MavenDomDependency managedDependency = (MavenDomDependency)pair.component2();
        XmlFile xmlFile = DomUtil.getFile((DomElement)((DomElement)model2));
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"DomUtil.getFile(model)");
        XmlFile psiFile = xmlFile;
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{(PsiFile)psiFile}).compute((ThrowableComputable)new ThrowableComputable<Unit, Throwable>(this, psiFile, (MavenDomProjectModel)model2, mavenId, descriptor2, managedDependency){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ XmlFile $psiFile;
            final /* synthetic */ MavenDomProjectModel $model;
            final /* synthetic */ MavenId $mavenId;
            final /* synthetic */ UnifiedDependency $descriptor;
            final /* synthetic */ MavenDomDependency $managedDependency;

            public final void compute() {
                block5: {
                    MavenDomDependency dependency;
                    block4: {
                        GenericDomValue<String> genericDomValue;
                        String scope;
                        MavenDependencyModificator.access$addDependenciesTagIfNotExists(this.this$0, this.$psiFile, this.$model);
                        MavenDomDependency mavenDomDependency = MavenDomUtil.createDomDependency(this.$model, null);
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"MavenDomUtil.createDomDependency(model, null)");
                        dependency = mavenDomDependency;
                        GenericDomValue genericDomValue2 = dependency.getGroupId();
                        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"dependency.groupId");
                        genericDomValue2.setStringValue(this.$mavenId.getGroupId());
                        GenericDomValue genericDomValue3 = dependency.getArtifactId();
                        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue3, (String)"dependency.artifactId");
                        genericDomValue3.setStringValue(this.$mavenId.getArtifactId());
                        String string = scope = MavenDependencyModificator.access$toMavenScope(this.this$0, this.$descriptor.getScope(), (genericDomValue = this.$managedDependency) != null && (genericDomValue = genericDomValue.getScope()) != null ? genericDomValue.getStringValue() : null);
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            GenericDomValue<String> genericDomValue4 = dependency.getScope();
                            Intrinsics.checkNotNullExpressionValue(genericDomValue4, (String)"dependency.scope");
                            genericDomValue4.setStringValue(it);
                        }
                        if (this.$managedDependency == null) break block4;
                        GenericDomValue<String> genericDomValue5 = this.$managedDependency.getVersion();
                        Intrinsics.checkNotNullExpressionValue(genericDomValue5, (String)"managedDependency.version");
                        if (!(Intrinsics.areEqual((Object)genericDomValue5.getStringValue(), (Object)this.$mavenId.getVersion()) ^ true)) break block5;
                    }
                    GenericDomValue<String> genericDomValue = dependency.getVersion();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"dependency.version");
                    genericDomValue.setStringValue(this.$mavenId.getVersion());
                }
                MavenDependencyModificator.access$saveFile(this.this$0, this.$psiFile);
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$psiFile = xmlFile;
                this.$model = mavenDomProjectModel;
                this.$mavenId = mavenId;
                this.$descriptor = unifiedDependency;
                this.$managedDependency = mavenDomDependency;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void updateDependency(@NotNull Module module, @NotNull UnifiedDependency oldDescriptor, @NotNull UnifiedDependency newDescriptor) {
        void model2;
        MavenDomDependency mavenDomDependency;
        MavenDomDependency managedDependency;
        MavenId newMavenId;
        MavenId oldMavenId;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)oldDescriptor, (String)"oldDescriptor");
                Intrinsics.checkNotNullParameter((Object)newDescriptor, (String)"newDescriptor");
                String string = newDescriptor.getCoordinates().getGroupId();
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (string == null) {
                    boolean bl4 = false;
                    String string2 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                string = newDescriptor.getCoordinates().getVersion();
                bl = false;
                bl2 = false;
                bl2 = false;
                bl3 = false;
                if (string == null) {
                    boolean bl5 = false;
                    String string3 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                string = newDescriptor.getCoordinates().getArtifactId();
                bl = false;
                bl2 = false;
                bl2 = false;
                bl3 = false;
                if (string == null) {
                    boolean bl6 = false;
                    String string4 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string4.toString());
                }
                oldMavenId = MavenDependencyModificatorKt.access$toMavenId(oldDescriptor.getCoordinates());
                newMavenId = MavenDependencyModificatorKt.access$toMavenId(newDescriptor.getCoordinates());
                Pair pair = (Pair)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Pair<? extends MavenDomProjectModel, ? extends MavenDomDependency>, Throwable>(this, module, oldMavenId){
                    final /* synthetic */ MavenDependencyModificator this$0;
                    final /* synthetic */ Module $module;
                    final /* synthetic */ MavenId $oldMavenId;

                    public final Pair<MavenDomProjectModel, MavenDomDependency> compute() {
                        String string = this.$oldMavenId.getGroupId();
                        Intrinsics.checkNotNull((Object)string);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"oldMavenId.groupId!!");
                        String string2 = this.$oldMavenId.getArtifactId();
                        Intrinsics.checkNotNull((Object)string2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"oldMavenId.artifactId!!");
                        return MavenDependencyModificator.access$getDependenciesModel(this.this$0, this.$module, string, string2);
                    }
                    {
                        this.this$0 = mavenDependencyModificator;
                        this.$module = module;
                        this.$oldMavenId = mavenId;
                    }
                }));
                MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)pair.component1();
                managedDependency = (MavenDomDependency)pair.component2();
                mavenDomDependency = managedDependency;
                if (mavenDomDependency == null) break block6;
                MavenDomDependency mavenDomDependency2 = mavenDomDependency;
                boolean bl7 = false;
                boolean bl8 = false;
                DomElement p1 = mavenDomDependency2;
                boolean bl9 = false;
                mavenDomDependency = DomUtil.getFile((DomElement)p1);
                if (mavenDomDependency != null) break block7;
            }
            mavenDomDependency = DomUtil.getFile((DomElement)((DomElement)model2));
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"managedDependency?.let(D\u2026?: DomUtil.getFile(model)");
        MavenDomDependency psiFile = mavenDomDependency;
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{(PsiFile)psiFile}).compute((ThrowableComputable)new ThrowableComputable<Unit, Throwable>(this, managedDependency, newMavenId, newDescriptor, (MavenDomProjectModel)model2, oldMavenId, (XmlFile)psiFile){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenDomDependency $managedDependency;
            final /* synthetic */ MavenId $newMavenId;
            final /* synthetic */ UnifiedDependency $newDescriptor;
            final /* synthetic */ MavenDomProjectModel $model;
            final /* synthetic */ MavenId $oldMavenId;
            final /* synthetic */ XmlFile $psiFile;

            public final void compute() {
                if (this.$managedDependency != null) {
                    MavenDomProjectModel parentModel = (MavenDomProjectModel)this.$managedDependency.getParentOfType(MavenDomProjectModel.class, true);
                    if (parentModel != null) {
                        GenericDomValue<String> genericDomValue = this.$managedDependency.getVersion();
                        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"managedDependency.version");
                        String string = this.$newMavenId.getVersion();
                        Intrinsics.checkNotNull((Object)string);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newMavenId.version!!");
                        MavenDependencyModificator.access$updateVariableOrValue(this.this$0, parentModel, genericDomValue, string);
                    } else {
                        GenericDomValue<String> genericDomValue = this.$managedDependency.getVersion();
                        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"managedDependency.version");
                        genericDomValue.setStringValue(this.$newDescriptor.getCoordinates().getVersion());
                    }
                } else {
                    MavenDomDependencies mavenDomDependencies = this.$model.getDependencies();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"model.dependencies");
                    Iterator<MavenDomDependency> iterator = mavenDomDependencies.getDependencies().iterator();
                    while (iterator.hasNext()) {
                        MavenDomDependency dep;
                        MavenDomDependency mavenDomDependency = dep = iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"dep");
                        GenericDomValue genericDomValue = mavenDomDependency.getArtifactId();
                        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"dep.artifactId");
                        if (!Intrinsics.areEqual((Object)genericDomValue.getStringValue(), (Object)this.$oldMavenId.getArtifactId())) continue;
                        GenericDomValue genericDomValue2 = dep.getGroupId();
                        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"dep.groupId");
                        if (!Intrinsics.areEqual((Object)genericDomValue2.getStringValue(), (Object)this.$oldMavenId.getGroupId())) continue;
                        GenericDomValue genericDomValue3 = dep.getArtifactId();
                        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue3, (String)"dep.artifactId");
                        String string = this.$newMavenId.getArtifactId();
                        Intrinsics.checkNotNull((Object)string);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newMavenId.artifactId!!");
                        MavenDependencyModificator.access$updateVariableOrValue(this.this$0, this.$model, genericDomValue3, string);
                        GenericDomValue genericDomValue4 = dep.getGroupId();
                        Intrinsics.checkNotNullExpressionValue((Object)genericDomValue4, (String)"dep.groupId");
                        String string2 = this.$newMavenId.getGroupId();
                        Intrinsics.checkNotNull((Object)string2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"newMavenId.groupId!!");
                        MavenDependencyModificator.access$updateVariableOrValue(this.this$0, this.$model, genericDomValue4, string2);
                        GenericDomValue<String> genericDomValue5 = dep.getVersion();
                        Intrinsics.checkNotNullExpressionValue(genericDomValue5, (String)"dep.version");
                        String string3 = this.$newMavenId.getVersion();
                        Intrinsics.checkNotNull((Object)string3);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"newMavenId.version!!");
                        MavenDependencyModificator.access$updateVariableOrValue(this.this$0, this.$model, genericDomValue5, string3);
                    }
                }
                MavenDependencyModificator.access$saveFile(this.this$0, this.$psiFile);
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$managedDependency = mavenDomDependency;
                this.$newMavenId = mavenId;
                this.$newDescriptor = unifiedDependency;
                this.$model = mavenDomProjectModel;
                this.$oldMavenId = mavenId2;
                this.$psiFile = xmlFile;
            }
        });
    }

    public void removeDependency(@NotNull Module module, @NotNull UnifiedDependency descriptor2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        String string = descriptor2.getCoordinates().getGroupId();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        string = descriptor2.getCoordinates().getVersion();
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (string == null) {
            boolean bl5 = false;
            String string3 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        MavenId mavenId = MavenDependencyModificatorKt.access$toMavenId(descriptor2.getCoordinates());
        String string4 = mavenId.getGroupId();
        Intrinsics.checkNotNull((Object)string4);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"mavenId.groupId!!");
        String string5 = mavenId.getArtifactId();
        Intrinsics.checkNotNull((Object)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"mavenId.artifactId!!");
        Pair<MavenDomProjectModel, MavenDomDependency> pair = this.getDependenciesModel(module, string4, string5);
        MavenDomProjectModel model2 = (MavenDomProjectModel)pair.component1();
        XmlFile xmlFile = DomUtil.getFile((DomElement)model2);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"DomUtil.getFile(model)");
        XmlFile psiFile = xmlFile;
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{(PsiFile)psiFile}).compute((ThrowableComputable)new ThrowableComputable<Unit, Throwable>(this, model2, mavenId, psiFile){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenDomProjectModel $model;
            final /* synthetic */ MavenId $mavenId;
            final /* synthetic */ XmlFile $psiFile;

            public final void compute() {
                MavenDomDependencies mavenDomDependencies = this.$model.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"model.dependencies");
                Iterator<MavenDomDependency> iterator = mavenDomDependencies.getDependencies().iterator();
                while (iterator.hasNext()) {
                    MavenDomDependency dep;
                    MavenDomDependency mavenDomDependency = dep = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"dep");
                    GenericDomValue genericDomValue = mavenDomDependency.getArtifactId();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"dep.artifactId");
                    if (!Intrinsics.areEqual((Object)genericDomValue.getStringValue(), (Object)this.$mavenId.getArtifactId())) continue;
                    GenericDomValue genericDomValue2 = dep.getGroupId();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"dep.groupId");
                    if (!Intrinsics.areEqual((Object)genericDomValue2.getStringValue(), (Object)this.$mavenId.getGroupId())) continue;
                    XmlTag xmlTag = dep.getXmlTag();
                    if (xmlTag == null) continue;
                    xmlTag.delete();
                }
                MavenDomDependencies mavenDomDependencies2 = this.$model.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies2, (String)"model.dependencies");
                if (mavenDomDependencies2.getDependencies().isEmpty()) {
                    MavenDomDependencies mavenDomDependencies3 = this.$model.getDependencies();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies3, (String)"model.dependencies");
                    XmlTag xmlTag = mavenDomDependencies3.getXmlTag();
                    if (xmlTag != null) {
                        xmlTag.delete();
                    }
                }
                MavenDependencyModificator.access$saveFile(this.this$0, this.$psiFile);
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$model = mavenDomProjectModel;
                this.$mavenId = mavenId;
                this.$psiFile = xmlFile;
            }
        });
    }

    public void addRepository(@NotNull Module module, @NotNull UnifiedDependencyRepository repository) {
        MavenDomProjectModel model2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        MavenProject mavenProject = this.myProjectsManager.findProject(module);
        if (mavenProject == null) {
            throw (Throwable)new IllegalArgumentException(MavenProjectBundle.message("maven.project.not.found.for", module.getName()));
        }
        MavenProject project = mavenProject;
        MavenDomProjectModel mavenDomProjectModel = model2 = (MavenDomProjectModel)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<MavenDomProjectModel, Throwable>(this, project, module){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenProject $project;
            final /* synthetic */ Module $module;

            public final MavenDomProjectModel compute() {
                MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(MavenDependencyModificator.access$getMyProject$p(this.this$0), this.$project.getFile());
                if (mavenDomProjectModel == null) {
                    throw (Throwable)new IllegalStateException(MavenProjectBundle.message("maven.model.error", this.$module.getName()));
                }
                return mavenDomProjectModel;
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$project = mavenProject;
                this.$module = module;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"model");
        MavenDomRepositories mavenDomRepositories = mavenDomProjectModel.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories, (String)"model.repositories");
        Iterator<MavenDomRepository> iterator = mavenDomRepositories.getRepositories().iterator();
        while (iterator.hasNext()) {
            MavenDomRepository repo;
            MavenDomRepository mavenDomRepository = repo = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepository, (String)"repo");
            GenericDomValue<String> genericDomValue = mavenDomRepository.getUrl();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"repo.url");
            String string = genericDomValue.getStringValue();
            if (!Intrinsics.areEqual((Object)(string != null ? MavenDependencyModificatorKt.access$trimLastSlash(string) : null), (Object)MavenDependencyModificatorKt.access$trimLastSlash(repository.getUrl()))) continue;
            return;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)model2);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"DomUtil.getFile(model)");
        XmlFile psiFile = xmlFile;
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{(PsiFile)psiFile}).compute((ThrowableComputable)new ThrowableComputable<Unit, Throwable>(this, psiFile, model2, repository){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ XmlFile $psiFile;
            final /* synthetic */ MavenDomProjectModel $model;
            final /* synthetic */ UnifiedDependencyRepository $repository;

            public final void compute() {
                String it;
                boolean bl;
                boolean bl2;
                String string;
                MavenDomProjectModel mavenDomProjectModel = this.$model;
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"model");
                MavenDependencyModificator.access$addRepositoriesTagIfNotExists(this.this$0, this.$psiFile, mavenDomProjectModel);
                MavenDomProjectModel mavenDomProjectModel2 = this.$model;
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel2, (String)"model");
                MavenDomRepository repoTag = mavenDomProjectModel2.getRepositories().addRepository();
                String string2 = this.$repository.getId();
                if (string2 != null) {
                    string = string2;
                    bl2 = false;
                    bl = false;
                    it = string;
                    boolean bl3 = false;
                    MavenDomRepository mavenDomRepository = repoTag;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepository, (String)"repoTag");
                    GenericDomValue<String> genericDomValue = mavenDomRepository.getId();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"repoTag.id");
                    genericDomValue.setStringValue(it);
                }
                String string3 = this.$repository.getName();
                if (string3 != null) {
                    string = string3;
                    bl2 = false;
                    bl = false;
                    it = string;
                    boolean bl4 = false;
                    MavenDomRepository mavenDomRepository = repoTag;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepository, (String)"repoTag");
                    GenericDomValue<String> genericDomValue = mavenDomRepository.getName();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"repoTag.name");
                    genericDomValue.setStringValue(it);
                }
                string = this.$repository.getUrl();
                bl2 = false;
                bl = false;
                it = string;
                boolean bl5 = false;
                MavenDomRepository mavenDomRepository = repoTag;
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepository, (String)"repoTag");
                GenericDomValue<String> genericDomValue = mavenDomRepository.getUrl();
                Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"repoTag.url");
                genericDomValue.setStringValue(it);
                MavenDependencyModificator.access$saveFile(this.this$0, this.$psiFile);
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$psiFile = xmlFile;
                this.$model = mavenDomProjectModel;
                this.$repository = unifiedDependencyRepository;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void deleteRepository(@NotNull Module module, @NotNull UnifiedDependencyRepository repository) {
        void model2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        MavenProject mavenProject = this.myProjectsManager.findProject(module);
        if (mavenProject == null) {
            throw (Throwable)new IllegalArgumentException(MavenProjectBundle.message("maven.project.not.found.for", module.getName()));
        }
        MavenProject project = mavenProject;
        Pair pair = (Pair)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Pair<? extends MavenDomProjectModel, ? extends MavenDomRepository>, Throwable>(this, project, module, repository){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenProject $project;
            final /* synthetic */ Module $module;
            final /* synthetic */ UnifiedDependencyRepository $repository;

            public final Pair<MavenDomProjectModel, MavenDomRepository> compute() {
                MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(MavenDependencyModificator.access$getMyProject$p(this.this$0), this.$project.getFile());
                if (mavenDomProjectModel == null) {
                    throw (Throwable)new IllegalStateException(MavenProjectBundle.message("maven.model.error", this.$module.getName()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026del.error\", module.name))");
                MavenDomProjectModel model2 = mavenDomProjectModel;
                MavenDomRepositories mavenDomRepositories = model2.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories, (String)"model.repositories");
                Iterator<MavenDomRepository> iterator = mavenDomRepositories.getRepositories().iterator();
                while (iterator.hasNext()) {
                    MavenDomRepository repo;
                    MavenDomRepository mavenDomRepository = repo = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepository, (String)"repo");
                    GenericDomValue<String> genericDomValue = mavenDomRepository.getUrl();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"repo.url");
                    String string = genericDomValue.getStringValue();
                    if (!Intrinsics.areEqual((Object)(string != null ? MavenDependencyModificatorKt.access$trimLastSlash(string) : null), (Object)MavenDependencyModificatorKt.access$trimLastSlash(this.$repository.getUrl()))) continue;
                    return new Pair((Object)model2, (Object)repo);
                }
                return null;
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$project = mavenProject;
                this.$module = module;
                this.$repository = unifiedDependencyRepository;
            }
        }));
        MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)pair.component1();
        MavenDomRepository repo = (MavenDomRepository)pair.component2();
        if (repo == null) {
            return;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)repo);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"DomUtil.getFile(repo)");
        XmlFile psiFile = xmlFile;
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{(PsiFile)psiFile}).compute((ThrowableComputable)new ThrowableComputable<Unit, Throwable>(this, repo, (MavenDomProjectModel)model2, psiFile){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenDomRepository $repo;
            final /* synthetic */ MavenDomProjectModel $model;
            final /* synthetic */ XmlFile $psiFile;

            public final void compute() {
                XmlTag xmlTag = this.$repo.getXmlTag();
                if (xmlTag != null) {
                    xmlTag.delete();
                }
                MavenDomRepositories mavenDomRepositories = this.$model.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories, (String)"model.repositories");
                if (mavenDomRepositories.getRepositories().isEmpty()) {
                    MavenDomRepositories mavenDomRepositories2 = this.$model.getRepositories();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories2, (String)"model.repositories");
                    XmlTag xmlTag2 = mavenDomRepositories2.getXmlTag();
                    if (xmlTag2 != null) {
                        xmlTag2.delete();
                    }
                }
                MavenDependencyModificator.access$saveFile(this.this$0, this.$psiFile);
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$repo = mavenDomRepository;
                this.$model = mavenDomProjectModel;
                this.$psiFile = xmlFile;
            }
        });
    }

    private final void saveFile(XmlFile psiFile) {
        Document document = this.myDocumentManager.getDocument((PsiFile)psiFile);
        if (document == null) {
            throw (Throwable)new IllegalStateException(MavenProjectBundle.message("maven.model.error", psiFile));
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"myDocumentManager.getDoc\u2026n.model.error\", psiFile))");
        Document document2 = document;
        this.myDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
        FileDocumentManager.getInstance().saveDocument(document2);
    }

    private final void updateVariableOrValue(MavenDomProjectModel model2, GenericDomValue<String> domValue, String newValue) {
        String rawText;
        String string;
        String string2 = domValue.getRawText();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string = rawText = null;
        }
        if (rawText != null && StringsKt.startsWith$default((String)rawText, (String)"${", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)rawText, (String)"}", (boolean)false, (int)2, null)) {
            XmlTag[] subTags;
            String string5 = rawText;
            int n = 2;
            int n2 = rawText.length() - 1;
            boolean bl = false;
            String string6 = string5.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String propertyName = string6;
            MavenDomProperties mavenDomProperties = model2.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomProperties, (String)"model.properties");
            XmlTag[] xmlTagArray = mavenDomProperties.getXmlTag();
            if (xmlTagArray == null || (xmlTagArray = xmlTagArray.getSubTags()) == null) {
                xmlTagArray = new XmlTag[]{};
            }
            XmlTag[] xmlTagArray2 = subTags = xmlTagArray;
            int n3 = xmlTagArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                XmlTag subTag;
                XmlTag xmlTag = subTag = xmlTagArray2[n2];
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"subTag");
                if (!Intrinsics.areEqual((Object)xmlTag.getName(), (Object)propertyName)) continue;
                XmlTagValue xmlTagValue = subTag.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTagValue, (String)"subTag.value");
                xmlTagValue.setText(newValue);
                return;
            }
        } else {
            domValue.setStringValue(newValue);
        }
    }

    private final String toMavenScope(String scope, String managedScope) {
        if (managedScope == null) {
            if (scope == null || Intrinsics.areEqual((Object)scope, (Object)"compile")) {
                return null;
            }
            return scope;
        }
        if (Intrinsics.areEqual((Object)scope, (Object)managedScope)) {
            return null;
        }
        return scope;
    }

    @NotNull
    public List<UnifiedDependency> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance(module.getProject()).findProject(module);
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"MavenProjectsManager.get\u2026le) ?: return emptyList()");
        MavenProject project = mavenProject;
        Object object = ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<List<? extends UnifiedDependency>, Throwable>(this, project, module){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenProject $project;
            final /* synthetic */ Module $module;

            /*
             * WARNING - void declaration
             */
            public final List<UnifiedDependency> compute() {
                void $this$mapTo$iv$iv;
                MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(MavenDependencyModificator.access$getMyProject$p(this.this$0), this.$project.getFile());
                if (mavenDomProjectModel == null) {
                    throw (Throwable)new IllegalStateException(MavenProjectBundle.message("maven.model.error", this.$module.getName()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026del.error\", module.name))");
                MavenDomProjectModel model2 = mavenDomProjectModel;
                MavenDomDependencies mavenDomDependencies = model2.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"model.dependencies");
                List<MavenDomDependency> list = mavenDomDependencies.getDependencies();
                Intrinsics.checkNotNullExpressionValue(list, (String)"model.dependencies.dependencies");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenDomDependency mavenDomDependency = (MavenDomDependency)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    GenericDomValue<String> genericDomValue = v3.getScope();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.scope");
                    String scope = genericDomValue.getStringValue();
                    if (Intrinsics.areEqual((Object)scope, (Object)"compile")) {
                        scope = null;
                    }
                    GenericDomValue genericDomValue2 = it.getGroupId();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"it.groupId");
                    String string = genericDomValue2.getStringValue();
                    GenericDomValue genericDomValue3 = it.getArtifactId();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue3, (String)"it.artifactId");
                    String string2 = genericDomValue3.getStringValue();
                    GenericDomValue<String> genericDomValue4 = it.getVersion();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue4, (String)"it.version");
                    UnifiedDependency unifiedDependency = new UnifiedDependency(string, string2, genericDomValue4.getRawText(), scope);
                    collection.add(unifiedDependency);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$project = mavenProject;
                this.$module = module;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<List<\u2026ext, scope)\n      }\n    }");
        return (List)object;
    }

    @NotNull
    public List<UnifiedDependencyRepository> declaredRepositories(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance(module.getProject()).findProject(module);
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"MavenProjectsManager.get\u2026le) ?: return emptyList()");
        MavenProject project = mavenProject;
        Object object = ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<List<? extends UnifiedDependencyRepository>, Throwable>(this, project, module){
            final /* synthetic */ MavenDependencyModificator this$0;
            final /* synthetic */ MavenProject $project;
            final /* synthetic */ Module $module;

            /*
             * WARNING - void declaration
             */
            public final List<UnifiedDependencyRepository> compute() {
                void $this$mapTo$iv$iv;
                MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomProjectModel(MavenDependencyModificator.access$getMyProject$p(this.this$0), this.$project.getFile());
                if (mavenDomProjectModel == null) {
                    throw (Throwable)new IllegalStateException(MavenProjectBundle.message("maven.model.error", this.$module.getName()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomProjectModel, (String)"MavenDomUtil.getMavenDom\u2026del.error\", module.name))");
                MavenDomProjectModel model2 = mavenDomProjectModel;
                MavenDomRepositories mavenDomRepositories = model2.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)mavenDomRepositories, (String)"model.repositories");
                List<MavenDomRepository> list = mavenDomRepositories.getRepositories();
                Intrinsics.checkNotNullExpressionValue(list, (String)"model.repositories.repositories");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenDomRepository mavenDomRepository = (MavenDomRepository)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    GenericDomValue<String> genericDomValue = v3.getId();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"it.id");
                    String string = genericDomValue.getStringValue();
                    GenericDomValue<String> genericDomValue2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue2, (String)"it.name");
                    String string2 = genericDomValue2.getStringValue();
                    GenericDomValue<String> genericDomValue3 = it.getUrl();
                    Intrinsics.checkNotNullExpressionValue(genericDomValue3, (String)"it.url");
                    String string3 = genericDomValue3.getStringValue();
                    if (string3 == null) {
                        string3 = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.url.stringValue ?: \"\"");
                    UnifiedDependencyRepository unifiedDependencyRepository = new UnifiedDependencyRepository(string, string2, string3);
                    collection.add(unifiedDependencyRepository);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = mavenDependencyModificator;
                this.$project = mavenProject;
                this.$module = module;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<List<\u2026alue ?: \"\")\n      }\n    }");
        return (List)object;
    }

    public MavenDependencyModificator(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(myProject)");
        this.myProjectsManager = mavenProjectsManager;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"PsiDocumentManager.getInstance(myProject)");
        this.myDocumentManager = psiDocumentManager;
    }

    public static final /* synthetic */ Project access$getMyProject$p(MavenDependencyModificator $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ void access$addDependenciesTagIfNotExists(MavenDependencyModificator $this, XmlFile psiFile, MavenDomProjectModel model2) {
        $this.addDependenciesTagIfNotExists(psiFile, model2);
    }

    public static final /* synthetic */ String access$toMavenScope(MavenDependencyModificator $this, String scope, String managedScope) {
        return $this.toMavenScope(scope, managedScope);
    }

    public static final /* synthetic */ void access$saveFile(MavenDependencyModificator $this, XmlFile psiFile) {
        $this.saveFile(psiFile);
    }

    public static final /* synthetic */ Pair access$getDependenciesModel(MavenDependencyModificator $this, Module module, String groupId, String artifactId) {
        return $this.getDependenciesModel(module, groupId, artifactId);
    }

    public static final /* synthetic */ void access$updateVariableOrValue(MavenDependencyModificator $this, MavenDomProjectModel model2, GenericDomValue domValue, String newValue) {
        $this.updateVariableOrValue(model2, (GenericDomValue<String>)domValue, newValue);
    }

    public static final /* synthetic */ void access$addRepositoriesTagIfNotExists(MavenDependencyModificator $this, XmlFile psiFile, MavenDomProjectModel model2) {
        $this.addRepositoriesTagIfNotExists(psiFile, model2);
    }
}

