/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;

public abstract class BuildErrorNotification
implements MavenLoggedEventParser {
    private static final Pattern LINE_AND_COLUMN = Pattern.compile("[^\\d]+?(\\d+)[^\\d]+(\\d+)");
    private static final Pattern LINE_ONLY = Pattern.compile("[^\\d]+?(\\d+)");
    private final String myLanguage;
    private final String myExtension;
    private final @BuildEventsNls.Title String myMessageGroup;

    protected BuildErrorNotification(@NonNls String language, @NonNls String extension, @BuildEventsNls.Title String messageGroup) {
        this.myLanguage = language;
        this.myExtension = extension;
        this.myMessageGroup = messageGroup;
    }

    @Override
    public boolean supportsType(@Nullable LogMessageType type) {
        return type == LogMessageType.ERROR;
    }

    @Override
    public boolean checkLogLine(@NotNull Object parentId, @NotNull MavenParsingContext parsingContext, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        String message;
        FilePosition position;
        String line;
        if (parentId == null) {
            BuildErrorNotification.$$$reportNull$$$0(0);
        }
        if (parsingContext == null) {
            BuildErrorNotification.$$$reportNull$$$0(1);
        }
        if (logLine == null) {
            BuildErrorNotification.$$$reportNull$$$0(2);
        }
        if (logEntryReader == null) {
            BuildErrorNotification.$$$reportNull$$$0(3);
        }
        if (messageConsumer == null) {
            BuildErrorNotification.$$$reportNull$$$0(4);
        }
        if ((line = logLine.getLine()).endsWith("java.lang.OutOfMemoryError")) {
            messageConsumer.accept((BuildEvent)new MessageEventImpl(parentId, MessageEvent.Kind.ERROR, this.myMessageGroup, RunnerBundle.message("build.event.message.out.memory", new Object[0]), line));
            return true;
        }
        int fileNameIdx = line.indexOf("." + this.myExtension + ":");
        if (fileNameIdx < 0) {
            return false;
        }
        int fullFileNameIdx = line.indexOf(":", fileNameIdx);
        if (fullFileNameIdx < 0) {
            return false;
        }
        String targetFileNameWithoutExtension = line.substring(0, fileNameIdx);
        String localFileNameWithoutExtension = parsingContext.getTargetFileMapper().apply(targetFileNameWithoutExtension);
        String filename = FileUtil.toSystemDependentName((String)(localFileNameWithoutExtension + "." + this.myExtension));
        File parsedFile = new File(filename);
        String lineWithPosition = line.substring(fullFileNameIdx);
        Matcher matcher = this.getMatcher(lineWithPosition);
        if (matcher == null) {
            position = new FilePosition(parsedFile, 0, 0);
            message = lineWithPosition;
        } else {
            position = BuildErrorNotification.withLineAndColumn(parsedFile, matcher);
            message = lineWithPosition.substring(matcher.end());
        }
        String errorMessage = this.getErrorMessage(position, message);
        messageConsumer.accept((BuildEvent)new FileMessageEventImpl(parentId, MessageEvent.Kind.ERROR, this.myMessageGroup, errorMessage, errorMessage, position));
        return true;
    }

    private Matcher getMatcher(String string) {
        Matcher result = LINE_AND_COLUMN.matcher(string);
        if (result.lookingAt()) {
            return result;
        }
        result = LINE_ONLY.matcher(string);
        if (result.lookingAt()) {
            return result;
        }
        return null;
    }

    @NotNull
    @NlsSafe
    private String getErrorMessage(@NotNull FilePosition position, @NotNull String message) {
        if (position == null) {
            BuildErrorNotification.$$$reportNull$$$0(5);
        }
        if (message == null) {
            BuildErrorNotification.$$$reportNull$$$0(6);
        }
        message = message.trim();
        while (message.startsWith(":") || message.startsWith("]") || message.startsWith(")")) {
            message = message.substring(1);
        }
        String string = message = message.trim();
        if (string == null) {
            BuildErrorNotification.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static FilePosition withLineAndColumn(File toTest, Matcher matcher) {
        if (matcher.groupCount() == 2) {
            return new FilePosition(toTest, BuildErrorNotification.atoi(matcher.group(1)) - 1, BuildErrorNotification.atoi(matcher.group(2)) - 1);
        }
        if (matcher.groupCount() == 1) {
            return new FilePosition(toTest, BuildErrorNotification.atoi(matcher.group(1)) - 1, 0);
        }
        return new FilePosition(toTest, 0, 0);
    }

    private static int atoi(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntryReader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/BuildErrorNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/BuildErrorNotification";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLogLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

