/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SingletonInstancesCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.plugins.api.MavenPluginDescriptor;
import org.jetbrains.idea.maven.plugins.api.MavenPropertiesGenerator;

public class MavenModelPropertiesPatcher {
    public static void patch(Properties modelProperties, @Nullable Collection<? extends MavenPlugin> plugins) {
        if (plugins == null) {
            return;
        }
        Map<String, Map<String, Map<String, List<MavenPluginDescriptor>>>> map = MavenPluginDescriptor.getDescriptorsMap();
        for (MavenPlugin mavenPlugin : plugins) {
            Map<String, List<MavenPluginDescriptor>> goalsMap;
            Map<String, Map<String, List<MavenPluginDescriptor>>> groupMap = map.get(mavenPlugin.getArtifactId());
            if (groupMap == null || (goalsMap = groupMap.get(mavenPlugin.getGroupId())) == null) continue;
            MavenModelPropertiesPatcher.patch(modelProperties, goalsMap.get(null), null, mavenPlugin.getConfigurationElement(), mavenPlugin);
            for (MavenPlugin.Execution execution : mavenPlugin.getExecutions()) {
                for (String goal : execution.getGoals()) {
                    MavenModelPropertiesPatcher.patch(modelProperties, goalsMap.get(goal), goal, execution.getConfigurationElement(), mavenPlugin);
                }
            }
        }
    }

    private static void patch(Properties modelProperties, @Nullable List<MavenPluginDescriptor> descriptors, @Nullable String goal, Element cfgElement, MavenPlugin plugin) {
        if (descriptors == null) {
            return;
        }
        for (MavenPluginDescriptor descriptor2 : descriptors) {
            if (descriptor2.properties != null) {
                for (MavenPluginDescriptor.ModelProperty property : descriptor2.properties) {
                    if (property.insideConfigurationOnly || !StringUtil.isNotEmpty((String)property.name)) continue;
                    modelProperties.setProperty(property.name, StringUtil.notNullize((String)property.value));
                }
            }
            if (descriptor2.propertyGenerator == null) continue;
            MavenPropertiesGenerator generator = (MavenPropertiesGenerator)SingletonInstancesCache.getInstance((String)descriptor2.propertyGenerator, (ClassLoader)descriptor2.getLoaderForClass());
            generator.generate(modelProperties, goal, plugin, cfgElement);
        }
    }
}

