/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.stream.ChunkedStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\u0010\n\u0002\u0010\t\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "pageFileExtensions", "", "", "getPageFileExtensions$annotations", "getPageFileExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "processSsi", "", "file", "Ljava/nio/file/Path;", "path", "intellij.platform.builtInServer.impl"})
final class StaticFileHandler
extends WebServerFileHandler {
    @NotNull
    private final String[] pageFileExtensions = new String[]{"html", "htm", "shtml", "stm", "shtm"};
    private SsiProcessor ssiProcessor;

    public static /* synthetic */ void getPageFileExtensions$annotations() {
    }

    @Override
    @NotNull
    public String[] getPageFileExtensions() {
        return this.pageFileExtensions;
    }

    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        block9: {
            Path ioFile;
            Path path;
            block8: {
                Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
                if (pathInfo.getIoFile() != null) break block8;
                VirtualFile virtualFile = pathInfo.getFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                if (!virtualFile.isInLocalFileSystem()) break block9;
            }
            if ((path = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                path = Paths.get(virtualFile.getPath(), new String[0]);
            }
            Path path2 = ioFile = path;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"ioFile");
            String nameSequence = ((Object)path2.getFileName()).toString();
            if (StringsKt.endsWith((String)nameSequence, (String)".shtml", (boolean)true) || StringsKt.endsWith((String)nameSequence, (String)".stm", (boolean)true) || StringsKt.endsWith((String)nameSequence, (String)".shtm", (boolean)true)) {
                String string = PathUtilRt.getParentPath((String)((Object)canonicalPath).toString());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtilRt.getParentPath(canonicalPath.toString())");
                this.processSsi(ioFile, string, project, request, channel, extraHeaders);
                return true;
            }
            FileResponses.INSTANCE.sendFile((HttpRequest)request, channel, ioFile, extraHeaders);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile file = virtualFile;
        HttpRequest httpRequest = (HttpRequest)request;
        long l = file.getTimeStamp();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        HttpResponse httpResponse = FileResponses.INSTANCE.prepareSend(httpRequest, channel, l, string, extraHeaders);
        if (httpResponse == null) {
            return true;
        }
        HttpResponse response = httpResponse;
        boolean isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)((HttpRequest)request));
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file.getInputStream()));
        }
        FileResponsesKt.flushChunkedResponse((Channel)channel, (boolean)isKeepAlive);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(Path file, String path, Project project, FullHttpRequest request, Channel channel, HttpHeaders extraHeaders) {
        boolean releaseBuffer;
        boolean isKeepAlive;
        ByteBuf buffer;
        block8: {
            if (this.ssiProcessor == null) {
                this.ssiProcessor = new SsiProcessor();
            }
            buffer = channel.alloc().ioBuffer();
            isKeepAlive = false;
            releaseBuffer = true;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            Intrinsics.checkNotNull((Object)ssiProcessor);
            HttpRequest httpRequest = (HttpRequest)request;
            Path path2 = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.parent");
            SsiExternalResolver ssiExternalResolver = new SsiExternalResolver(project, httpRequest, path, path2);
            ByteBuf byteBuf = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer");
            long lastModified = ssiProcessor.process(ssiExternalResolver, file, new ByteBufUtf8Writer(byteBuf));
            if (FileResponses.INSTANCE.prepareSend((HttpRequest)request, channel, lastModified, ((Object)file.getFileName()).toString(), extraHeaders) != null) break block8;
            buffer.release();
            return;
        }
        try {
            HttpResponse httpResponse;
            HttpResponse response = httpResponse;
            isKeepAlive = Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)((HttpRequest)request));
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        FileResponsesKt.flushChunkedResponse((Channel)channel, (boolean)isKeepAlive);
    }
}

