/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.debugger.ToggleKotlinVariablesState;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\r\u001a\u00020\u0006*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/ToggleKotlinVariablesView;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "kotlinVariableViewService", "Lorg/jetbrains/kotlin/idea/debugger/ToggleKotlinVariablesState;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "isInKotlinFile", "Lcom/intellij/xdebugger/XDebugSession;", "kotlin.jvm-debugger.core"})
public final class ToggleKotlinVariablesView
extends ToggleAction {
    private final ToggleKotlinVariablesState kotlinVariableViewService = ToggleKotlinVariablesState.Companion.getService();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        XDebugSession session = (XDebugSession)XDebugSession.DATA_KEY.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(session != null && this.isInKotlinFile(session));
    }

    private final boolean isInKotlinFile(XDebugSession $this$isInKotlinFile) {
        Object object = $this$isInKotlinFile.getCurrentPosition();
        if (object == null || (object = object.getFile()) == null || (object = object.getExtension()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentPosition?.file?.extension ?: return false");
        Object fileExtension = object;
        Intrinsics.checkNotNullExpressionValue((Object)KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (Object)fileExtension);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.kotlinVariableViewService.getKotlinVariableView();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.kotlinVariableViewService.setKotlinVariableView(state);
        XDebuggerUtilImpl.rebuildAllSessionsViews((Project)e.getProject());
    }
}

