/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegionPainter<T> {
    public void paint(@NotNull Graphics2D var1, int var2, int var3, int var4, int var5, @Nullable T var6);

    public static class Image
    implements RegionPainter<Object> {
        private BufferedImage myImage;

        protected void updateImage(BufferedImage image) {
        }

        protected BufferedImage createImage(int width, int height) {
            return ImageUtil.createImage(width, height, 2);
        }

        protected void invalidate() {
            this.myImage = null;
        }

        @Override
        public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, Object object) {
            if (g == null) {
                Image.$$$reportNull$$$0(0);
            }
            if (width > 0 && height > 0) {
                if (this.myImage == null || width != ImageUtil.getUserWidth(this.myImage) || height != ImageUtil.getUserHeight(this.myImage)) {
                    this.myImage = this.createImage(width, height);
                } else if (this.myImage != null) {
                    this.updateImage(this.myImage);
                }
                if (this.myImage != null) {
                    StartupUiUtil.drawImage((Graphics)g, this.myImage, null, x, y);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/util/ui/RegionPainter$Image", "paint"));
        }
    }

    public static abstract class Alpha
    implements RegionPainter<Float> {
        @Override
        public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, Float value) {
            float alpha;
            if (g == null) {
                Alpha.$$$reportNull$$$0(0);
            }
            if ((alpha = this.getAlpha(value)) > 0.0f) {
                Composite composite = g.getComposite();
                g.setComposite(this.getComposite(alpha));
                this.paint(g, x, y, width, height);
                g.setComposite(composite);
            }
        }

        protected float getAlpha(Float value) {
            return value != null ? value.floatValue() : 0.0f;
        }

        protected Composite getComposite(float alpha) {
            return alpha < 1.0f ? AlphaComposite.SrcOver.derive(alpha) : AlphaComposite.SrcOver;
        }

        protected abstract void paint(Graphics2D var1, int var2, int var3, int var4, int var5);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/util/ui/RegionPainter$Alpha", "paint"));
        }
    }
}

