/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.Painter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPainter
implements Painter {
    private boolean myNeedsRepaint;
    private final List<Painter.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public boolean needsRepaint() {
        return this.myNeedsRepaint;
    }

    public void setNeedsRepaint(boolean needsRepaint) {
        this.setNeedsRepaint(needsRepaint, null);
    }

    public void setNeedsRepaint(boolean needsRepaint, @Nullable JComponent dirtyComponent) {
        this.myNeedsRepaint = needsRepaint;
        if (this.myNeedsRepaint) {
            this.fireNeedsRepaint(dirtyComponent);
        }
    }

    @Override
    public void addListener(Painter.Listener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(Painter.Listener listener2) {
        this.myListeners.remove(listener2);
    }

    @Nullable
    public <T> T setNeedsRepaint(T oldValue, T newValue) {
        if (!this.myNeedsRepaint) {
            if (oldValue != null) {
                this.setNeedsRepaint(!oldValue.equals(newValue));
            } else if (newValue != null) {
                this.setNeedsRepaint(true);
            } else {
                this.setNeedsRepaint(false);
            }
        }
        return newValue;
    }

    @Nullable
    public <T> T setNeedsRepaint(T oldValue, T newValue, JComponent dirtyComponent) {
        if (!this.myNeedsRepaint) {
            if (oldValue != null) {
                this.setNeedsRepaint(!oldValue.equals(newValue));
            } else if (newValue != null) {
                this.setNeedsRepaint(true);
            } else {
                this.setNeedsRepaint(false);
            }
        }
        return newValue;
    }

    protected void fireNeedsRepaint(JComponent dirtyComponent) {
        for (Painter.Listener each : this.myListeners) {
            each.onNeedsRepaint(this, dirtyComponent);
        }
    }

    @Override
    public final void paint(Component component, Graphics2D g) {
        this.myNeedsRepaint = false;
        this.executePaint(component, g);
    }

    public abstract void executePaint(Component var1, Graphics2D var2);
}

