/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.doc;

import com.intellij.lang.ant.AntFilesProvider;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntDomDocumentationProvider
implements DocumentationProvider {
    private static final Logger LOG = Logger.getInstance(AntDomDocumentationProvider.class);
    public static final String[] DOC_FOLDER_NAMES = new String[]{"Tasks", "Types", "CoreTasks", "OptionalTasks", "CoreTypes", "OptionalTypes"};

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String mainDoc = AntDomDocumentationProvider.getMainDocumentation(originalElement);
        String additionalDoc = AntDomDocumentationProvider.getAdditionalDocumentation(originalElement);
        if (mainDoc == null && additionalDoc == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (additionalDoc != null) {
            builder.append(additionalDoc);
        }
        if (mainDoc != null) {
            builder.append(mainDoc);
        }
        return builder.toString();
    }

    @Nullable
    private static String getMainDocumentation(PsiElement elem) {
        VirtualFile helpFile = AntDomDocumentationProvider.getHelpFile(elem);
        if (helpFile != null) {
            try {
                return VfsUtil.loadText((VirtualFile)helpFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static String getAdditionalDocumentation(PsiElement elem) {
        List<File> list;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elem, XmlTag.class);
        if (xmlTag == null) {
            return null;
        }
        AntDomElement antElement = AntSupport.getAntDomElement(xmlTag);
        if (antElement instanceof AntFilesProvider && (list = ((AntFilesProvider)((Object)antElement)).getFiles(new HashSet<AntFilesProvider>())).size() > 0) {
            @NonNls StringBuilder builder = new StringBuilder();
            XmlTag tag = antElement.getXmlTag();
            if (tag != null) {
                builder.append("<b>");
                builder.append(tag.getName());
                builder.append(":</b>");
            }
            for (File file : list) {
                if (builder.length() > 0) {
                    builder.append("<br>");
                }
                builder.append(file.getPath());
            }
            return builder.toString();
        }
        return null;
    }

    @Nullable
    private static VirtualFile getHelpFile(PsiElement element) {
        String url;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (xmlTag == null) {
            return null;
        }
        AntDomElement antElement = AntSupport.getAntDomElement(xmlTag);
        if (antElement == null) {
            return null;
        }
        AntDomProject antProject = antElement.getAntProject();
        if (antProject == null) {
            return null;
        }
        AntInstallation installation = antProject.getAntInstallation();
        if (installation == null) {
            return null;
        }
        String antHomeDir = (String)AntInstallation.HOME_DIR.get(installation.getProperties());
        if (antHomeDir == null) {
            return null;
        }
        @NonNls String path = antHomeDir + "/docs/manual";
        if (new File(path).exists()) {
            url = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)path));
        } else {
            path = antHomeDir + "/docs.zip";
            if (new File(path).exists()) {
                url = VirtualFileManager.constructUrl((String)"jar", (String)(FileUtil.toSystemIndependentName((String)path) + "!/docs/manual"));
            } else {
                return null;
            }
        }
        VirtualFile documentationRoot = VirtualFileManager.getInstance().findFileByUrl(url);
        if (documentationRoot == null) {
            return null;
        }
        return AntDomDocumentationProvider.getHelpFile(antElement, documentationRoot);
    }

    @Nullable
    private static VirtualFile getHelpFile(AntDomElement antElement, VirtualFile documentationRoot) {
        VirtualFile candidateHelpFile;
        XmlTag xmlTag = antElement.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        @NonNls String helpFileShortName = "/" + xmlTag.getName() + ".html";
        for (String folderName : DOC_FOLDER_NAMES) {
            VirtualFile candidateHelpFile2 = documentationRoot.findFileByRelativePath(folderName + helpFileShortName);
            if (candidateHelpFile2 == null) continue;
            return candidateHelpFile2;
        }
        if ((antElement instanceof AntDomTarget || antElement instanceof AntDomProject) && (candidateHelpFile = documentationRoot.findFileByRelativePath("using.html")) != null) {
            return candidateHelpFile;
        }
        return null;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof PomTargetPsiElement) {
            PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
            if (pomTarget instanceof DomTarget) {
                AntDomTarget antTarget;
                String description;
                DomElement domElement = ((DomTarget)pomTarget).getDomElement();
                if (domElement instanceof AntDomTarget && (description = (antTarget = (AntDomTarget)domElement).getDescription().getRawText()) != null && description.length() > 0) {
                    PsiFile containingFile;
                    XmlElement xmlElement;
                    String targetName = antTarget.getName().getRawText();
                    StringBuilder builder = new StringBuilder();
                    builder.append("Target");
                    if (targetName != null) {
                        builder.append(" \"").append(targetName).append("\"");
                    }
                    if ((xmlElement = antTarget.getXmlElement()) != null && (containingFile = xmlElement.getContainingFile()) != null) {
                        String fileName = containingFile.getName();
                        builder.append(" [").append(fileName).append("]");
                    }
                    return builder.append(" ").append(description).toString();
                }
            } else if (pomTarget instanceof DomChildrenDescription) {
                String elemName;
                DomChildrenDescription description = (DomChildrenDescription)pomTarget;
                Type type = null;
                try {
                    type = description.getType();
                }
                catch (UnsupportedOperationException e) {
                    LOG.info((Throwable)e);
                }
                if (type instanceof Class && AntDomElement.class.isAssignableFrom((Class)type) && (elemName = description.getName()) != null) {
                    AntDomElement.Role role = (AntDomElement.Role)((Object)description.getUserData(AntDomElement.ROLE));
                    StringBuilder builder = new StringBuilder();
                    if (role == AntDomElement.Role.TASK) {
                        builder.append("Task ");
                    } else if (role == AntDomElement.Role.DATA_TYPE) {
                        builder.append("Data structure ");
                    }
                    builder.append(elemName);
                    return builder.toString();
                }
            }
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        VirtualFile helpFile = AntDomDocumentationProvider.getHelpFile(originalElement);
        if (helpFile == null || !(helpFile.getFileSystem() instanceof LocalFileSystem)) {
            return null;
        }
        return Collections.singletonList(helpFile.getUrl());
    }
}

