/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.fest.util.CollectionFilter;
import org.fest.util.Preconditions;

public class TypeFilter<T>
implements CollectionFilter<T> {
    private final Class<T> type;

    TypeFilter(Class<T> type) {
        this.type = type;
    }

    @Nonnull
    public static <T> TypeFilter<T> byType(@Nonnull Class<T> type) {
        return new TypeFilter<T>(type);
    }

    @Override
    @Nonnull
    public List<T> filter(@Nonnull Collection<?> target) {
        Preconditions.checkNotNull(target);
        ArrayList filtered = new ArrayList();
        for (Object o : target) {
            if (o == null || !this.type.isAssignableFrom(o.getClass())) continue;
            filtered.add(o);
        }
        return filtered;
    }
}

