/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LateinitLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/NullableFieldsDeclarationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformGetter", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.backend.common"})
public final class NullableFieldsDeclarationLowering
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext backendContext;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.toFileLoweringPass(LowerKt.runPostfix(this, true)).lower(irFile);
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        block3: {
            IrDeclaration irDeclaration2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                irDeclaration2 = declaration;
                if (!(irDeclaration2 instanceof IrProperty)) break block2;
                if (!LateinitLoweringKt.access$isRealLateinit$p((IrProperty)declaration)) break block3;
                IrProperty irProperty = (IrProperty)declaration;
                IrField irField = ((IrProperty)declaration).getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                irProperty.setBackingField(LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, irField));
                break block3;
            }
            if (!(irDeclaration2 instanceof IrSimpleFunction)) break block3;
            Object object = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            if (object != null && (object = (IrProperty)object.getOwner()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object property2 = object2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)declaration, (Object)property2.getGetter()) && LateinitLoweringKt.access$isRealLateinit$p((IrProperty)property2)) {
                    IrField irField = property2.getBackingField();
                    Intrinsics.checkNotNull((Object)irField);
                    this.transformGetter(LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, irField), (IrFunction)declaration);
                }
            }
        }
        return null;
    }

    private final void transformGetter(IrField backingField2, IrFunction getter2) {
        IrType type2 = backingField2.getType();
        boolean bl = !IrTypePredicatesKt.isPrimitiveType(type2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "'lateinit' modifier is not allowed on primitive types";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        int startOffset = getter2.getStartOffset();
        int endOffset = getter2.getEndOffset();
        getter2.setBody(new IrBlockBodyImpl(startOffset, endOffset, (Function1<? super IrBlockBodyImpl, Unit>)((Function1)new Function1<IrBlockBodyImpl, Unit>(this, getter2, startOffset, endOffset, backingField2){
            final /* synthetic */ NullableFieldsDeclarationLowering this$0;
            final /* synthetic */ IrFunction $getter;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrField $backingField;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrBlockBodyImpl $receiver) {
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), this.$getter.getSymbol(), this.$startOffset, this.$endOffset);
                boolean bl = false;
                boolean bl2 = false;
                DeclarationIrBuilder $this$run = declarationIrBuilder;
                boolean bl3 = false;
                Scope scope2 = $this$run.getScope();
                IrBuilderWithScope irBuilderWithScope = $this$run;
                IrValueParameter irValueParameter = this.$getter.getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    void it;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    IrValueParameter irValueParameter3 = irValueParameter2;
                    IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                    Scope scope3 = scope2;
                    boolean bl6 = false;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$run, (IrValueDeclaration)it);
                    scope2 = scope3;
                    irBuilderWithScope = irBuilderWithScope2;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                IrVariable resultVar = IrBuildersKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, this.$backingField), null, false, null, null, 30, null);
                resultVar.setParent(this.$getter);
                $receiver.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope3 = $this$run;
                IrType irType = $this$run.getContext().getIrBuiltIns().getNothingType();
                IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$run, ExpressionHelpersKt.irGet($this$run, resultVar), ExpressionHelpersKt.irNull($this$run));
                IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$run, ExpressionHelpersKt.irGet($this$run, resultVar));
                CommonBackendContext commonBackendContext = this.this$0.getBackendContext();
                IrBuilderWithScope irBuilderWithScope4 = $this$run;
                String string2 = this.$backingField.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"backingField.name.asString()");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, commonBackendContext.throwUninitializedPropertyAccessException(irBuilderWithScope4, string2), null, 16, null);
                $receiver.getStatements().add(throwIfNull);
            }
            {
                this.this$0 = nullableFieldsDeclarationLowering;
                this.$getter = irFunction;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$backingField = irField;
                super(1);
            }
        })));
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    public NullableFieldsDeclarationLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
    }
}

