/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public final class ResourceData {
    public final File jarFile;
    public final String resourceName;
    public final byte[] bytes;

    public ResourceData(File jarFile, String resourceName, byte[] bytes2) {
        this.jarFile = jarFile;
        this.resourceName = resourceName;
        this.bytes = bytes2;
    }

    public URL getURL() {
        try {
            String path2 = "file:" + this.jarFile + "!/" + this.resourceName;
            return new URL("jar", null, 0, path2, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(ResourceData.this.bytes);
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

