/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.codeInsight.ChangeAnnotationFix;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspection;
import com.intellij.execution.junit.codeInsight.references.MethodSourceReference;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.ig.junit.JUnitCommonClassNames;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedParameterizedInspection;", "Lcom/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getElementToHighlight", "Lcom/intellij/psi/PsiElement;", "attributeValue", "method", "Lcom/intellij/psi/PsiMethod;", "default", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "hasMultipleParameters", "Annotations", "intellij.junit"})
public final class JUnit5MalformedParameterizedInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.file");
        PsiFile file = psiFile;
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        if (JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.junit.jupiter.params.ParameterizedTest", file.getResolveScope()) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new JavaElementVisitor(this, holder){
            final /* synthetic */ JUnit5MalformedParameterizedInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitMethod(@NotNull PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Ref.BooleanRef parameterizedAnnotation = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Collections.singletonList("org.junit.jupiter.params.ParameterizedTest"));
                PsiAnnotation[] testAnnotation = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_JUPITER_ANNOTATIONS);
                Ref.BooleanRef booleanRef = parameterizedAnnotation;
                Intrinsics.checkNotNullExpressionValue((Object)booleanRef, (String)"parameterizedAnnotation");
                Ref.BooleanRef booleanRef2 = booleanRef;
                boolean bl = false;
                Ref.BooleanRef booleanRef3 = booleanRef2;
                boolean bl2 = false;
                if (!(((PsiAnnotation[])booleanRef3).length == 0)) {
                    void source;
                    void noMultiArgsProvider;
                    Intrinsics.checkNotNullExpressionValue((Object)testAnnotation, (String)"testAnnotation");
                    booleanRef2 = testAnnotation;
                    bl = false;
                    booleanRef3 = booleanRef2;
                    bl2 = false;
                    if (!(((PsiAnnotation[])booleanRef3).length == 0)) {
                        PsiParameterList psiParameterList = method.getParameterList();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
                        if (psiParameterList.getParametersCount() > 0) {
                            this.$holder.registerProblem((PsiElement)testAnnotation[0], JUnitBundle.message("junit5.malformed.parameterized.inspection.description.suspicious.combination.test.and.parameterizedtest", new Object[0]), new LocalQuickFix[]{(LocalQuickFix)new DeleteElementFix((PsiElement)testAnnotation[0])});
                        }
                    }
                    booleanRef2 = new Ref.BooleanRef();
                    booleanRef2.element = true;
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = null;
                    MetaAnnotationUtil.findMetaAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS).forEach((Consumer)new Consumer<PsiAnnotation>(this, method, (Ref.BooleanRef)noMultiArgsProvider, (Ref.ObjectRef)source){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiMethod $method;
                        final /* synthetic */ Ref.BooleanRef $noMultiArgsProvider;
                        final /* synthetic */ Ref.ObjectRef $source;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final void accept(PsiAnnotation it) {
                            boolean bl;
                            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray;
                            block13: {
                                block16: {
                                    block12: {
                                        block14: {
                                            block15: {
                                                PsiAnnotation psiAnnotation = it;
                                                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"it");
                                                String string = psiAnnotation.getQualifiedName();
                                                if (string == null) return;
                                                String string2 = string;
                                                switch (string2.hashCode()) {
                                                    case -2084799780: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.ValueSource")) return;
                                                        break;
                                                    }
                                                    case 124822449: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.CsvSource")) return;
                                                        break block12;
                                                    }
                                                    case -2080918126: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.ArgumentsSources")) return;
                                                        break block13;
                                                    }
                                                    case 2141896013: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.CsvFileSource")) return;
                                                        break block14;
                                                    }
                                                    case -1320765300: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.EnumSource")) return;
                                                        break block15;
                                                    }
                                                    case -205673727: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.ArgumentsSource")) return;
                                                        break block16;
                                                    }
                                                    case 2129905772: {
                                                        if (!string2.equals("org.junit.jupiter.params.provider.MethodSource")) return;
                                                        buildVisitor.1.access$checkMethodSource(this.this$0, this.$method, it);
                                                        this.$noMultiArgsProvider.element = false;
                                                        return;
                                                    }
                                                }
                                                buildVisitor.1.access$checkValuesSource(this.this$0, this.$method, it);
                                                this.$source.element = it;
                                                return;
                                            }
                                            buildVisitor.1.access$checkEnumSource(this.this$0, this.$method, it);
                                            this.$source.element = it;
                                            return;
                                        }
                                        buildVisitor.1.access$checkFileSource(this.this$0, it);
                                        this.$noMultiArgsProvider.element = false;
                                        return;
                                    }
                                    this.$noMultiArgsProvider.element = false;
                                    return;
                                }
                                if ((PsiAnnotation)this.$source.element != null) return;
                                this.$noMultiArgsProvider.element = false;
                                return;
                            }
                            if ((PsiAnnotation)this.$source.element != null) return;
                            PsiAnnotationMemberValue attributes = it.findAttributeValue("value");
                            PsiAnnotationMemberValue psiAnnotationMemberValue = attributes;
                            if (!(psiAnnotationMemberValue instanceof PsiArrayInitializerMemberValue)) {
                                psiAnnotationMemberValue = null;
                            }
                            if ((psiAnnotationMemberValueArray = (PsiAnnotationMemberValue[])psiAnnotationMemberValue) != null && (psiAnnotationMemberValueArray = psiAnnotationMemberValueArray.getInitializers()) != null) {
                                PsiAnnotationMemberValue[] psiAnnotationMemberValueArray2 = psiAnnotationMemberValueArray;
                                boolean bl2 = false;
                                bl = psiAnnotationMemberValueArray2.length == 0;
                            } else {
                                bl = false;
                            }
                            this.$noMultiArgsProvider.element = bl;
                            return;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$method = psiMethod;
                            this.$noMultiArgsProvider = booleanRef;
                            this.$source = objectRef;
                        }
                    });
                    if (noMultiArgsProvider.element) {
                        if ((PsiAnnotation)source.element == null) {
                            this.$holder.registerProblem((PsiElement)parameterizedAnnotation[0], JUnitBundle.message("junit5.malformed.parameterized.inspection.description.no.sources.are.provided", new Object[0]), new LocalQuickFix[0]);
                        } else if (JUnit5MalformedParameterizedInspection.access$hasMultipleParameters(this.this$0, method)) {
                            PsiAnnotation psiAnnotation = (PsiAnnotation)source.element;
                            Intrinsics.checkNotNull((Object)psiAnnotation);
                            this.$holder.registerProblem((PsiElement)psiAnnotation, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.multiple.parameters.are.not.supported.by.this.source", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)testAnnotation, (String)"testAnnotation");
                    booleanRef2 = testAnnotation;
                    bl = false;
                    booleanRef3 = booleanRef2;
                    bl2 = false;
                    if (!(((PsiAnnotation[])booleanRef3).length == 0) && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS)) {
                        PsiElement psiElement = (PsiElement)testAnnotation[0];
                        String string = JUnitBundle.message("junit5.malformed.parameterized.inspection.description.suspicious.combination", new Object[0]);
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                        PsiAnnotation psiAnnotation = testAnnotation[0];
                        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"testAnnotation[0]");
                        localQuickFixArray[0] = (LocalQuickFix)new ChangeAnnotationFix(psiAnnotation, "org.junit.jupiter.params.ParameterizedTest");
                        this.$holder.registerProblem(psiElement, string, localQuickFixArray);
                    }
                }
            }

            private final void checkEnumSource(PsiMethod method, PsiAnnotation enumSource) {
                PsiAnnotationMemberValue value = enumSource.findAttributeValue("value");
                if (value instanceof PsiClassObjectAccessExpression) {
                    PsiTypeElement psiTypeElement = ((PsiClassObjectAccessExpression)value).getOperand();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeElement, (String)"value.operand");
                    PsiType psiType = psiTypeElement.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"value.operand.type");
                    PsiType enumType = psiType;
                    this.checkSourceTypeAndParameterTypeAgree(method, value, enumType);
                    this.checkEnumConstants(enumSource, enumType, method);
                }
            }

            private final void checkValuesSource(PsiMethod method, PsiAnnotation valuesSource) {
                Map possibleValues = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"strings", (Object)PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope())), TuplesKt.to((Object)"ints", (Object)PsiType.INT), TuplesKt.to((Object)"longs", (Object)PsiType.LONG), TuplesKt.to((Object)"doubles", (Object)PsiType.DOUBLE), TuplesKt.to((Object)"shorts", (Object)PsiType.SHORT), TuplesKt.to((Object)"bytes", (Object)PsiType.BYTE), TuplesKt.to((Object)"floats", (Object)PsiType.FLOAT), TuplesKt.to((Object)"chars", (Object)PsiType.CHAR), TuplesKt.to((Object)"booleans", (Object)PsiType.BOOLEAN), TuplesKt.to((Object)"classes", (Object)PsiType.getJavaLangClass((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope()))});
                for (String valueKey : possibleValues.keySet()) {
                    this.processArrayInAnnotationParameter(valuesSource.findDeclaredAttributeValue(valueKey), (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method, possibleValues, valueKey){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiMethod $method;
                        final /* synthetic */ Map $possibleValues;
                        final /* synthetic */ String $valueKey;

                        public final void invoke(@NotNull PsiAnnotationMemberValue value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            V v = this.$possibleValues.get(this.$valueKey);
                            Intrinsics.checkNotNull(v);
                            buildVisitor.1.access$checkSourceTypeAndParameterTypeAgree(this.this$0, this.$method, value, (PsiType)v);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$method = psiMethod;
                            this.$possibleValues = map;
                            this.$valueKey = string;
                            super(1);
                        }
                    }));
                }
                PsiAnnotationParameterList psiAnnotationParameterList = valuesSource.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"valuesSource.parameterList");
                int attributesNumber = psiAnnotationParameterList.getAttributes().length;
                if (attributesNumber > 1) {
                    this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0, (PsiElement)valuesSource, method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.exactly.one.type.of.input.must.be.provided", new Object[0]), new LocalQuickFix[0]);
                } else if (attributesNumber == 0) {
                    this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0, (PsiElement)valuesSource, method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.no.value.source.is.defined", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private final void checkFileSource(PsiAnnotation methodSource) {
                PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("resources");
                this.processArrayInAnnotationParameter(annotationMemberValue, (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                        PsiReference[] psiReferenceArray = attributeValue.getReferences();
                        int n = psiReferenceArray.length;
                        for (int i = 0; i < n; ++i) {
                            ResolveResult[] resolveResultArray;
                            PsiReference ref;
                            PsiReference psiReference = ref = psiReferenceArray[i];
                            Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"ref");
                            if (psiReference.isSoft() || !(ref instanceof FileReference)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)((FileReference)ref).multiResolve(false), (String)"ref.multiResolve(false)");
                            boolean bl = false;
                            if (!(resolveResultArray.length == 0)) continue;
                            LocalQuickFix[] localQuickFixArray = ((FileReference)ref).getQuickFixes();
                            this.this$0.$holder.registerProblem(((FileReference)ref).getElement(), ((FileReference)ref).getRangeInElement(), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.file.source", attributeValue.getText()), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }

            private final void checkMethodSource(PsiMethod method, PsiAnnotation methodSource) {
                PsiClass psiClass = method.getContainingClass();
                Intrinsics.checkNotNull((Object)psiClass);
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"method.containingClass!!");
                PsiClass containingClass = psiClass;
                PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("value");
                if (annotationMemberValue == null) {
                    if (methodSource.findAttributeValue("value") == null) {
                        return;
                    }
                    String string = method.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
                    String providerName = string;
                    PsiMethod foundMethod = containingClass.findMethodBySignature(JavaPsiFacade.getElementFactory((Project)method.getProject()).createMethodFromText("void " + providerName + "()", (PsiElement)method), true);
                    if (foundMethod != null) {
                        this.doCheckSourceProvider(foundMethod, containingClass, (PsiElement)methodSource, method);
                    } else {
                        this.highlightAbsentSourceProvider(containingClass, (PsiElement)methodSource, providerName, method);
                    }
                } else {
                    this.processArrayInAnnotationParameter(annotationMemberValue, (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, containingClass, method){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiClass $containingClass;
                        final /* synthetic */ PsiMethod $method;

                        public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                            Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                            for (PsiReference reference : attributeValue.getReferences()) {
                                if (!(reference instanceof MethodSourceReference)) continue;
                                PsiElement resolve = reference.resolve();
                                if (!(resolve instanceof PsiMethod)) {
                                    PsiElement psiElement = (PsiElement)attributeValue;
                                    String string = ((MethodSourceReference)reference).getValue();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reference.value");
                                    buildVisitor.1.access$highlightAbsentSourceProvider(this.this$0, this.$containingClass, psiElement, string, this.$method);
                                    continue;
                                }
                                PsiMethod sourceProvider = (PsiMethod)resolve;
                                buildVisitor.1.access$doCheckSourceProvider(this.this$0, sourceProvider, this.$containingClass, (PsiElement)attributeValue, this.$method);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$containingClass = psiClass;
                            this.$method = psiMethod;
                            super(1);
                        }
                    }));
                }
            }

            private final void highlightAbsentSourceProvider(PsiClass containingClass, PsiElement attributeValue, String sourceProviderName, PsiMethod method) {
                CreateMethodQuickFix createFix = null;
                if (this.$holder.isOnTheFly()) {
                    String staticModifier = !TestUtils.testInstancePerClass((PsiClass)containingClass) ? " static" : "";
                    createFix = CreateMethodQuickFix.createFix((PsiClass)containingClass, (String)("private" + staticModifier + " java.util.stream.Stream<org.junit.jupiter.params.provider.Arguments> " + sourceProviderName + "()"), (String)"return null;");
                }
                this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0, attributeValue, method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.unresolved", sourceProviderName), new LocalQuickFix[]{(LocalQuickFix)createFix});
            }

            private final void doCheckSourceProvider(PsiMethod sourceProvider, PsiClass containingClass, PsiElement attributeValue, PsiMethod method) {
                String string = sourceProvider.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceProvider.name");
                String providerName = string;
                if (!(sourceProvider.hasModifierProperty("static") || containingClass == null || TestUtils.testInstancePerClass((PsiClass)containingClass) || this.implementationsTestInstanceAnnotated(containingClass))) {
                    PsiAnnotation psiAnnotation = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createAnnotationFromText("@org.junit.jupiter.api.TestInstance(TestInstance.Lifecycle.PER_CLASS)", (PsiElement)containingClass);
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"JavaPsiFacade.getElement\u2026R_CLASS, containingClass)");
                    PsiAnnotation annotation = psiAnnotation;
                    PsiAnnotationParameterList psiAnnotationParameterList = annotation.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"annotation.parameterList");
                    PsiNameValuePair[] psiNameValuePairArray = psiAnnotationParameterList.getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"annotation.parameterList.attributes");
                    PsiNameValuePair[] attributes = psiNameValuePairArray;
                    this.$holder.registerProblem(attributeValue, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.static", providerName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)sourceProvider, "static", true, false), (LocalQuickFix)new AddAnnotationPsiFix("org.junit.jupiter.api.TestInstance", (PsiModifierListOwner)containingClass, attributes, new String[0])});
                } else {
                    PsiParameterList psiParameterList = sourceProvider.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"sourceProvider.parameterList");
                    if (psiParameterList.getParametersCount() != 0) {
                        this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0, attributeValue, method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.no.params", providerName), new LocalQuickFix[0]);
                    } else {
                        PsiType componentType = this.getComponentType(sourceProvider.getReturnType(), method);
                        if (componentType == null) {
                            this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0, attributeValue, method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.return.type", providerName), new LocalQuickFix[0]);
                        } else if (JUnit5MalformedParameterizedInspection.access$hasMultipleParameters(this.this$0, method) && !this.isArgumentsInheritor(componentType) && !componentType.equalsToText("java.lang.Object") && !componentType.getDeepComponentType().equalsToText("java.lang.Object")) {
                            this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0, attributeValue, method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.wrapped.in.arguments", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private final boolean implementationsTestInstanceAnnotated(PsiClass containingClass) {
                Object v1;
                block1: {
                    Query query = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)((SearchScope)containingClass.getResolveScope()), (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ClassInheritorsSearch.se\u2026Class.resolveScope, true)");
                    Iterable $this$firstOrNull$iv = (Iterable)query;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        PsiClass it = (PsiClass)element$iv;
                        boolean bl = false;
                        if (!TestUtils.testInstancePerClass((PsiClass)it)) continue;
                        v1 = element$iv;
                        break block1;
                    }
                    v1 = null;
                }
                PsiClass implementations = v1;
                return implementations != null;
            }

            private final void processArrayInAnnotationParameter(PsiAnnotationMemberValue attributeValue, Function1<? super PsiAnnotationMemberValue, Unit> checker) {
                if (attributeValue instanceof PsiLiteral || attributeValue instanceof PsiClassObjectAccessExpression) {
                    checker.invoke((Object)attributeValue);
                } else if (attributeValue instanceof PsiArrayInitializerMemberValue) {
                    for (PsiAnnotationMemberValue memberValue : ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                        this.processArrayInAnnotationParameter(memberValue, checker);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void checkEnumConstants(PsiAnnotation enumSource, PsiType enumType, PsiMethod method) {
                PsiAnnotationMemberValue mode = enumSource.findAttributeValue("mode");
                if (mode instanceof PsiReferenceExpression && (Intrinsics.areEqual((Object)"INCLUDE", (Object)((PsiReferenceExpression)mode).getReferenceName()) || Intrinsics.areEqual((Object)"EXCLUDE", (Object)((PsiReferenceExpression)mode).getReferenceName()))) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$filterIsInstanceTo$iv$iv;
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)enumType);
                    if (psiClass == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"(PsiUtil.resolveClassInC\u2026Only(enumType) ?: return)");
                    PsiField[] psiFieldArray = psiClass.getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"(PsiUtil.resolveClassInC\u2026umType) ?: return).fields");
                    PsiField[] $this$filterIsInstance$iv = psiFieldArray;
                    boolean $i$f$filterIsInstance = false;
                    PsiField[] psiFieldArray2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiEnumConstant)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getName();
                        collection.add(string);
                    }
                    Set allEnumConstants = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    boolean bl = false;
                    Set definedConstants = new LinkedHashSet<E>();
                    this.processArrayInAnnotationParameter(enumSource.findAttributeValue("names"), (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, allEnumConstants, method, definedConstants){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ Set $allEnumConstants;
                        final /* synthetic */ PsiMethod $method;
                        final /* synthetic */ Set $definedConstants;

                        public final void invoke(@NotNull PsiAnnotationMemberValue name) {
                            Object value;
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            if (name instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)name).getValue()) instanceof String) {
                                if (!this.$allEnumConstants.contains(value)) {
                                    this.this$0.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0.this$0, (PsiElement)name, this.$method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.unresolve.enum", new Object[0]), new LocalQuickFix[0]);
                                } else if (!this.$definedConstants.add(value)) {
                                    this.this$0.$holder.registerProblem(JUnit5MalformedParameterizedInspection.getElementToHighlight$default(this.this$0.this$0, (PsiElement)name, this.$method, null, 4, null), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.duplicated.enum", new Object[0]), new LocalQuickFix[0]);
                                }
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$allEnumConstants = set;
                            this.$method = psiMethod;
                            this.$definedConstants = set2;
                            super(1);
                        }
                    }));
                }
            }

            /*
             * Unable to fully structure code
             */
            private final void checkSourceTypeAndParameterTypeAgree(PsiMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
                block18: {
                    block20: {
                        block19: {
                            block17: {
                                v0 = method.getParameterList();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"method.parameterList");
                                parameters = v0.getParameters();
                                if (parameters.length != 1) break block18;
                                v1 = parameters[0];
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"parameters[0]");
                                v2 = v1.getType();
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"parameters[0].type");
                                paramType = v2;
                                if (paramType.isAssignableFrom(componentType) || this.isArgumentsInheritor(componentType)) break block18;
                                if (!componentType.equalsToText("java.lang.String")) break block19;
                                if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)paramType)) {
                                    return;
                                }
                                psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType);
                                if (psiClass == null) break block20;
                                if (psiClass.isEnum()) {
                                    v3 = attributeValue;
                                    if (v3 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiLiteral");
                                    }
                                    if (psiClass.findFieldByName((String)((PsiLiteral)v3).getValue(), false) != null) {
                                        return;
                                    }
                                }
                                if ((qualifiedName = psiClass.getQualifiedName()) != null) {
                                    if (StringsKt.startsWith$default((String)qualifiedName, (String)"java.time.", (boolean)false, (int)2, null)) {
                                        return;
                                    }
                                    if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.nio.file.Path")) {
                                        return;
                                    }
                                }
                                factoryMethod = buildVisitor.checkSourceTypeAndParameterTypeAgree.factoryMethod.1.INSTANCE;
                                if (!psiClass.hasModifier(JvmModifier.ABSTRACT)) {
                                    block16: {
                                        v4 = psiClass.getConstructors();
                                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"psiClass.constructors");
                                        var9_10 = v4;
                                        var10_11 = false;
                                        var11_12 = var9_10;
                                        var12_13 = false;
                                        for (PsiMethod var16_17 : var11_12) {
                                            if (!((Boolean)factoryMethod.invoke((Object)var16_17)).booleanValue()) continue;
                                            v5 = var16_17;
                                            break block16;
                                        }
                                        v5 = null;
                                    }
                                    if (v5 != null) {
                                        return;
                                    }
                                }
                                v6 = psiClass.getMethods();
                                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"psiClass.methods");
                                var9_10 = v6;
                                var10_11 = false;
                                var11_12 = var9_10;
                                var12_13 = false;
                                var13_14 = var11_12;
                                var14_15 = var13_14.length;
                                for (var15_16 = 0; var15_16 < var14_15; ++var15_16) {
                                    it = var16_17 = var13_14[var15_16];
                                    $i$a$-find-JUnit5MalformedParameterizedInspection$buildVisitor$1$checkSourceTypeAndParameterTypeAgree$1 = false;
                                    if (!it.hasModifier(JvmModifier.STATIC)) ** GOTO lbl-1000
                                    v7 = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                                    if (((Boolean)factoryMethod.invoke((Object)v7)).booleanValue()) {
                                        v8 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v8 = false;
                                    }
                                    if (!v8) continue;
                                    v9 = var16_17;
                                    break block17;
                                }
                                v9 = null;
                            }
                            if (v9 != null) {
                                return;
                            }
                            break block20;
                        }
                        if (componentType.equalsToText("org.junit.jupiter.params.provider.NullEnum") && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType)) != null && psiClass.isEnum()) {
                            return;
                        }
                    }
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)parameters[0]), (String)"org.junit.jupiter.params.converter.ConvertWith", (int)0)) {
                        return;
                    }
                    v10 = (PsiElement)attributeValue;
                    v11 = parameters[0];
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"parameters[0]");
                    this.$holder.registerProblem(JUnit5MalformedParameterizedInspection.access$getElementToHighlight(this.this$0, v10, method, (PsiNameIdentifierOwner)v11), JUnitBundle.message("junit5.malformed.parameterized.inspection.description.method.source.assignable", new Object[]{componentType.getPresentableText(), paramType.getPresentableText()}), new LocalQuickFix[0]);
                }
            }

            private final boolean isArgumentsInheritor(PsiType componentType) {
                return InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments");
            }

            private final PsiType getComponentType(PsiType returnType, PsiMethod method) {
                PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)returnType, (GlobalSearchScope)method.getResolveScope());
                if (collectionItemType != null) {
                    return collectionItemType;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.IntStream")) {
                    return (PsiType)PsiType.INT;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.LongStream")) {
                    return (PsiType)PsiType.LONG;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.DoubleStream")) {
                    return (PsiType)PsiType.DOUBLE;
                }
                PsiType streamItemType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.stream.Stream", (int)0, (boolean)true);
                if (streamItemType != null) {
                    return streamItemType;
                }
                return PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.Iterator", (int)0, (boolean)true);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }

            public static final /* synthetic */ void access$checkMethodSource(buildVisitor.1 $this, PsiMethod method, PsiAnnotation methodSource) {
                $this.checkMethodSource(method, methodSource);
            }

            public static final /* synthetic */ void access$checkValuesSource(buildVisitor.1 $this, PsiMethod method, PsiAnnotation valuesSource) {
                $this.checkValuesSource(method, valuesSource);
            }

            public static final /* synthetic */ void access$checkEnumSource(buildVisitor.1 $this, PsiMethod method, PsiAnnotation enumSource) {
                $this.checkEnumSource(method, enumSource);
            }

            public static final /* synthetic */ void access$checkFileSource(buildVisitor.1 $this, PsiAnnotation methodSource) {
                $this.checkFileSource(methodSource);
            }

            public static final /* synthetic */ void access$checkSourceTypeAndParameterTypeAgree(buildVisitor.1 $this, PsiMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
                $this.checkSourceTypeAndParameterTypeAgree(method, attributeValue, componentType);
            }

            public static final /* synthetic */ void access$highlightAbsentSourceProvider(buildVisitor.1 $this, PsiClass containingClass, PsiElement attributeValue, String sourceProviderName, PsiMethod method) {
                $this.highlightAbsentSourceProvider(containingClass, attributeValue, sourceProviderName, method);
            }

            public static final /* synthetic */ void access$doCheckSourceProvider(buildVisitor.1 $this, PsiMethod sourceProvider, PsiClass containingClass, PsiElement attributeValue, PsiMethod method) {
                $this.doCheckSourceProvider(sourceProvider, containingClass, attributeValue, method);
            }
        };
    }

    private final PsiElement getElementToHighlight(PsiElement attributeValue, PsiMethod method, PsiNameIdentifierOwner psiNameIdentifierOwner) {
        PsiElement psiElement;
        if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)method), (PsiElement)attributeValue, (boolean)true)) {
            psiElement = attributeValue;
        } else {
            PsiElement psiElement2 = psiNameIdentifierOwner.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)psiNameIdentifierOwner;
            }
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"default.nameIdentifier ?: default");
        }
        return psiElement;
    }

    static /* synthetic */ PsiElement getElementToHighlight$default(JUnit5MalformedParameterizedInspection jUnit5MalformedParameterizedInspection, PsiElement psiElement, PsiMethod psiMethod, PsiNameIdentifierOwner psiNameIdentifierOwner, int n, Object object) {
        if ((n & 4) != 0) {
            psiNameIdentifierOwner = (PsiNameIdentifierOwner)psiMethod;
        }
        return jUnit5MalformedParameterizedInspection.getElementToHighlight(psiElement, psiMethod, psiNameIdentifierOwner);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasMultipleParameters(PsiMethod method) {
        void $this$filterTo$iv$iv;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) return false;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
        PsiParameter[] $this$filter$iv = psiParameterArray;
        boolean $i$f$filter = false;
        PsiParameter[] psiParameterArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var8_8[i];
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            if (!(!InheritanceUtil.isInheritor((PsiType)v2.getType(), (String)"org.junit.jupiter.api.TestInfo") && !InheritanceUtil.isInheritor((PsiType)it.getType(), (String)"org.junit.jupiter.api.TestReporter"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        boolean bl = false;
        if (collection.size() <= 1) return false;
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Annotations.INSTANCE.getEXTENDS_WITH())) return false;
        if (MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (Collection)Annotations.INSTANCE.getEXTENDS_WITH())) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$hasMultipleParameters(JUnit5MalformedParameterizedInspection $this, PsiMethod method) {
        return $this.hasMultipleParameters(method);
    }

    public static final /* synthetic */ PsiElement access$getElementToHighlight(JUnit5MalformedParameterizedInspection $this, PsiElement attributeValue, PsiMethod method, PsiNameIdentifierOwner psiNameIdentifierOwner) {
        return $this.getElementToHighlight(attributeValue, method, psiNameIdentifierOwner);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedParameterizedInspection$Annotations;", "", "()V", "EXTENDS_WITH", "", "", "getEXTENDS_WITH", "()Ljava/util/List;", "TEST_INSTANCE_PER_CLASS", "intellij.junit"})
    private static final class Annotations {
        @NotNull
        public static final String TEST_INSTANCE_PER_CLASS = "@org.junit.jupiter.api.TestInstance(TestInstance.Lifecycle.PER_CLASS)";
        @NotNull
        private static final List<String> EXTENDS_WITH;
        public static final Annotations INSTANCE;

        @NotNull
        public final List<String> getEXTENDS_WITH() {
            return EXTENDS_WITH;
        }

        private Annotations() {
        }

        static {
            Annotations annotations;
            INSTANCE = annotations = new Annotations();
            EXTENDS_WITH = CollectionsKt.listOf((Object)"org.junit.jupiter.api.extension.ExtendWith");
        }
    }
}

