/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructLocalVariableTableAttribute
extends StructGeneralAttribute {
    private List<LocalVariable> localVariables = Collections.emptyList();

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.localVariables = new ArrayList<LocalVariable>(len);
            for (int i = 0; i < len; ++i) {
                int start_pc = data.readUnsignedShort();
                int length = data.readUnsignedShort();
                int nameIndex = data.readUnsignedShort();
                int descriptorIndex = data.readUnsignedShort();
                int varIndex = data.readUnsignedShort();
                this.localVariables.add(new LocalVariable(start_pc, length, pool.getPrimitiveConstant(nameIndex).getString(), pool.getPrimitiveConstant(descriptorIndex).getString(), varIndex));
            }
        } else {
            this.localVariables = Collections.emptyList();
        }
    }

    public void add(StructLocalVariableTableAttribute attr) {
        this.localVariables.addAll(attr.localVariables);
    }

    public String getName(int index, int visibleOffset) {
        return this.matchingVars(index, visibleOffset).map(v -> v.name).findFirst().orElse(null);
    }

    public String getDescriptor(int index, int visibleOffset) {
        return this.matchingVars(index, visibleOffset).map(v -> v.descriptor).findFirst().orElse(null);
    }

    private Stream<LocalVariable> matchingVars(int index, int visibleOffset) {
        return this.localVariables.stream().filter(v -> v.index == index && visibleOffset >= v.start_pc && visibleOffset < v.start_pc + v.length);
    }

    public boolean containsName(String name) {
        return this.localVariables.stream().anyMatch(v -> Objects.equals(v.name, name));
    }

    public Map<Integer, String> getMapParamNames() {
        return this.localVariables.stream().filter(v -> v.start_pc == 0).collect(Collectors.toMap(v -> v.index, v -> v.name, (n1, n2) -> n2));
    }

    private static final class LocalVariable {
        final int start_pc;
        final int length;
        final String name;
        final String descriptor;
        final int index;

        private LocalVariable(int start_pc, int length, String name, String descriptor, int index) {
            this.start_pc = start_pc;
            this.length = length;
            this.name = name;
            this.descriptor = descriptor;
            this.index = index;
        }
    }
}

