/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.BrokenCode;
import org.jetbrains.eval4j.DoubleValue;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.FloatValue;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.LongValue;
import org.jetbrains.eval4j.NotInitialized;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.org.objectweb.asm.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\u001a\u000e\u0010\u0004\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005\u001a\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001c\u001a\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001e\u001a\u000e\u0010\t\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\n\u001a\u000e\u0010\r\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u000e\u001a\u000e\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012\u001a\u000e\u0010\u0015\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0016\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020$\u001a\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020&\u001a\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*\u001a\u000e\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020*\u001a\u001b\u0010,\u001a\u0002H-\"\b\b\u0000\u0010-*\u00020.*\u0004\u0018\u0001H-\u00a2\u0006\u0002\u0010/\u001a\u0016\u00100\u001a\u0004\u0018\u00010.*\u00020\u00062\b\b\u0002\u00101\u001a\u00020$\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"NULL_VALUE", "Lorg/jetbrains/eval4j/ObjectValue;", "getNULL_VALUE", "()Lorg/jetbrains/eval4j/ObjectValue;", "boolean", "", "Lorg/jetbrains/eval4j/Value;", "getBoolean", "(Lorg/jetbrains/eval4j/Value;)Z", "double", "", "getDouble", "(Lorg/jetbrains/eval4j/Value;)D", "float", "", "getFloat", "(Lorg/jetbrains/eval4j/Value;)F", "int", "", "getInt", "(Lorg/jetbrains/eval4j/Value;)I", "long", "", "getLong", "(Lorg/jetbrains/eval4j/Value;)J", "Lorg/jetbrains/eval4j/IntValue;", "v", "byte", "", "char", "", "Lorg/jetbrains/eval4j/DoubleValue;", "Lorg/jetbrains/eval4j/FloatValue;", "Lorg/jetbrains/eval4j/LongValue;", "makeNotInitializedValue", "t", "Lorg/jetbrains/org/objectweb/asm/Type;", "short", "", "throwBrokenCodeException", "", "e", "", "throwInterpretingException", "checkNull", "T", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "obj", "expectedType", "kotlin.eval4j"})
public final class ValuesKt {
    @NotNull
    private static final ObjectValue NULL_VALUE;

    @Nullable
    public static final Value makeNotInitializedValue(@NotNull Type t) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        switch (t.getSort()) {
            case 0: {
                value = null;
                break;
            }
            default: {
                value = new NotInitialized(t);
            }
        }
        return value;
    }

    @NotNull
    public static final IntValue boolean(boolean v) {
        int n = v ? 1 : 0;
        Type type = Type.BOOLEAN_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.BOOLEAN_TYPE");
        return new IntValue(n, type);
    }

    @NotNull
    public static final IntValue byte(byte v) {
        Type type = Type.BYTE_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.BYTE_TYPE");
        return new IntValue(v, type);
    }

    @NotNull
    public static final IntValue short(short v) {
        Type type = Type.SHORT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.SHORT_TYPE");
        return new IntValue(v, type);
    }

    @NotNull
    public static final IntValue char(char v) {
        Type type = Type.CHAR_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.CHAR_TYPE");
        return new IntValue(v, type);
    }

    @NotNull
    public static final IntValue int(int v) {
        Type type = Type.INT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.INT_TYPE");
        return new IntValue(v, type);
    }

    @NotNull
    public static final LongValue long(long v) {
        return new LongValue(v);
    }

    @NotNull
    public static final FloatValue float(float v) {
        return new FloatValue(v);
    }

    @NotNull
    public static final DoubleValue double(double v) {
        return new DoubleValue(v);
    }

    @NotNull
    public static final ObjectValue getNULL_VALUE() {
        return NULL_VALUE;
    }

    public static final boolean getBoolean(@NotNull Value $this$boolean) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"$this$boolean");
        return ((Number)((IntValue)$this$boolean).getValue()).intValue() == 1;
    }

    public static final int getInt(@NotNull Value $this$int) {
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"$this$int");
        return ((Number)((IntValue)$this$int).getValue()).intValue();
    }

    public static final long getLong(@NotNull Value $this$long) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"$this$long");
        return ((Number)((LongValue)$this$long).getValue()).longValue();
    }

    public static final float getFloat(@NotNull Value $this$float) {
        Intrinsics.checkNotNullParameter((Object)$this$float, (String)"$this$float");
        return ((Number)((FloatValue)$this$float).getValue()).floatValue();
    }

    public static final double getDouble(@NotNull Value $this$double) {
        Intrinsics.checkNotNullParameter((Object)$this$double, (String)"$this$double");
        return ((Number)((DoubleValue)$this$double).getValue()).doubleValue();
    }

    @Nullable
    public static final Object obj(@NotNull Value $this$obj, @NotNull Type expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$obj, (String)"$this$obj");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Type type = expectedType;
        return Intrinsics.areEqual((Object)type, (Object)Type.BOOLEAN_TYPE) ? Boolean.valueOf(ValuesKt.getBoolean($this$obj)) : (Intrinsics.areEqual((Object)type, (Object)Type.SHORT_TYPE) ? Short.valueOf((short)ValuesKt.getInt((IntValue)$this$obj)) : (Intrinsics.areEqual((Object)type, (Object)Type.BYTE_TYPE) ? (Comparable<Byte>)Byte.valueOf((byte)ValuesKt.getInt((IntValue)$this$obj)) : (Comparable<Byte>)(Intrinsics.areEqual((Object)type, (Object)Type.CHAR_TYPE) ? Character.valueOf((char)ValuesKt.getInt((IntValue)$this$obj)) : ((AbstractValue)$this$obj).getValue())));
    }

    public static /* synthetic */ Object obj$default(Value value, Type type, int n, Object object) {
        if ((n & 1) != 0) {
            type = value.getAsmType();
        }
        return ValuesKt.obj(value, type);
    }

    @NotNull
    public static final <T> T checkNull(@Nullable T $this$checkNull) {
        if ($this$checkNull == null) {
            Void void_ = ValuesKt.throwInterpretingException(new NullPointerException());
            throw new KotlinNothingValueException();
        }
        return $this$checkNull;
    }

    @NotNull
    public static final Void throwInterpretingException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        throw (Throwable)new Eval4JInterpretingException(e);
    }

    @NotNull
    public static final Void throwBrokenCodeException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        throw (Throwable)new BrokenCode(e);
    }

    static {
        Type type = Type.getObjectType((String)"null");
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Type.getObjectType(\"null\")");
        NULL_VALUE = new ObjectValue((Object)null, type);
    }
}

