/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.ide.palette.impl.PaletteComponentList;
import com.intellij.ide.palette.impl.PaletteGroupHeader;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.jetbrains.annotations.Nullable;

public class PaletteContentWindow
extends JPanel
implements Scrollable {
    public PaletteContentWindow() {
        this.setLayout(new PaletteLayoutManager());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Nullable
    PaletteGroupHeader getLastGroupHeader() {
        PaletteGroupHeader result = null;
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof PaletteGroupHeader)) continue;
            result = (PaletteGroupHeader)comp;
        }
        return result;
    }

    private static class PaletteLayoutManager
    implements LayoutManager {
        private PaletteLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = 0;
            for (Component c : parent.getComponents()) {
                if (!(c instanceof PaletteGroupHeader)) continue;
                PaletteGroupHeader groupHeader = (PaletteGroupHeader)c;
                groupHeader.setLocation(0, height);
                if (groupHeader.isVisible()) {
                    groupHeader.setSize(width, groupHeader.getPreferredSize().height);
                    height += groupHeader.getPreferredSize().height;
                } else {
                    groupHeader.setSize(0, 0);
                }
                if (!groupHeader.isSelected() && groupHeader.isVisible()) continue;
                PaletteComponentList componentList = groupHeader.getComponentList();
                componentList.setSize(width, componentList.getPreferredSize().height);
                componentList.setLocation(0, height);
                height += componentList.getHeight();
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return JBUI.emptySize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int width = parent.getWidth();
            for (Component c : parent.getComponents()) {
                if (!(c instanceof PaletteGroupHeader)) continue;
                PaletteGroupHeader groupHeader = (PaletteGroupHeader)c;
                height += groupHeader.getHeight();
                if (!groupHeader.isSelected()) continue;
                height += groupHeader.getComponentList().getPreferredHeight(width);
            }
            return new Dimension(10, height);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

