/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdks;
import org.jetbrains.kotlin.idea.core.script.ucache.SdkId;
import org.jetbrains.kotlin.idea.util.IjPlatformUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0007J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 J\n\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 J\f\u0010$\u001a\u00020%*\u00020\u0007H\u0002R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdks", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/SdkId;", "Lcom/intellij/openapi/projectRoots/Sdk;", "remove", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lcom/intellij/openapi/projectRoots/Sdk;)V", "defaultSdk", "getDefaultSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "defaultSdk$delegate", "Lkotlin/Lazy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addAll", "", "other", "addDefaultSdk", "addSdk", "javaHome", "Ljava/io/File;", "sdkId", "addSdkByName", "sdkName", "", "build", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;", "fromStorage", "storage", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "getScriptDefaultSdk", "getScriptSdkByJavaHome", "toStorage", "canBeUsedForScript", "", "kotlin.core"})
public final class ScriptSdksBuilder {
    private final Lazy defaultSdk$delegate;
    @NotNull
    private final Project project;
    private final Map<SdkId, Sdk> sdks;
    private final Sdk remove;

    private final Sdk getDefaultSdk() {
        Lazy lazy = this.defaultSdk$delegate;
        ScriptSdksBuilder scriptSdksBuilder = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Sdk)lazy.getValue();
    }

    @NotNull
    public final ScriptSdks build() {
        boolean bl = false;
        Set nonIndexedClassRoots = new LinkedHashSet();
        boolean bl2 = false;
        Set nonIndexedSourceRoots = new LinkedHashSet();
        boolean bl3 = false;
        Set nonIndexedSdks = (Set)CollectionsKt.filterNotNullTo((Iterable)this.sdks.values(), (Collection)new LinkedHashSet());
        ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this, nonIndexedSdks, nonIndexedClassRoots, nonIndexedSourceRoots){
            final /* synthetic */ ScriptSdksBuilder this$0;
            final /* synthetic */ Set $nonIndexedSdks;
            final /* synthetic */ Set $nonIndexedClassRoots;
            final /* synthetic */ Set $nonIndexedSourceRoots;

            public final void invoke() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.this$0.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                for (Module module : moduleManager.getModules()) {
                    if (this.$nonIndexedSdks.isEmpty()) break;
                    Collection collection = this.$nonIndexedSdks;
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    Sdk sdk = moduleRootManager.getSdk();
                    boolean bl = false;
                    Collection collection2 = collection;
                    if (collection2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                    }
                    TypeIntrinsics.asMutableCollection((Object)collection2).remove(sdk);
                }
                Iterable $this$forEach$iv = this.$nonIndexedSdks;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Sdk it = (Sdk)element$iv;
                    boolean bl = false;
                    Collection collection = this.$nonIndexedClassRoots;
                    Object[] objectArray = it.getRootProvider().getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.rootProvider.getFiles(OrderRootType.CLASSES)");
                    CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
                    Collection collection3 = this.$nonIndexedSourceRoots;
                    Object[] objectArray2 = it.getRootProvider().getFiles(OrderRootType.SOURCES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"it.rootProvider.getFiles(OrderRootType.SOURCES)");
                    CollectionsKt.addAll((Collection)collection3, (Object[])objectArray2);
                }
            }
            {
                this.this$0 = scriptSdksBuilder;
                this.$nonIndexedSdks = set;
                this.$nonIndexedClassRoots = set2;
                this.$nonIndexedSourceRoots = set3;
                super(0);
            }
        }));
        return new ScriptSdks(this.sdks, nonIndexedClassRoots, nonIndexedSourceRoots);
    }

    @Deprecated(message="Don't use, used only from DefaultScriptingSupport for saving to storage")
    public final void addAll(@NotNull ScriptSdksBuilder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.sdks.putAll(other.sdks);
    }

    @Nullable
    public final Sdk addSdk(@NotNull SdkId sdkId) {
        Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
        String string = sdkId.getHomeDirectory();
        if (string == null) {
            return this.addDefaultSdk();
        }
        String canonicalPath = string;
        return this.addSdk(new File(canonicalPath));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Sdk addSdk(@Nullable File javaHome) {
        Object object;
        void $this$getOrPut$iv;
        if (javaHome == null) {
            return this.addDefaultSdk();
        }
        Map<SdkId, Sdk> map2 = this.sdks;
        SdkId key$iv = SdkId.Companion.invoke(javaHome);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Sdk sdk = this.getScriptSdkByJavaHome(javaHome);
            if (sdk == null) {
                sdk = this.getDefaultSdk();
            }
            Sdk answer$iv = sdk;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Sdk)object;
    }

    private final Sdk getScriptSdkByJavaHome(File javaHome) {
        Object object;
        Sdk sdk;
        boolean bl;
        Sdk[] sdkArray;
        block6: {
            try {
                sdkArray = VfsUtil.findFileByIoFile((File)javaHome, (boolean)true);
            }
            catch (Throwable e) {
                sdkArray = null;
            }
            Sdk[] sdkArray2 = sdkArray;
            if (sdkArray == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdkArray2, (String)"try {\n            VfsUti\u2026\n        } ?: return null");
            Sdk[] javaHomeVF = sdkArray2;
            Sdk[] sdkArray3 = IjPlatformUtil.getProjectJdkTableSafe().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)sdkArray3, (String)"getProjectJdkTableSafe().allJdks");
            sdkArray = sdkArray3;
            bl = false;
            Sdk[] sdkArray4 = sdkArray;
            boolean bl2 = false;
            Sdk[] sdkArray5 = sdkArray4;
            int n = sdkArray5.length;
            for (int i = 0; i < n; ++i) {
                Sdk sdk2;
                Sdk it = sdk2 = sdkArray5[i];
                boolean bl3 = false;
                Sdk sdk3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"it");
                if (!Intrinsics.areEqual((Object)sdk3.getHomeDirectory(), (Object)javaHomeVF)) continue;
                sdk = sdk2;
                break block6;
            }
            sdk = null;
        }
        if (sdk != null) {
            sdkArray = sdk;
            bl = false;
            boolean bl4 = false;
            Sdk[] it = sdkArray;
            boolean bl5 = false;
            object = this.canBeUsedForScript((Sdk)it) ? sdkArray : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Sdk addDefaultSdk() {
        Object object;
        void $this$getOrPut$iv;
        Map<SdkId, Sdk> map2 = this.sdks;
        SdkId key$iv = SdkId.Companion.getDefault();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Sdk answer$iv = this.getDefaultSdk();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Sdk)object;
    }

    public final void addSdkByName(@NotNull String sdkName) {
        Object object;
        block8: {
            block7: {
                Sdk[] sdkArray;
                boolean bl;
                Sdk[] sdkArray2;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
                    Sdk[] sdkArray3 = IjPlatformUtil.getProjectJdkTableSafe().getAllJdks();
                    Intrinsics.checkNotNullExpressionValue((Object)sdkArray3, (String)"getProjectJdkTableSafe().allJdks");
                    sdkArray2 = sdkArray3;
                    bl = false;
                    Sdk[] sdkArray4 = sdkArray2;
                    boolean bl2 = false;
                    Sdk[] sdkArray5 = sdkArray4;
                    int n = sdkArray5.length;
                    for (int i = 0; i < n; ++i) {
                        Sdk sdk;
                        Sdk it = sdk = sdkArray5[i];
                        boolean bl3 = false;
                        Sdk sdk2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"it");
                        if (!Intrinsics.areEqual((Object)sdk2.getName(), (Object)sdkName)) continue;
                        sdkArray = sdk;
                        break block6;
                    }
                    sdkArray = object = null;
                }
                if (sdkArray == null) break block7;
                sdkArray2 = object;
                bl = false;
                boolean bl4 = false;
                Sdk[] it = sdkArray2;
                boolean bl5 = false;
                object = this.canBeUsedForScript((Sdk)it) ? sdkArray2 : null;
                if (object != null) break block8;
            }
            object = this.getDefaultSdk();
        }
        if (object == null) {
            return;
        }
        Sdk[] sdk = object;
        String string = sdk.getHomePath();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.homePath ?: return");
        String homePath = string;
        this.sdks.put(SdkId.Companion.invoke(homePath), (Sdk)sdk);
    }

    private final Sdk getScriptDefaultSdk() {
        Sdk anyJavaSdk;
        block5: {
            Sdk sdk;
            Sdk projectSdk;
            Object object;
            boolean bl;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            Sdk sdk2 = projectRootManager.getProjectSdk();
            if (sdk2 != null) {
                Sdk sdk3 = sdk2;
                boolean bl2 = false;
                bl = false;
                Sdk it = sdk3;
                boolean bl3 = false;
                Sdk sdk4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)sdk4, (String)"it");
                object = this.canBeUsedForScript(sdk4) ? sdk3 : null;
            } else {
                object = projectSdk = null;
            }
            if (projectSdk != null) {
                return projectSdk;
            }
            Sdk[] sdkArray = ModuleInfosFromIdeaModelKt.getAllProjectSdks();
            bl = false;
            Sdk[] sdkArray2 = sdkArray;
            boolean bl4 = false;
            Sdk[] sdkArray3 = sdkArray2;
            int n = sdkArray3.length;
            for (int i = 0; i < n; ++i) {
                Sdk sdk5;
                Sdk it = sdk5 = sdkArray3[i];
                boolean bl5 = false;
                if (!this.canBeUsedForScript(it)) continue;
                sdk = sdk5;
                break block5;
            }
            sdk = anyJavaSdk = null;
        }
        if (anyJavaSdk != null) {
            return anyJavaSdk;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Default Script SDK is null: ").append("projectSdk = ");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ScriptUtilsKt.scriptingWarnLog(stringBuilder.append(projectRootManager.getProjectSdk()).append(", ").append("all sdks = ").append(ArraysKt.joinToString$default((Object[])ModuleInfosFromIdeaModelKt.getAllProjectSdks(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
        return null;
    }

    private final boolean canBeUsedForScript(Sdk $this$canBeUsedForScript) {
        return Intrinsics.areEqual((Object)$this$canBeUsedForScript, (Object)this.remove) ^ true && $this$canBeUsedForScript.getSdkType() instanceof JavaSdkType;
    }

    /*
     * WARNING - void declaration
     */
    public final void toStorage(@NotNull ScriptClassRootsStorage storage) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Iterable iterable = this.sdks.values();
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        ScriptClassRootsStorage scriptClassRootsStorage = storage;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            void destination$iv;
            String string;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Sdk it = (Sdk)element$iv;
            boolean bl3 = false;
            Sdk sdk = it;
            if ((sdk != null ? sdk.getName() : null) == null) continue;
            string = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it$iv = string;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Collection collection2 = collection;
        scriptClassRootsStorage.setSdks((Set)collection2);
        storage.setDefaultSdkUsed(this.sdks.containsKey(SdkId.Companion.getDefault()));
    }

    public final void fromStorage(@NotNull ScriptClassRootsStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Iterable $this$forEach$iv = storage.getSdks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.addSdkByName(it);
        }
        if (storage.getDefaultSdkUsed()) {
            this.addDefaultSdk();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptSdksBuilder(@NotNull Project project, @NotNull Map<SdkId, Sdk> sdks, @Nullable Sdk remove) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        this.project = project;
        this.sdks = sdks;
        this.remove = remove;
        this.defaultSdk$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Sdk>(this){
            final /* synthetic */ ScriptSdksBuilder this$0;

            @Nullable
            public final Sdk invoke() {
                return ScriptSdksBuilder.access$getScriptDefaultSdk(this.this$0);
            }
            {
                this.this$0 = scriptSdksBuilder;
                super(0);
            }
        }));
    }

    public /* synthetic */ ScriptSdksBuilder(Project project, Map map2, Sdk sdk, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            sdk = null;
        }
        this(project, map2, sdk);
    }

    public static final /* synthetic */ Sdk access$getScriptDefaultSdk(ScriptSdksBuilder $this) {
        return $this.getScriptDefaultSdk();
    }
}

