/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.logger;

import com.intellij.filePrediction.candidates.FilePredictionCandidateSource;
import com.intellij.filePrediction.logger.CandidateAnonymizedPath;
import com.intellij.filePrediction.logger.EncodedBooleanEventField;
import com.intellij.filePrediction.logger.EncodedDoubleEventField;
import com.intellij.filePrediction.logger.EncodedEnumEventField;
import com.intellij.filePrediction.predictor.FilePredictionCompressedCandidate;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongListEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/filePrediction/logger/FileNavigationLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.filePrediction"})
public final class FileNavigationLogger
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static IntEventField session;
    private static LongListEventField performance;
    private static CandidateAnonymizedPath anonymized_path;
    private static EncodedBooleanEventField opened;
    private static EncodedEnumEventField<FilePredictionCandidateSource> source;
    private static EncodedDoubleEventField probability;
    private static StringEventField features;
    private static ObjectListEventField candidates;
    private static final EventId3<Integer, List<Long>, List<ObjectEventData>> cacheCandidates;
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("file.prediction", 11);
        session = EventFields.Int((String)"session");
        performance = EventFields.LongList((String)"performance");
        anonymized_path = new CandidateAnonymizedPath();
        opened = new EncodedBooleanEventField("opened");
        source = new EncodedEnumEventField("source");
        probability = new EncodedDoubleEventField("prob");
        features = EventFields.StringValidatedByCustomRule((String)"features", (String)"file_features");
        candidates = new ObjectListEventField("candidates", new EventField[]{(EventField)anonymized_path, (EventField)opened.getField(), (EventField)source.getField(), (EventField)probability.getField(), (EventField)features});
        cacheCandidates = GROUP.registerEvent("calculated", (EventField)session, (EventField)performance, (EventField)candidates);
    }

    public static final /* synthetic */ void access$setAnonymized_path$cp(CandidateAnonymizedPath candidateAnonymizedPath) {
        anonymized_path = candidateAnonymizedPath;
    }

    public static final /* synthetic */ void access$setOpened$cp(EncodedBooleanEventField encodedBooleanEventField) {
        opened = encodedBooleanEventField;
    }

    public static final /* synthetic */ void access$setSource$cp(EncodedEnumEventField encodedEnumEventField) {
        source = encodedEnumEventField;
    }

    public static final /* synthetic */ void access$setProbability$cp(EncodedDoubleEventField encodedDoubleEventField) {
        probability = encodedDoubleEventField;
    }

    public static final /* synthetic */ void access$setFeatures$cp(StringEventField stringEventField) {
        features = stringEventField;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010!2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020!0\n2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u0018\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J6\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010!2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020!0\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a \u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/filePrediction/logger/FileNavigationLogger$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "anonymized_path", "Lcom/intellij/filePrediction/logger/CandidateAnonymizedPath;", "cacheCandidates", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "", "Lcom/intellij/internal/statistic/eventLog/events/ObjectEventData;", "candidates", "Lcom/intellij/internal/statistic/eventLog/events/ObjectListEventField;", "features", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "opened", "Lcom/intellij/filePrediction/logger/EncodedBooleanEventField;", "performance", "Lcom/intellij/internal/statistic/eventLog/events/LongListEventField;", "probability", "Lcom/intellij/filePrediction/logger/EncodedDoubleEventField;", "session", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "source", "Lcom/intellij/filePrediction/logger/EncodedEnumEventField;", "Lcom/intellij/filePrediction/candidates/FilePredictionCandidateSource;", "logEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "Lcom/intellij/filePrediction/predictor/FilePredictionCompressedCandidate;", "totalDuration", "refsComputation", "toObject", "candidate", "wasOpened", "", "toPerformanceMetrics", "openCandidate", "intellij.filePrediction"})
    public static final class Companion {
        public final void logEvent(@NotNull Project project, int sessionId, @Nullable FilePredictionCompressedCandidate opened, @NotNull List<FilePredictionCompressedCandidate> candidates, long totalDuration, long refsComputation) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            boolean bl = false;
            List allCandidates = new ArrayList();
            if (opened != null) {
                allCandidates.add(this.toObject(opened, true));
            }
            for (FilePredictionCompressedCandidate candidate : candidates) {
                allCandidates.add(this.toObject(candidate, false));
            }
            List<Long> performanceMs = this.toPerformanceMetrics(totalDuration, refsComputation, opened, candidates);
            cacheCandidates.log(project, (Object)sessionId, performanceMs, (Object)allCandidates);
        }

        private final ObjectEventData toObject(FilePredictionCompressedCandidate candidate, boolean wasOpened) {
            ArrayList data = CollectionsKt.arrayListOf((Object[])new EventPair[]{anonymized_path.with(candidate.getPath()), opened.with(wasOpened), source.with((Enum)candidate.getSource())});
            if (candidate.getProbability() != null) {
                data.add(probability.with(candidate.getProbability()));
            }
            data.add(features.with((Object)candidate.getFeatures()));
            return new ObjectEventData((List)data);
        }

        private final List<Long> toPerformanceMetrics(long totalDuration, long refsComputation, FilePredictionCompressedCandidate openCandidate, List<FilePredictionCompressedCandidate> candidates) {
            long featuresMs = 0L;
            long predictionMs = 0L;
            FilePredictionCompressedCandidate filePredictionCompressedCandidate = openCandidate;
            if (filePredictionCompressedCandidate != null) {
                FilePredictionCompressedCandidate filePredictionCompressedCandidate2 = filePredictionCompressedCandidate;
                boolean bl = false;
                boolean bl2 = false;
                FilePredictionCompressedCandidate it = filePredictionCompressedCandidate2;
                boolean bl3 = false;
                featuresMs += it.getFeaturesComputation();
                Long l = it.getDuration();
                predictionMs += l != null ? l : 0L;
            }
            for (FilePredictionCompressedCandidate candidate : candidates) {
                featuresMs += candidate.getFeaturesComputation();
                Long l = candidate.getDuration();
                predictionMs += l != null ? l : 0L;
            }
            return CollectionsKt.arrayListOf((Object[])new Long[]{totalDuration, refsComputation, featuresMs, predictionMs});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

