/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public final class ClassSetImportModelProvider
implements ProjectImportModelProvider {
    @NotNull
    private final Set<Class<?>> projectModelClasses;
    @NotNull
    private final Set<Class<?>> buildModelClasses;

    public ClassSetImportModelProvider(@NotNull Set<Class<?>> projectModelClasses, @NotNull Set<Class<?>> buildModelClasses) {
        if (projectModelClasses == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(0);
        }
        if (buildModelClasses == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(1);
        }
        this.projectModelClasses = new LinkedHashSet(projectModelClasses);
        this.buildModelClasses = new LinkedHashSet(buildModelClasses);
    }

    public void populateBuildModels(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull ProjectImportModelProvider.BuildModelConsumer consumer) {
        if (controller == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(2);
        }
        if (buildModel == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(4);
        }
        for (Class<?> aClass : this.buildModelClasses) {
            Object instance = controller.findModel((Model)buildModel, aClass);
            if (instance == null) continue;
            consumer.consume((BuildModel)buildModel, instance, aClass);
        }
    }

    public void populateProjectModels(@NotNull BuildController controller, @Nullable Model module, @NotNull ProjectImportModelProvider.ProjectModelConsumer modelConsumer) {
        if (controller == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(5);
        }
        if (modelConsumer == null) {
            ClassSetImportModelProvider.$$$reportNull$$$0(6);
        }
        for (Class<?> aClass : this.projectModelClasses) {
            Object instance = controller.findModel(module, aClass);
            if (instance == null) continue;
            modelConsumer.consume(instance, aClass);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSetImportModelProvider provider = (ClassSetImportModelProvider)o;
        if (!this.projectModelClasses.equals(provider.projectModelClasses)) {
            return false;
        }
        return this.buildModelClasses.equals(provider.buildModelClasses);
    }

    public int hashCode() {
        int result = this.projectModelClasses.hashCode();
        result = 31 * result + this.buildModelClasses.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModelClasses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModelClasses";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/model/ClassSetImportModelProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "populateBuildModels";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "populateProjectModels";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

