/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayProviderDisablingAction;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProvider;
import org.jetbrains.kotlin.idea.codeInsight.hints.ShowInlayHintsSettings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider;", "T", "", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "()V", "hintsArePlacedAtTheEndOfLine", "", "getHintsArePlacedAtTheEndOfLine", "()Z", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "previewText", "", "getPreviewText", "()Ljava/lang/String;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Object;Lcom/intellij/codeInsight/hints/InlayHintsSink;)Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "isElementSupported", "resolved", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "(Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;Ljava/lang/Object;)Z", "PresentationAndSettings", "kotlin.idea"})
public abstract class KotlinAbstractHintsProvider<T>
implements InlayHintsProvider<T> {
    @NotNull
    private final SettingsKey<T> key;
    @Nullable
    private final String previewText;
    private final boolean hintsArePlacedAtTheEndOfLine;

    @NotNull
    public SettingsKey<T> getKey() {
        return this.key;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    public boolean getHintsArePlacedAtTheEndOfLine() {
        return this.hintsArePlacedAtTheEndOfLine;
    }

    public abstract boolean isElementSupported(@Nullable HintType var1, @NotNull T var2);

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull T settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (InlayHintsCollector)new FactoryInlayHintsCollector(this, settings, file, editor2, editor2){
            final /* synthetic */ KotlinAbstractHintsProvider this$0;
            final /* synthetic */ Object $settings;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;

            /*
             * WARNING - void declaration
             */
            public boolean collect(@NotNull PsiElement element3, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                HintType hintType = HintType.Companion.resolve(element3);
                if (hintType == null) {
                    return true;
                }
                HintType resolved = hintType;
                if (!this.this$0.isElementSupported(resolved, this.$settings)) {
                    return true;
                }
                Iterable $this$mapNotNull$iv = resolved.provideHints(element3);
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PresentationAndSettings presentationAndSettings;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    InlayInfo info = (InlayInfo)element$iv$iv;
                    boolean bl2 = false;
                    if (this.convert(info, editor2.getProject()) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    PresentationAndSettings it$iv$iv = presentationAndSettings;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    PresentationAndSettings p = (PresentationAndSettings)element$iv;
                    boolean bl = false;
                    sink.addInlineElement(p.getOffset(), p.getRelatesToPrecedingText(), p.getPresentation(), this.this$0.getHintsArePlacedAtTheEndOfLine());
                }
                return true;
            }

            @Nullable
            public final PresentationAndSettings convert(@NotNull InlayInfo inlayInfo, @Nullable Project project2) {
                Intrinsics.checkNotNullParameter((Object)inlayInfo, (String)"inlayInfo");
                String inlayText = this.getInlayPresentation(inlayInfo.getText());
                InlayPresentation presentation = this.getFactory().roundWithBackground(this.getFactory().smallText(inlayText));
                InlayPresentation finalPresentation2 = project2 == null ? presentation : (InlayPresentation)new InsetPresentation((InlayPresentation)new MenuOnClickPresentation(presentation, project2, (Function0)new Function0<List<? extends AnAction>>(this, project2){
                    final /* synthetic */ getCollectorFor.1 this$0;
                    final /* synthetic */ Project $project;

                    @NotNull
                    public final List<AnAction> invoke() {
                        KotlinAbstractHintsProvider provider2 = this.this$0.this$0;
                        Object[] objectArray = new AnAction[2];
                        String string = provider2.getName();
                        Language language = this.this$0.$file.getLanguage();
                        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
                        objectArray[0] = (AnAction)new InlayProviderDisablingAction(string, language, this.$project, provider2.getKey());
                        objectArray[1] = new ShowInlayHintsSettings();
                        return CollectionsKt.listOf((Object[])objectArray);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project2;
                        super(0);
                    }
                }), 1, 0, 0, 0, 28, null);
                return new PresentationAndSettings(finalPresentation2, inlayInfo.getOffset(), inlayInfo.getRelatesToPrecedingText());
            }

            @NotNull
            public final String getInlayPresentation(@NotNull String inlayText) {
                String string;
                Intrinsics.checkNotNullParameter((Object)inlayText, (String)"inlayText");
                if (StringsKt.startsWith$default((String)inlayText, (String)"@TYPE@", (boolean)false, (int)2, null)) {
                    String string2 = inlayText;
                    int n = "@TYPE@".length();
                    boolean bl = false;
                    String string3 = string2.substring(n);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string = inlayText + ':';
                }
                return string;
            }
            {
                this.this$0 = this$0;
                this.$settings = $captured_local_variable$1;
                this.$file = $captured_local_variable$2;
                this.$editor = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
    }

    public KotlinAbstractHintsProvider() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.key = new SettingsKey(string);
        this.previewText = "";
    }

    public boolean isVisibleInSettings() {
        return InlayHintsProvider.DefaultImpls.isVisibleInSettings((InlayHintsProvider)this);
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return InlayHintsProvider.DefaultImpls.isLanguageSupported((InlayHintsProvider)this, (Language)language);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider$PresentationAndSettings;", "", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "offset", "", "relatesToPrecedingText", "", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;IZ)V", "getOffset", "()I", "getPresentation", "()Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "getRelatesToPrecedingText", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "kotlin.idea"})
    public static final class PresentationAndSettings {
        @NotNull
        private final InlayPresentation presentation;
        private final int offset;
        private final boolean relatesToPrecedingText;

        @NotNull
        public final InlayPresentation getPresentation() {
            return this.presentation;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final boolean getRelatesToPrecedingText() {
            return this.relatesToPrecedingText;
        }

        public PresentationAndSettings(@NotNull InlayPresentation presentation, int offset, boolean relatesToPrecedingText) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            this.presentation = presentation;
            this.offset = offset;
            this.relatesToPrecedingText = relatesToPrecedingText;
        }

        @NotNull
        public final InlayPresentation component1() {
            return this.presentation;
        }

        public final int component2() {
            return this.offset;
        }

        public final boolean component3() {
            return this.relatesToPrecedingText;
        }

        @NotNull
        public final PresentationAndSettings copy(@NotNull InlayPresentation presentation, int offset, boolean relatesToPrecedingText) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            return new PresentationAndSettings(presentation, offset, relatesToPrecedingText);
        }

        public static /* synthetic */ PresentationAndSettings copy$default(PresentationAndSettings presentationAndSettings, InlayPresentation inlayPresentation, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inlayPresentation = presentationAndSettings.presentation;
            }
            if ((n2 & 2) != 0) {
                n = presentationAndSettings.offset;
            }
            if ((n2 & 4) != 0) {
                bl = presentationAndSettings.relatesToPrecedingText;
            }
            return presentationAndSettings.copy(inlayPresentation, n, bl);
        }

        @NotNull
        public String toString() {
            return "PresentationAndSettings(presentation=" + this.presentation + ", offset=" + this.offset + ", relatesToPrecedingText=" + this.relatesToPrecedingText + ")";
        }

        public int hashCode() {
            InlayPresentation inlayPresentation = this.presentation;
            int n = ((inlayPresentation != null ? inlayPresentation.hashCode() : 0) * 31 + Integer.hashCode(this.offset)) * 31;
            int n2 = this.relatesToPrecedingText ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PresentationAndSettings)) break block3;
                    PresentationAndSettings presentationAndSettings = (PresentationAndSettings)object;
                    if (!Intrinsics.areEqual((Object)this.presentation, (Object)presentationAndSettings.presentation) || this.offset != presentationAndSettings.offset || this.relatesToPrecedingText != presentationAndSettings.relatesToPrecedingText) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

