/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.UseExpressionBodyInspection;
import org.jetbrains.kotlin.idea.intentions.MergeIfsIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinBlockIntoSingleStatementHandler;", "Lcom/intellij/codeInsight/editorActions/JoinLinesHandlerDelegate;", "()V", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "kotlin.idea"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        int n;
        ASTNode[] oneLineReturnFunction;
        Object object;
        boolean bl;
        ASTNode[] aSTNodeArray;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof KtFile)) {
            return -1;
        }
        if (start == 0) {
            return -1;
        }
        char c = document.getCharsSequence().charAt(start);
        int index = c == '\n' ? start - 1 : start;
        PsiElement psiElement2 = file.findElementAt(index);
        if (psiElement2 == null) {
            return -1;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(index) ?: return CANNOT_JOIN");
        PsiElement brace = psiElement2;
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)brace), (Object)KtTokens.LBRACE) ^ true) {
            return -1;
        }
        PsiElement psiElement3 = brace.getParent();
        if (!(psiElement3 instanceof KtBlockExpression)) {
            psiElement3 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement3;
        if (ktBlockExpression == null) {
            return -1;
        }
        KtBlockExpression block = ktBlockExpression;
        List list = block.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"block.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list);
        if (ktExpression == null) {
            return -1;
        }
        KtExpression statement = ktExpression;
        PsiElement parent2 = block.getParent();
        UseExpressionBodyInspection useExpressionBodyInspection = new UseExpressionBodyInspection(false);
        PsiElement psiElement4 = parent2;
        if (!(psiElement4 instanceof KtDeclarationWithBody)) {
            psiElement4 = null;
        }
        ASTNode[] aSTNodeArray2 = (ASTNode[])psiElement4;
        if (aSTNodeArray2 != null) {
            aSTNodeArray = aSTNodeArray2;
            bl = false;
            boolean bl2 = false;
            ASTNode[] it = aSTNodeArray;
            boolean bl3 = false;
            object = useExpressionBodyInspection.isActiveFor((KtDeclarationWithBody)it) ? aSTNodeArray : null;
        } else {
            object = oneLineReturnFunction = null;
        }
        if (!(parent2 instanceof KtContainerNode) && !(parent2 instanceof KtWhenEntry) && oneLineReturnFunction == null) {
            return -1;
        }
        ASTNode[] aSTNodeArray3 = block.getNode().getChildren(KtTokens.COMMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray3, (String)"block.node.getChildren(KtTokens.COMMENTS)");
        aSTNodeArray = aSTNodeArray3;
        bl = false;
        ASTNode[] aSTNodeArray4 = aSTNodeArray;
        boolean bl4 = false;
        if (!(aSTNodeArray4.length == 0)) {
            return -1;
        }
        PsiElement pparent = parent2.getParent();
        if (pparent instanceof KtIfExpression) {
            PsiElement ifParent;
            if (Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getThen()) && statement instanceof KtIfExpression && ((KtIfExpression)statement).getElse() == null) {
                if (((KtIfExpression)pparent).getElse() != null) {
                    return -1;
                }
                return MergeIfsIntention.Companion.applyTo((KtIfExpression)pparent);
            }
            if (Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getElse()) && !((ifParent = ((KtIfExpression)pparent).getParent()) instanceof KtBlockExpression) && !(ifParent instanceof KtDeclaration) && !KtPsiUtil.isAssignment((PsiElement)ifParent)) {
                return -1;
            }
        }
        if (oneLineReturnFunction != null) {
            useExpressionBodyInspection.simplify((KtDeclarationWithBody)oneLineReturnFunction, false);
            KtExpression ktExpression2 = oneLineReturnFunction.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"oneLineReturnFunction.bodyExpression!!");
            n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression2));
        } else {
            PsiElement newStatement;
            PsiElement psiElement5 = newStatement = block.replace((PsiElement)statement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"newStatement");
            TextRange textRange = psiElement5.getTextRange();
            Intrinsics.checkNotNull((Object)textRange);
            n = textRange.getStartOffset();
        }
        return n;
    }
}

