/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsModel;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinFileChooserDialog;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class MoveKotlinTopLevelDeclarationsDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = "MoveKotlinTopLevelDeclarationsDialog.RECENTS_KEY";
    private final MoveCallback moveCallback;
    private final PsiDirectory initialTargetDirectory;
    private JCheckBox cbSearchInComments;
    private JCheckBox cbSearchTextOccurrences;
    private JPanel mainPanel;
    private ReferenceEditorComboWithBrowseButton classPackageChooser;
    private ComboboxWithBrowseButton destinationFolderCB;
    private JPanel targetPanel;
    private JRadioButton rbMoveToPackage;
    private JRadioButton rbMoveToFile;
    private TextFieldWithBrowseButton fileChooser;
    private JPanel memberInfoPanel;
    private JTextField tfFileNameInPackage;
    private JCheckBox cbDeleteEmptySourceFiles;
    private JCheckBox cbSearchReferences;
    private JCheckBox cbApplyMPPDeclarationsMove;
    private KotlinMemberSelectionTable memberTable;
    private final BitSet initializedCheckBoxesState;

    public MoveKotlinTopLevelDeclarationsDialog(@NotNull Project project2, @NotNull Set<KtNamedDeclaration> elementsToMove, @Nullable String targetPackageName, @Nullable PsiDirectory targetDirectory2, @Nullable KtFile targetFile2, boolean moveToPackage, @Nullable MoveCallback moveCallback) {
        if (project2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(0);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(1);
        }
        this(project2, elementsToMove, targetPackageName, targetDirectory2, targetFile2, moveToPackage, KotlinRefactoringSettings.getInstance().MOVE_SEARCH_IN_COMMENTS, KotlinRefactoringSettings.getInstance().MOVE_SEARCH_FOR_TEXT, KotlinRefactoringSettings.getInstance().MOVE_DELETE_EMPTY_SOURCE_FILES, KotlinRefactoringSettings.getInstance().MOVE_MPP_DECLARATIONS, moveCallback);
    }

    public MoveKotlinTopLevelDeclarationsDialog(@NotNull Project project2, @NotNull Set<KtNamedDeclaration> elementsToMove, @Nullable String targetPackageName, @Nullable PsiDirectory targetDirectory2, @Nullable KtFile targetFile2, boolean moveToPackage, boolean searchInComments, boolean searchForTextOccurrences, boolean deleteEmptySourceFiles, boolean moveMppDeclarations, @Nullable MoveCallback moveCallback) {
        if (project2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(2);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(3);
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.init();
        List<KtFile> sourceFiles2 = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(elementsToMove);
        this.moveCallback = moveCallback;
        this.initialTargetDirectory = targetDirectory2;
        this.setTitle(MoveHandler.getRefactoringName());
        List<KtNamedDeclaration> allDeclarations = MoveKotlinTopLevelDeclarationsDialog.getAllDeclarations(sourceFiles2);
        this.initSearchOptions(searchInComments, searchForTextOccurrences, deleteEmptySourceFiles, moveMppDeclarations, allDeclarations);
        this.initPackageChooser(targetPackageName, targetDirectory2, sourceFiles2);
        this.initFileChooser(targetFile2, elementsToMove, sourceFiles2);
        this.initMoveToButtons(moveToPackage);
        this.initMemberInfo(elementsToMove, allDeclarations);
        this.updateControls();
        this.initializedCheckBoxesState = this.getCheckboxesState(true);
    }

    protected void init() {
        super.init();
    }

    private BitSet getCheckboxesState(boolean applyDefaults) {
        BitSet state = new BitSet(5);
        state.set(0, applyDefaults || this.cbSearchInComments.isSelected());
        state.set(1, applyDefaults || this.cbSearchTextOccurrences.isSelected());
        state.set(2, applyDefaults || this.cbDeleteEmptySourceFiles.isSelected());
        state.set(3, applyDefaults || this.cbApplyMPPDeclarationsMove.isSelected());
        state.set(4, this.cbSearchReferences.isSelected());
        return state;
    }

    private static List<KtFile> getSourceFiles(@NotNull Collection<KtNamedDeclaration> elementsToMove) {
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(4);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.map(elementsToMove, KtPureElement::getContainingKtFile));
    }

    private static List<KtNamedDeclaration> getAllDeclarations(Collection<KtFile> sourceFiles2) {
        return CollectionsKt.filterIsInstance((Iterable)CollectionsKt.flatMap(sourceFiles2, KtPsiUtilKt::getFileOrScriptDeclarations), KtNamedDeclaration.class);
    }

    private void initMemberInfo(@NotNull Set<KtNamedDeclaration> elementsToMove, @NotNull List<KtNamedDeclaration> declarations) {
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(5);
        }
        if (declarations == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(6);
        }
        List<KotlinMemberInfo> memberInfos = MoveUtilsKt.mapWithReadActionInProcess(declarations, this.myProject, "Move", declaration2 -> {
            KotlinMemberInfo memberInfo = new KotlinMemberInfo((KtNamedDeclaration)declaration2, false);
            memberInfo.setChecked(elementsToMove.contains(declaration2));
            return memberInfo;
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange(memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener(listener2 -> this.updateControls());
        this.cbApplyMPPDeclarationsMove.addChangeListener(e -> this.updateControls());
        this.memberInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private void updateSuggestedFileName() {
        this.tfFileNameInPackage.setText(MoveUtilsKt.guessNewFileName(this.getSelectedElementsToMove()));
    }

    private void updateFileNameInPackageField() {
        boolean movingSingleFileToPackage = this.rbMoveToPackage.isSelected() && MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove()).size() == 1;
        this.tfFileNameInPackage.setEnabled(movingSingleFileToPackage);
    }

    private void initPackageChooser(String targetPackageName, PsiDirectory targetDirectory2, List<KtFile> sourceFiles2) {
        if (targetPackageName != null) {
            this.classPackageChooser.prependItem(targetPackageName);
        }
        ((KotlinDestinationFolderComboBox)this.destinationFolderCB).setData(this.myProject, targetDirectory2, new Pass<String>(){

            public void pass(String s) {
                MoveKotlinTopLevelDeclarationsDialog.this.setErrorText(s);
            }
        }, (EditorComboBox)this.classPackageChooser.getChildComponent());
    }

    private void initSearchOptions(boolean searchInComments, boolean searchForTextOccurences, boolean deleteEmptySourceFiles, boolean moveMppDeclarations, List<KtNamedDeclaration> allDeclarations) {
        this.cbSearchInComments.setSelected(searchInComments);
        this.cbSearchTextOccurrences.setSelected(searchForTextOccurences);
        this.cbDeleteEmptySourceFiles.setSelected(deleteEmptySourceFiles);
        this.cbApplyMPPDeclarationsMove.setSelected(moveMppDeclarations);
        this.cbApplyMPPDeclarationsMove.setVisible(this.isMPPDeclarationInList(allDeclarations));
    }

    private void initMoveToButtons(boolean moveToPackage) {
        if (moveToPackage) {
            this.rbMoveToPackage.setSelected(true);
        } else {
            this.rbMoveToFile.setSelected(true);
        }
        this.rbMoveToPackage.addActionListener(e -> {
            this.classPackageChooser.requestFocus();
            this.updateControls();
        });
        this.rbMoveToFile.addActionListener(e -> {
            this.fileChooser.requestFocus();
            this.updateControls();
        });
    }

    private void initFileChooser(@Nullable KtFile targetFile2, @NotNull Set<KtNamedDeclaration> elementsToMove, @NotNull List<KtFile> sourceFiles2) {
        PsiDirectory sourceDir;
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(7);
        }
        if (sourceFiles2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(8);
        }
        if ((sourceDir = sourceFiles2.get(0).getParent()) == null) {
            throw new AssertionError((Object)"File chooser initialization failed");
        }
        this.fileChooser.addActionListener(e -> {
            KtFile selectedFile;
            KotlinFileChooserDialog dialog2 = new KotlinFileChooserDialog(KotlinBundle.message("text.choose.containing.file", new Object[0]), this.myProject);
            File targetFile1 = new File(this.fileChooser.getText());
            PsiFile targetPsiFile = PhysicalFileSystemUtilsKt.toPsiFile((File)targetFile1, (Project)this.myProject);
            if (targetPsiFile != null) {
                if (targetPsiFile instanceof KtFile) {
                    dialog2.select((PsiNamedElement)((KtFile)targetPsiFile));
                } else {
                    PsiDirectory targetDir = PhysicalFileSystemUtilsKt.toPsiDirectory((File)targetFile1.getParentFile(), (Project)this.myProject);
                    if (targetDir != null) {
                        dialog2.selectDirectory(targetDir);
                    } else {
                        dialog2.selectDirectory(sourceDir);
                    }
                }
            } else {
                dialog2.selectDirectory(sourceDir);
            }
            dialog2.showDialog();
            KtFile ktFile = selectedFile = dialog2.isOK() ? (KtFile)dialog2.getSelected() : null;
            if (selectedFile != null) {
                this.fileChooser.setText(selectedFile.getVirtualFile().getPath());
            }
        });
        String initialTargetPath = targetFile2 != null ? targetFile2.getVirtualFile().getPath() : sourceFiles2.get(0).getVirtualFile().getParent().getPath() + "/" + MoveUtilsKt.guessNewFileName(elementsToMove);
        this.fileChooser.setText(initialTargetPath);
    }

    private void createUIComponents() {
        this.classPackageChooser = this.createPackageChooser();
        this.destinationFolderCB = new KotlinDestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return MoveKotlinTopLevelDeclarationsDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        return new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    private boolean isMPPDeclarationInList(List<KtNamedDeclaration> declarations) {
        for (KtNamedDeclaration element3 : declarations) {
            if (!ExpectActualUtilKt.isEffectivelyActual((KtDeclaration)element3, (boolean)true) && !ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)element3)) continue;
            return true;
        }
        return false;
    }

    private boolean isMppDeclarationSelected() {
        return this.isMPPDeclarationInList(this.getSelectedElementsToMove());
    }

    private void updateControls() {
        boolean needToMoveMPPDeclarations;
        boolean mppDeclarationSelected = this.isMppDeclarationSelected();
        this.cbApplyMPPDeclarationsMove.setEnabled(mppDeclarationSelected);
        boolean bl = needToMoveMPPDeclarations = mppDeclarationSelected && this.cbApplyMPPDeclarationsMove.isSelected();
        if (needToMoveMPPDeclarations && !this.rbMoveToPackage.isSelected()) {
            this.rbMoveToPackage.setSelected(true);
        }
        UIUtil.setEnabled((Component)this.rbMoveToFile, (!needToMoveMPPDeclarations ? 1 : 0) != 0, (boolean)true);
        boolean moveToPackage = this.rbMoveToPackage.isSelected();
        this.classPackageChooser.setEnabled(moveToPackage);
        this.updateFileNameInPackageField();
        this.fileChooser.setEnabled(!moveToPackage);
        UIUtil.setEnabled((Component)this.targetPanel, (moveToPackage && !needToMoveMPPDeclarations && this.hasAnySourceRoots() ? 1 : 0) != 0, (boolean)true);
        this.updateSuggestedFileName();
        this.myHelpAction.setEnabled(false);
    }

    private boolean hasAnySourceRoots() {
        return !ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.myProject).isEmpty();
    }

    private void saveRefactoringSettings() {
        KotlinRefactoringSettings refactoringSettings = KotlinRefactoringSettings.getInstance();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = this.cbSearchInComments.isSelected();
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = this.cbSearchTextOccurrences.isSelected();
        refactoringSettings.MOVE_DELETE_EMPTY_SOURCE_FILES = this.cbDeleteEmptySourceFiles.isSelected();
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
        refactoringSettings.MOVE_MPP_DECLARATIONS = this.cbApplyMPPDeclarationsMove.isSelected();
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, this.getTargetPackage());
    }

    private List<KtNamedDeclaration> getSelectedElementsToMove() {
        return CollectionsKt.map((Iterable)this.memberTable.getSelectedMemberInfos(), MemberInfoBase::getMember);
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    private String getTargetPackage() {
        return this.classPackageChooser.getText().trim();
    }

    private List<KtNamedDeclaration> getSelectedElementsToMoveChecked() throws ConfigurationException {
        List<KtNamedDeclaration> elementsToMove = this.getSelectedElementsToMove();
        if (elementsToMove.isEmpty()) {
            throw new ConfigurationException(KotlinBundle.message("text.no.elements.to.move.are.selected", new Object[0]));
        }
        return elementsToMove;
    }

    private MoveKotlinTopLevelDeclarationsModel getModel() throws ConfigurationException {
        boolean mppDeclarationSelected = this.cbApplyMPPDeclarationsMove.isSelected() && this.isMppDeclarationSelected();
        PsiDirectory selectedPsiDirectory = null;
        if (!mppDeclarationSelected) {
            DirectoryChooser.ItemWrapper selectedItem = (DirectoryChooser.ItemWrapper)this.destinationFolderCB.getComboBox().getSelectedItem();
            selectedPsiDirectory = selectedItem != null ? selectedItem.getDirectory() : this.initialTargetDirectory;
        }
        List<KtNamedDeclaration> selectedElements2 = this.getSelectedElementsToMoveChecked();
        return new MoveKotlinTopLevelDeclarationsModel(this.myProject, selectedElements2, this.getTargetPackage(), selectedPsiDirectory, this.tfFileNameInPackage.getText(), this.fileChooser.getText(), this.rbMoveToPackage.isSelected(), this.cbSearchReferences.isSelected(), this.cbSearchInComments.isSelected(), this.cbSearchTextOccurrences.isSelected(), this.cbDeleteEmptySourceFiles.isSelected(), mppDeclarationSelected, this.moveCallback);
    }

    protected void doAction() {
        ModelResultWithFUSData modelResult;
        try {
            modelResult = this.getModel().computeModelResult();
        }
        catch (ConfigurationException e) {
            this.setErrorText(e.getMessage());
            return;
        }
        this.saveRefactoringSettings();
        try {
            MoveUtilsKt.logFusForMoveRefactoring(modelResult.getElementsCount(), modelResult.getEntityToMove(), modelResult.getDestination(), this.getCheckboxesState(false).equals(this.initializedCheckBoxesState), () -> this.invokeRefactoring(modelResult.getProcessor()));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classPackageChooser.getChildComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initFileChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JTextField jTextField;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "Center");
        this.memberInfoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.classPackageChooser;
        jPanel7.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToPackage = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.to.package"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fileChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToFile = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.to.file"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.file.name"));
        jPanel7.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null, 5));
        this.tfFileNameInPackage = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel7.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.targetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 5));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.destination.directory"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.destinationFolderCB;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.cbSearchInComments = nonFocusableCheckBox;
        nonFocusableCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("search.in.comments.and.strings"));
        jPanel8.add((Component)nonFocusableCheckBox, new GridConstraints(1, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.cbSearchTextOccurrences = nonFocusableCheckBox2;
        nonFocusableCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("search.for.text.occurrences"));
        jPanel8.add((Component)nonFocusableCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        this.cbSearchReferences = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("checkbox.text.search.references"));
        jPanel8.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbDeleteEmptySourceFiles = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("checkbox.text.delete.empty.source.files"));
        jPanel8.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbApplyMPPDeclarationsMove = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.move.expect.actual.counterparts"));
        jPanel8.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel2.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MemberInfoModelImpl
    extends AbstractMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        private MemberInfoModelImpl() {
        }
    }
}

