/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.cms.bc;

import org.gradle.internal.impldep.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSException;
import org.gradle.internal.impldep.org.bouncycastle.cms.KeyTransRecipient;
import org.gradle.internal.impldep.org.bouncycastle.cms.bc.CMSUtils;
import org.gradle.internal.impldep.org.bouncycastle.crypto.CipherParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gradle.internal.impldep.org.bouncycastle.operator.OperatorException;
import org.gradle.internal.impldep.org.bouncycastle.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.recipientKey = asymmetricKeyParameter;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper bcRSAAsymmetricKeyUnwrapper = new BcRSAAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return CMSUtils.getBcKey(bcRSAAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

