/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.simpleframework.http.Part;
import org.gradle.internal.impldep.org.simpleframework.http.core.BodyConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.PartEntryConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.PartEntryFactory;
import org.gradle.internal.impldep.org.simpleframework.http.core.PartList;
import org.gradle.internal.impldep.org.simpleframework.transport.Cursor;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.Allocator;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.BufferAllocator;

class PartListConsumer
extends BodyConsumer {
    private PartEntryConsumer consumer;
    private PartEntryFactory factory;
    private BufferAllocator buffer;
    private PartList list;

    public PartListConsumer(Allocator allocator, byte[] boundary) {
        this(allocator, boundary, 8192);
    }

    public PartListConsumer(Allocator allocator, byte[] boundary, int length) {
        this(allocator, new PartList(), boundary, length);
    }

    public PartListConsumer(Allocator allocator, PartList list, byte[] boundary) {
        this(allocator, list, boundary, 8192);
    }

    public PartListConsumer(Allocator allocator, PartList list, byte[] boundary, int length) {
        this.buffer = new BufferAllocator(allocator, length);
        this.consumer = new PartEntryConsumer(this.buffer, list, boundary);
        this.factory = new PartEntryFactory(this.buffer, list, boundary);
        this.list = list;
    }

    public void consume(Cursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (!this.consumer.isFinished()) {
                this.consumer.consume(cursor);
                continue;
            }
            if (this.consumer.isEnd()) break;
            this.consumer = this.factory.getInstance();
        }
    }

    public boolean isFinished() {
        return this.consumer.isEnd();
    }

    public String getContent() throws IOException {
        return this.buffer.encode();
    }

    public String getContent(String charset) throws IOException {
        return this.buffer.encode(charset);
    }

    public InputStream getInputStream() throws IOException {
        return this.buffer.getInputStream();
    }

    public Part getPart(String name) {
        return this.list.getPart(name);
    }

    public PartList getParts() {
        return this.list;
    }
}

