/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.gradle.internal.impldep.org.simpleframework.transport.Packet;
import org.gradle.internal.impldep.org.simpleframework.transport.Segment;
import org.gradle.internal.impldep.org.simpleframework.transport.SegmentBuilder;
import org.gradle.internal.impldep.org.simpleframework.transport.Socket;
import org.gradle.internal.impldep.org.simpleframework.transport.TransportException;
import org.gradle.internal.impldep.org.simpleframework.transport.Writer;

class SocketWriter
implements Writer {
    private SegmentBuilder builder;
    private SocketChannel channel;
    private boolean closed;

    public SocketWriter(Socket socket) {
        this(socket, 20480);
    }

    public SocketWriter(Socket socket, int limit) {
        this.builder = new SegmentBuilder(limit);
        this.channel = socket.getChannel();
    }

    public synchronized SocketChannel getChannel() {
        return this.channel;
    }

    public synchronized boolean isBlocking() throws IOException {
        return this.builder.isReference();
    }

    public synchronized boolean write(Packet packet) throws IOException {
        Segment segment = this.builder.build(packet);
        if (segment == null) {
            return true;
        }
        return this.flush();
    }

    private synchronized int write(Segment segment) throws IOException {
        int size = segment.write(this.channel);
        int left = segment.length();
        if (left == 0) {
            segment.close();
        }
        if (size < 0) {
            throw new TransportException("Socket is closed");
        }
        return size;
    }

    public synchronized boolean flush() throws IOException {
        Segment segment = this.builder.build();
        while (segment != null) {
            int size = this.write(segment);
            if (size < 0) {
                throw new TransportException("Connection reset");
            }
            if (size == 0) break;
            segment = this.builder.build();
        }
        return this.complete();
    }

    private synchronized boolean complete() throws IOException {
        int count = this.builder.length();
        if (count > 0) {
            this.builder.compact();
        }
        return count <= 0;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.builder.close();
            try {
                this.channel.socket().shutdownOutput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.channel.close();
        }
    }
}

