/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.maven.polyglot.mapping;

import java.io.File;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelReader;
import org.gradle.internal.impldep.org.apache.maven.model.io.ModelWriter;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.internal.impldep.org.sonatype.maven.polyglot.mapping.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingSupport
implements Mapping {
    private static final String[] EMPTY = new String[0];
    private String roleHint;
    private String[] pomNames = EMPTY;
    private String[] acceptOptionKeys = EMPTY;
    private String[] acceptLocationExtensions = EMPTY;
    private float priority;
    @Requirement
    private PlexusContainer container;
    private ModelReader reader;
    private ModelWriter writer;

    protected MappingSupport(String roleHint) {
        this.roleHint = roleHint;
    }

    @Override
    public ModelReader getReader() {
        if (this.reader == null) {
            try {
                assert (this.container != null);
                this.reader = this.container.lookup(ModelReader.class, this.roleHint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        }
        return this.reader;
    }

    @Override
    public ModelWriter getWriter() {
        if (this.writer == null) {
            try {
                assert (this.container != null);
                this.writer = this.container.lookup(ModelWriter.class, this.roleHint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        }
        return this.writer;
    }

    public String[] getAcceptLocationExtensions() {
        return this.acceptLocationExtensions;
    }

    public void setAcceptLocationExtensions(String ... accept) {
        this.acceptLocationExtensions = accept;
    }

    public String[] getAcceptOptionKeys() {
        return this.acceptOptionKeys;
    }

    public void setAcceptOptionKeys(String ... accept) {
        this.acceptOptionKeys = accept;
    }

    public String[] getPomNames() {
        return this.pomNames;
    }

    public void setPomNames(String ... names) {
        this.pomNames = names;
    }

    @Override
    public File locatePom(File dir2) {
        assert (dir2 != null);
        for (String name : this.getPomNames()) {
            File file = new File(dir2, name);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    @Override
    public boolean accept(Map<String, ?> options) {
        if (options != null) {
            for (String key : this.getAcceptOptionKeys()) {
                if (!options.containsKey(key)) continue;
                return true;
            }
            String location = String.valueOf(options.get("org.gradle.internal.impldep.org.apache.maven.model.building.location"));
            if (location != null) {
                for (String ext : this.getAcceptLocationExtensions()) {
                    if (!location.endsWith(ext)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    protected void setPriority(float priority) {
        this.priority = priority;
    }
}

