/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.GradleCommandLineProjectConfiguratorKt;
import org.jetbrains.plugins.gradle.settings.GradleImportHint;
import org.jetbrains.plugins.gradle.settings.GradleImportHintService;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "getImportSpecBuilder", "Lcom/intellij/openapi/externalSystem/importing/ImportSpecBuilder;", "getName", "TaskNotificationListener", "intellij.gradle.common"})
public final class GradleCommandLineProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "gradle";
    }

    @NotNull
    public String getDescription() {
        String string = GradleBundle.message("gradle.commandline.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GradleBundle.message(\"gr\u2026commandline.description\")");
        return string;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CommandLineInspectionProjectConfigurator.ConfiguratorContext configuratorContext = context;
        boolean bl = false;
        boolean bl2 = false;
        CommandLineInspectionProjectConfigurator.ConfiguratorContext $this$run = configuratorContext;
        boolean bl3 = false;
        Registry.get((String)"external.system.auto.import.disabled").setValue(true);
    }

    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        String kotlinDslGradleFile;
        String gradleGroovyDslFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return");
        String basePath = string;
        GradleImportHint state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
        if (state.getSkip()) {
            return;
        }
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)new TaskNotificationListener());
        Collection collection = state.getProjectsToImport();
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (String projectPath : state.getProjectsToImport()) {
                File buildFile = new File(basePath).toPath().resolve(projectPath).toFile();
                if (buildFile.exists()) {
                    File file = buildFile;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildFile");
                    ExternalSystemUtil.refreshProject((String)file.getAbsolutePath(), (ImportSpecBuilder)this.getImportSpecBuilder(project));
                    continue;
                }
                Logger logger = GradleCommandLineProjectConfiguratorKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("File for importing gradle project doesn't exist: ");
                File file = buildFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildFile");
                logger.warn(stringBuilder.append(file.getAbsolutePath()).toString());
            }
            return;
        }
        Path path = context.getProjectPath().resolve(".idea");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"context.projectPath.resolve(\".idea\")");
        boolean wasAlreadyImported = PathKt.exists((Path)path);
        if (wasAlreadyImported) {
            GradleSettings gradleSettings = GradleSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
            if (!gradleSettings.getLinkedProjectsSettings().isEmpty()) {
                ExternalSystemUtil.refreshProjects((ImportSpecBuilder)this.getImportSpecBuilder(project));
                return;
            }
        }
        if (FileUtil.findFirstThatExist((String[])new String[]{gradleGroovyDslFile = basePath + "/" + "build.gradle", kotlinDslGradleFile = basePath + "/" + "build.gradle.kts"}) == null) {
            return;
        }
        ExternalSystemUtil.refreshProject((String)basePath, (ImportSpecBuilder)this.getImportSpecBuilder(project));
    }

    private final ImportSpecBuilder getImportSpecBuilder(Project project) {
        ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).use(ProgressExecutionMode.MODAL_SYNC);
        Intrinsics.checkNotNullExpressionValue((Object)importSpecBuilder, (String)"ImportSpecBuilder(projec\u2026YSTEM_ID).use(MODAL_SYNC)");
        return importSpecBuilder;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/GradleCommandLineProjectConfigurator$TaskNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "()V", "beforeCancel", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onCancel", "onEnd", "onFailure", "e", "Ljava/lang/Exception;", "onStart", "onStatusChange", "event", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationEvent;", "onSuccess", "onTaskOutput", "text", "", "stdOut", "", "intellij.gradle.common"})
    public static final class TaskNotificationListener
    implements ExternalSystemTaskNotificationListener {
        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle import success");
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().error("Gradle import failure", (Throwable)e);
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            GradleCommandLineProjectConfiguratorKt.access$getGRADLE_OUTPUT_LOG$p().debug("[Gradle " + (stdOut ? "STDOUT" : "STDERR") + " ] " + text);
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().warn("Gradle import canceled");
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        }

        public void beforeCancel(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        }

        public void onStart(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleCommandLineProjectConfiguratorKt.access$getLOG$p().info("Gradle import started");
        }
    }
}

