/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.actions.runAnything.RunAnythingManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsConverter;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecuteTaskAction
extends ExternalSystemAction {
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (e == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(0);
        }
        if (!super.isVisible(e)) {
            return false;
        }
        ExternalProjectsView projectsView = (ExternalProjectsView)e.getData(ExternalSystemDataKeys.VIEW);
        return projectsView == null || GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(2);
        }
        Presentation p = e.getPresentation();
        p.setVisible(this.isVisible(e));
        p.setEnabled(this.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        RunAnythingManager runAnythingManager = RunAnythingManager.getInstance((Project)project);
        runAnythingManager.show("gradle ", false, e);
    }

    public static void runGradle(@NotNull Project project, @Nullable Executor executor, @NotNull String workDirectory, @NotNull String fullCommandLine) {
        ExternalTaskExecutionInfo taskExecutionInfo;
        if (project == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(4);
        }
        if (workDirectory == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(5);
        }
        if (fullCommandLine == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(6);
        }
        try {
            taskExecutionInfo = GradleExecuteTaskAction.buildTaskInfo(workDirectory, fullCommandLine, executor);
        }
        catch (CommandLineArgumentException ex) {
            NotificationData notificationData = new NotificationData("<b>Command-line arguments cannot be parsed</b>", "<i>" + fullCommandLine + "</i> \n" + ex.getMessage(), NotificationCategory.WARNING, NotificationSource.TASK_EXECUTION);
            notificationData.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notificationData);
            return;
        }
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (String)taskExecutionInfo.getExecutorId(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        RunnerAndConfigurationSettings configuration = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (configuration == null) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings existingConfiguration = runManager.findConfigurationByTypeAndName(configuration.getType(), configuration.getName());
        if (existingConfiguration == null) {
            runManager.setTemporaryConfiguration(configuration);
        } else {
            runManager.setSelectedConfiguration(existingConfiguration);
        }
    }

    private static ExternalTaskExecutionInfo buildTaskInfo(@NotNull String projectPath, @NotNull String fullCommandLine, @Nullable Executor executor) throws CommandLineArgumentException {
        if (projectPath == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(7);
        }
        if (fullCommandLine == null) {
            GradleExecuteTaskAction.$$$reportNull$$$0(8);
        }
        CommandLineParser gradleCmdParser = new CommandLineParser();
        GradleCommandLineOptionsConverter commandLineConverter = new GradleCommandLineOptionsConverter();
        commandLineConverter.configure(gradleCmdParser);
        ParsedCommandLine parsedCommandLine = gradleCmdParser.parse((Iterable)ParametersListUtil.parse((String)fullCommandLine, (boolean)true, (boolean)true));
        Map<String, List<String>> optionsMap = commandLineConverter.convert(parsedCommandLine, new HashMap<String, List<String>>());
        List<String> systemProperties = optionsMap.remove("system-prop");
        String vmOptions = systemProperties == null ? "" : StringUtil.join(systemProperties, entry -> "-D" + entry, (String)" ");
        StringBuilder scriptParameters = new StringBuilder(StringUtil.join(optionsMap.entrySet(), entry -> {
            List values = (List)entry.getValue();
            String longOptionName = (String)entry.getKey();
            if (values != null && !values.isEmpty()) {
                return StringUtil.join((Collection)values, entry1 -> "--" + longOptionName + " " + entry1, (String)" ");
            }
            return "--" + longOptionName;
        }, (String)" "));
        ArrayList<String> tasks = new ArrayList<String>();
        boolean isTaskArgument = false;
        for (String argument : parsedCommandLine.getExtraArguments()) {
            if (!isTaskArgument && argument.startsWith("-")) {
                scriptParameters.append(" ").append(argument);
                continue;
            }
            isTaskArgument = true;
            tasks.add(argument);
        }
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExternalProjectPath(projectPath);
        settings2.setTaskNames(tasks);
        settings2.setScriptParameters(scriptParameters.toString().trim());
        settings2.setVmOptions(vmOptions);
        settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
        return new ExternalTaskExecutionInfo(settings2, executor == null ? "Run" : executor.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDirectory";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCommandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/action/GradleExecuteTaskAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runGradle";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTaskInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

