/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleAutoImportAware
implements ExternalSystemAutoImportAware {
    private static final Logger LOG = Logger.getInstance(GradleAutoImportAware.class);

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        if (changedFileOrDirPath == null) {
            GradleAutoImportAware.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(1);
        }
        if (!changedFileOrDirPath.endsWith(".gradle") && !changedFileOrDirPath.endsWith(".gradle.kts")) {
            return null;
        }
        if (GradleAutoImportAware.isInsideCompileOutput(changedFileOrDirPath, project)) {
            return null;
        }
        File file = new File(changedFileOrDirPath);
        if (file.isDirectory()) {
            return null;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return null;
        }
        HashMap<String, String> rootPaths = new HashMap<String, String>();
        for (ExternalProjectSettings setting : projectsSettings) {
            if (setting == null) continue;
            for (String path : setting.getModules()) {
                rootPaths.put(new File(path).getAbsolutePath(), setting.getExternalProjectPath());
            }
        }
        for (File f = file.getParentFile(); f != null; f = f.getParentFile()) {
            String dirPath = f.getAbsolutePath();
            if (!rootPaths.containsKey(dirPath)) continue;
            return (String)rootPaths.get(dirPath);
        }
        return null;
    }

    private static boolean isInsideCompileOutput(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            GradleAutoImportAware.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(3);
        }
        String url = VfsUtilCore.pathToUrl((String)path);
        boolean isInsideProjectCompile = Optional.ofNullable(CompilerProjectExtension.getInstance((Project)project)).map(CompilerProjectExtension::getCompilerOutputUrl).filter(outputUrl -> VfsUtilCore.isEqualOrAncestor((String)outputUrl, (String)url)).isPresent();
        if (isInsideProjectCompile) {
            return true;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).map(CompilerModuleExtension::getInstance).filter(Objects::nonNull).flatMap(ex -> Stream.of(ex.getCompilerOutputUrl(), ex.getCompilerOutputUrlForTests())).filter(Objects::nonNull).anyMatch(outputUrl -> VfsUtilCore.isEqualOrAncestor((String)outputUrl, (String)url));
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project) {
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(4);
        }
        SmartList files = new SmartList();
        String serviceDirectoryPath = GradleSettings.getInstance(project).getServiceDirectoryPath();
        File gradleUserHomeDir = new BuildLayoutParameters().getGradleUserHomeDir();
        files.add(new File(serviceDirectoryPath != null ? serviceDirectoryPath : gradleUserHomeDir.getPath(), "gradle.properties"));
        files.add(new File(serviceDirectoryPath != null ? serviceDirectoryPath : gradleUserHomeDir.getPath(), "init.gradle"));
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(projectPath);
        files.add(new File(projectSettings == null ? projectPath : projectSettings.getExternalProjectPath(), "gradle.properties"));
        if (projectSettings != null && projectSettings.getDistributionType() == DistributionType.DEFAULT_WRAPPED) {
            files.add(new File(projectSettings.getExternalProjectPath(), "gradle/wrapper/gradle-wrapper.properties"));
        }
        Set subProjectPaths = projectSettings != null && FileUtil.pathsEqual((String)projectSettings.getExternalProjectPath(), (String)projectPath) ? projectSettings.getModules() : ContainerUtil.set((Object[])new String[]{projectPath});
        for (String path : subProjectPaths) {
            ProgressManager.checkCanceled();
            try {
                Files.walkFileTree(Paths.get(path, new String[0]), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((List)files){
                    final /* synthetic */ List val$files;
                    {
                        this.val$files = list;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        File file;
                        String fileName = path.getFileName().toString();
                        if ((fileName.endsWith(".gradle") || fileName.endsWith(".gradle.kts")) && (file = path.toFile()).isFile()) {
                            this.val$files.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug((Throwable)e);
            }
        }
        return files;
    }

    public boolean isApplicable(@Nullable ProjectResolverPolicy resolverPolicy) {
        return resolverPolicy == null || !resolverPolicy.isPartialDataResolveAllowed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFileOrDirPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedExternalProjectPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideCompileOutput";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedExternalProjectFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

