/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JScrollBar;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JScrollBarLocation;
import org.fest.swing.driver.JScrollBarSetValueTask;
import org.fest.swing.driver.JScrollBarValueQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

@InternalApi
public class JScrollBarDriver
extends JComponentDriver {
    private static final String VALUE_PROPERTY = "value";
    private final JScrollBarLocation location = new JScrollBarLocation();

    public JScrollBarDriver(@Nonnull Robot robot) {
        super(robot);
    }

    public void scrollUnitUp(@Nonnull JScrollBar scrollBar) {
        this.scrollUnitUp(scrollBar, 1);
    }

    public void scrollUnitUp(@Nonnull JScrollBar scrollBar, int times) {
        this.checkPositive(times, "scroll up one unit");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.findScrollUnitInfo(scrollBar, this.location(), times * -1);
        this.scroll(scrollBar, scrollInfo);
    }

    public void scrollUnitDown(@Nonnull JScrollBar scrollBar) {
        this.scrollUnitDown(scrollBar, 1);
    }

    public void scrollUnitDown(@Nonnull JScrollBar scrollBar, int times) {
        this.checkPositive(times, "scroll down one unit");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.findScrollUnitInfo(scrollBar, this.location(), times);
        this.scroll(scrollBar, scrollInfo);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Point, Integer> findScrollUnitInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location, final int times) {
        Pair<Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollUnitInfo(scrollBar, location, times);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Point, Integer> scrollUnitInfo(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int times) {
        Point where = JScrollBarDriver.blockLocation(scrollBar, location, times);
        int count = times * scrollBar.getUnitIncrement();
        return Pair.of(where, scrollBar.getValue() + count);
    }

    @RunsInEDT
    public void scrollBlockUp(@Nonnull JScrollBar scrollBar) {
        this.scrollBlockUp(scrollBar, 1);
    }

    @RunsInEDT
    public void scrollBlockUp(@Nonnull JScrollBar scrollBar, int times) {
        this.checkPositive(times, "scroll up one block");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollBlockInfo(scrollBar, this.location(), times * -1);
        this.scroll(scrollBar, scrollInfo);
    }

    @RunsInEDT
    public void scrollBlockDown(@Nonnull JScrollBar scrollBar) {
        this.scrollBlockDown(scrollBar, 1);
    }

    @RunsInEDT
    public void scrollBlockDown(@Nonnull JScrollBar scrollBar, int times) {
        this.checkPositive(times, "scroll down one block");
        Pair<Point, Integer> scrollInfo = JScrollBarDriver.validateAndFindScrollBlockInfo(scrollBar, this.location(), times);
        this.scroll(scrollBar, scrollInfo);
    }

    private void checkPositive(int times, @Nonnull String action) {
        if (times > 0) {
            return;
        }
        String msg = String.format("The number of times to %s should be greater than zero, but was <%d>", action, times);
        throw new IllegalArgumentException(msg);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Point, Integer> validateAndFindScrollBlockInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location, final int times) {
        Pair<Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Pair<Point, Integer>>(){

            @Override
            protected Pair<Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollBlockInfo(scrollBar, location, times);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private static Pair<Point, Integer> scrollBlockInfo(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int times) {
        Point where = JScrollBarDriver.blockLocation(scrollBar, location, times);
        int count = times * scrollBar.getBlockIncrement();
        return Pair.of(where, scrollBar.getValue() + count);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point blockLocation(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int times) {
        return times > 0 ? location.blockLocationToScrollDown(scrollBar) : location.blockLocationToScrollUp(scrollBar);
    }

    @RunsInEDT
    private void scroll(@Nonnull JScrollBar scrollBar, @Nonnull Pair<Point, Integer> scrollInfo) {
        this.robot.moveMouse(scrollBar, (Point)Preconditions.checkNotNull(scrollInfo.first));
        this.setValueProperty(scrollBar, (Integer)scrollInfo.second);
    }

    @RunsInEDT
    public void scrollToMaximum(@Nonnull JScrollBar scrollBar) {
        Pair<Integer, GenericRange<Point>> scrollInfo = JScrollBarDriver.findScrollToMaximumInfo(scrollBar, this.location());
        this.scroll(scrollBar, (Integer)scrollInfo.first, (GenericRange)Preconditions.checkNotNull(scrollInfo.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findScrollToMaximumInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location) {
        Pair<Integer, GenericRange<Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                int position = scrollBar.getMaximum();
                GenericRange scrollInfo = JScrollBarDriver.scrollInfo(scrollBar, location, position);
                return Pair.of(position, scrollInfo);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    public void scrollToMinimum(@Nonnull JScrollBar scrollBar) {
        Pair<Integer, GenericRange<Point>> scrollInfo = JScrollBarDriver.findScrollToMinimumInfo(scrollBar, this.location);
        this.scroll(scrollBar, (Integer)scrollInfo.first, (GenericRange)Preconditions.checkNotNull(scrollInfo.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, GenericRange<Point>> findScrollToMinimumInfo(final @Nonnull JScrollBar scrollBar, final JScrollBarLocation location) {
        Pair<Integer, GenericRange<Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, GenericRange<Point>>>(){

            @Override
            protected Pair<Integer, GenericRange<Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                int position = scrollBar.getMinimum();
                GenericRange scrollInfo = JScrollBarDriver.scrollInfo(scrollBar, location, position);
                return Pair.of(position, scrollInfo);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    public void scrollTo(@Nonnull JScrollBar scrollBar, int position) {
        GenericRange<Point> scrollInfo = JScrollBarDriver.validateAndFindScrollInfo(scrollBar, this.location(), position);
        this.scroll(scrollBar, position, scrollInfo);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> validateAndFindScrollInfo(final @Nonnull JScrollBar scrollBar, final @Nonnull JScrollBarLocation location, final int position) {
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                JScrollBarDriver.checkPositionInBounds(scrollBar, position);
                ComponentPreconditions.checkEnabledAndShowing(scrollBar);
                return JScrollBarDriver.scrollInfo(scrollBar, location, position);
            }
        });
        return (GenericRange)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private static void checkPositionInBounds(@Nonnull JScrollBar scrollBar, int position) {
        int min = scrollBar.getMinimum();
        int max = scrollBar.getMaximum();
        if (position >= min && position <= max) {
            return;
        }
        throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Position <", position, "> is not within the JScrollBar bounds of <", min, "> and <", max, ">"}));
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> scrollInfo(@Nonnull JScrollBar scrollBar, @Nonnull JScrollBarLocation location, int position) {
        Point from = location.thumbLocation(scrollBar, scrollBar.getValue());
        Point to = location.thumbLocation(scrollBar, position);
        return new GenericRange<Point>(from, to);
    }

    private void scroll(@Nonnull JScrollBar scrollBar, int position, @Nonnull GenericRange<Point> points) {
        this.simulateScrolling(scrollBar, points);
        this.setValueProperty(scrollBar, position);
    }

    @RunsInEDT
    private void simulateScrolling(@Nonnull JScrollBar scrollBar, @Nonnull GenericRange<Point> points) {
        this.robot.moveMouse(scrollBar, points.from());
        this.robot.moveMouse(scrollBar, points.to());
    }

    @RunsInEDT
    private void setValueProperty(@Nonnull JScrollBar scrollBar, int value) {
        JScrollBarSetValueTask.setValue(scrollBar, value);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void requireValue(@Nonnull JScrollBar scrollBar, int value) {
        ((IntAssert)Assertions.assertThat((int)JScrollBarValueQuery.valueOf(scrollBar)).as(JScrollBarDriver.propertyName(scrollBar, VALUE_PROPERTY))).isEqualTo(value);
    }

    @Nonnull
    private JScrollBarLocation location() {
        return this.location;
    }
}

