/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RollbackProgressModifier
implements RollbackProgressListener {
    private final Set<String> myTakenPaths;
    private final double myTotal;
    private final ProgressIndicator myIndicator;
    private int myCnt;

    public RollbackProgressModifier(double total, ProgressIndicator indicator) {
        this.myTotal = total;
        this.myIndicator = indicator;
        this.myTakenPaths = new HashSet<String>();
        this.myCnt = 0;
    }

    private void acceptImpl(String name) {
        if (this.myIndicator != null) {
            this.myIndicator.setText2(VcsBundle.message((String)"rolling.back.file", (Object[])new Object[]{name}));
            this.checkName(name);
            if (!this.myIndicator.isIndeterminate()) {
                this.myIndicator.setFraction((double)this.myCnt / this.myTotal);
            }
            this.myIndicator.checkCanceled();
        }
    }

    private void checkName(String name) {
        if (!this.myTakenPaths.contains(name)) {
            this.myTakenPaths.add(name);
            if (this.myTotal >= (double)(this.myCnt + 1)) {
                ++this.myCnt;
            }
        }
    }

    public void determinate() {
        if (this.myIndicator != null) {
            this.myIndicator.setIndeterminate(false);
        }
    }

    public void indeterminate() {
        if (this.myIndicator != null) {
            this.myIndicator.setIndeterminate(true);
        }
    }

    public void accept(@NotNull Change change) {
        if (change == null) {
            RollbackProgressModifier.$$$reportNull$$$0(0);
        }
        this.acceptImpl(ChangesUtil.getFilePath((Change)change).getPath());
    }

    public void accept(@NotNull FilePath filePath) {
        if (filePath == null) {
            RollbackProgressModifier.$$$reportNull$$$0(1);
        }
        this.acceptImpl(filePath.getPath());
    }

    public void accept(List<? extends FilePath> paths) {
        if (this.myIndicator != null && paths != null && !paths.isEmpty()) {
            for (FilePath filePath : paths) {
                this.checkName(filePath.getPath());
            }
            this.myIndicator.setFraction((double)this.myCnt / this.myTotal);
            this.myIndicator.setText2(VcsBundle.message((String)"rolling.back.file", (Object[])new Object[]{paths.get(0).getPath()}));
        }
    }

    public void accept(File file) {
        this.acceptImpl(file.getAbsolutePath());
    }

    public void accept(VirtualFile file) {
        this.acceptImpl(new File(file.getPath()).getAbsolutePath());
    }

    public void checkCanceled() {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "change";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/ui/RollbackProgressModifier";
        objectArray[2] = "accept";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

