/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.idea.artifacts.KotlinClassPath;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010J3\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J1\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil;", "", "()V", "jdkToolsJar", "Ljava/io/File;", "getJdkToolsJar$kotlin_jps_plugin", "()Ljava/io/File;", "ourClassLoaderRef", "Ljava/lang/ref/SoftReference;", "Ljava/lang/ClassLoader;", "getOrCreateClassLoader", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "paths", "", "invokeClassesFqNames", "", "", "files", "invokeExecMethod", "compilerClassName", "arguments", "", "out", "Ljava/io/PrintStream;", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;Ljava/io/PrintStream;)Ljava/lang/Object;", "withCompilerClassloader", "T", "fn", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin.jps-plugin"})
public final class CompilerRunnerUtil {
    private static SoftReference<ClassLoader> ourClassLoaderRef;
    public static final CompilerRunnerUtil INSTANCE;

    @Nullable
    public final File getJdkToolsJar$kotlin_jps_plugin() {
        String javaHomePath;
        block6: {
            block5: {
                javaHomePath = System.getProperty("java.home");
                if (javaHomePath == null) break block5;
                CharSequence charSequence = javaHomePath;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block6;
            }
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getCanonicalFile();
        }
        if (Intrinsics.areEqual((Object)javaHome.getName(), (Object)"jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getCanonicalFile();
        }
        return null;
    }

    private final synchronized ClassLoader getOrCreateClassLoader(JpsCompilerEnvironment environment, List<? extends File> paths) {
        ClassLoader classLoader = ourClassLoaderRef.get();
        if (classLoader == null) {
            classLoader = ClassPreloadingUtils.preloadClasses((Collection<File>)paths, 4096, CompilerRunnerUtil.class.getClassLoader(), environment.getClassesToLoadByParent());
            ourClassLoaderRef = new SoftReference<ClassLoader>(classLoader);
        }
        ClassLoader classLoader2 = classLoader;
        Intrinsics.checkNotNull((Object)classLoader2);
        return classLoader2;
    }

    @Nullable
    public final Object invokeExecMethod(@NotNull String compilerClassName, @NotNull String[] arguments, @NotNull JpsCompilerEnvironment environment, @NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return this.withCompilerClassloader(environment, (Function1)new Function1<ClassLoader, Object>(compilerClassName, out, environment, arguments){
            final /* synthetic */ String $compilerClassName;
            final /* synthetic */ PrintStream $out;
            final /* synthetic */ JpsCompilerEnvironment $environment;
            final /* synthetic */ String[] $arguments;

            public final Object invoke(@NotNull ClassLoader classLoader) {
                Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
                Class<?> compiler = Class.forName(this.$compilerClassName, true, classLoader);
                Method exec = compiler.getMethod("execAndOutputXml", PrintStream.class, Class.forName("org.jetbrains.kotlin.config.Services", true, classLoader), String[].class);
                return exec.invoke(compiler.newInstance(), this.$out, this.$environment.getServices(), this.$arguments);
            }
            {
                this.$compilerClassName = string2;
                this.$out = printStream;
                this.$environment = jpsCompilerEnvironment;
                this.$arguments = stringArray;
                super(1);
            }
        });
    }

    @NotNull
    public final Set<String> invokeClassesFqNames(@NotNull JpsCompilerEnvironment environment, @NotNull Set<? extends File> files2) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Set set = (Set)this.withCompilerClassloader(environment, (Function1)new Function1<ClassLoader, Set<? extends String>>(files2){
            final /* synthetic */ Set $files;

            @Nullable
            public final Set<String> invoke(@NotNull ClassLoader classLoader) {
                Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
                Class<?> klass = Class.forName("org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt", true, classLoader);
                Method method = klass.getMethod("classesFqNames", Set.class);
                Object object = method.invoke(klass, this.$files);
                if (!(object instanceof Set)) {
                    object = null;
                }
                return (Set)object;
            }
            {
                this.$files = set;
                super(1);
            }
        });
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final <T> T withCompilerClassloader(JpsCompilerEnvironment environment, Function1<? super ClassLoader, ? extends T> fn) {
        Object object;
        block3: {
            List classPath2;
            block2: {
                List list = KotlinClassPath.CompilerWithScripting.computeClassPath();
                boolean bl = false;
                boolean bl2 = false;
                classPath2 = list;
                boolean bl3 = false;
                object = INSTANCE.getJdkToolsJar$kotlin_jps_plugin();
                if (object == null) break block2;
                File file2 = object;
                boolean bl4 = false;
                boolean bl5 = false;
                File it = file2;
                boolean bl6 = false;
                object = CollectionsKt.plus((Collection)classPath2, (Object)it);
                if (object != null) break block3;
            }
            object = classPath2;
        }
        Object paths = object;
        ClassLoader classLoader = this.getOrCreateClassLoader(environment, (List<? extends File>)paths);
        return (T)fn.invoke((Object)classLoader);
    }

    private CompilerRunnerUtil() {
    }

    static {
        CompilerRunnerUtil compilerRunnerUtil;
        INSTANCE = compilerRunnerUtil = new CompilerRunnerUtil();
        ourClassLoaderRef = new SoftReference<Object>(null);
    }
}

