"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("../../../../scales/types");
var commons_1 = require("../../../../utils/commons");
var common_1 = require("../../state/utils/common");
var utils_1 = require("../../state/utils/utils");
var specs_1 = require("../../utils/specs");
exports.DEFAULT_LINE_OVERFLOW = 0;
function computeYDomainLineAnnotationDimensions(annotationSpec, yScale, chartRotation, chartDimensions, lineColor, axisPosition) {
    var dataValues = annotationSpec.dataValues, marker = annotationSpec.marker, _a = annotationSpec.markerDimensions, markerDimensions = _a === void 0 ? { width: 0, height: 0 } : _a, specMarkerPosition = annotationSpec.markerPosition;
    var isHorizontalChartRotation = common_1.isHorizontalRotation(chartRotation);
    var anchorPosition = getAnchorPosition(false, isHorizontalChartRotation, specMarkerPosition, axisPosition);
    var lineProps = [];
    dataValues.forEach(function (datum) {
        var dataValue = datum.dataValue;
        if (dataValue === null || dataValue === undefined || dataValue === '') {
            return;
        }
        var annotationValueYPosition = yScale.scale(dataValue);
        if (annotationValueYPosition === null) {
            return;
        }
        var _a = __read(yScale.domain, 2), domainStart = _a[0], domainEnd = _a[1];
        if (dataValue < domainStart || dataValue > domainEnd) {
            return;
        }
        var markerPosition = getMarkerPositionForYAnnotation(chartDimensions, chartRotation, markerDimensions, anchorPosition, annotationValueYPosition);
        var linePathPoints = getYLinePath(chartDimensions, annotationValueYPosition, chartRotation);
        var annotationMarker = marker
            ? {
                icon: marker,
                color: lineColor,
                dimension: __assign({}, markerDimensions),
                position: markerPosition,
            }
            : undefined;
        var lineProp = {
            linePathPoints: linePathPoints,
            marker: annotationMarker,
            details: {
                detailsText: datum.details,
                headerText: datum.header || dataValue.toString(),
            },
        };
        lineProps.push(lineProp);
    });
    return lineProps;
}
function computeXDomainLineAnnotationDimensions(annotationSpec, xScale, chartRotation, chartDimensions, lineColor, isHistogramMode, axisPosition) {
    var dataValues = annotationSpec.dataValues, marker = annotationSpec.marker, _a = annotationSpec.markerDimensions, markerDimensions = _a === void 0 ? { width: 0, height: 0 } : _a, specMarkerPosition = annotationSpec.markerPosition;
    var lineProps = [];
    var isHorizontalChartRotation = common_1.isHorizontalRotation(chartRotation);
    var anchorPosition = getAnchorPosition(true, isHorizontalChartRotation, specMarkerPosition, axisPosition);
    dataValues.forEach(function (datum) {
        var dataValue = datum.dataValue;
        var annotationValueXPosition = xScale.scale(dataValue);
        if (annotationValueXPosition == null) {
            return;
        }
        if (types_1.isContinuousScale(xScale) && typeof dataValue === 'number') {
            var _a = __read(xScale.domain, 1), minDomain = _a[0];
            var maxDomain = isHistogramMode ? xScale.domain[1] + xScale.minInterval : xScale.domain[1];
            if (dataValue < minDomain || dataValue > maxDomain) {
                return;
            }
            if (isHistogramMode) {
                var offset = utils_1.computeXScaleOffset(xScale, true);
                var pureScaledValue = xScale.pureScale(dataValue);
                if (pureScaledValue == null) {
                    return;
                }
                annotationValueXPosition = pureScaledValue - offset;
            }
            else {
                annotationValueXPosition += (xScale.bandwidth * xScale.totalBarsInCluster) / 2;
            }
        }
        else if (types_1.isBandScale(xScale)) {
            if (isHistogramMode) {
                var padding = (xScale.step - xScale.originalBandwidth) / 2;
                annotationValueXPosition -= padding;
            }
            else {
                annotationValueXPosition += xScale.originalBandwidth / 2;
            }
        }
        else {
            return;
        }
        if (isNaN(annotationValueXPosition) || annotationValueXPosition == null) {
            return;
        }
        var markerPosition = getMarkerPositionForXAnnotation(chartDimensions, chartRotation, markerDimensions, anchorPosition, annotationValueXPosition);
        var linePathPoints = getXLinePath(chartDimensions, annotationValueXPosition, chartRotation);
        var annotationMarker = marker
            ? {
                icon: marker,
                color: lineColor,
                dimension: __assign({}, markerDimensions),
                position: markerPosition,
            }
            : undefined;
        var lineProp = {
            linePathPoints: linePathPoints,
            details: {
                detailsText: datum.details,
                headerText: datum.header || dataValue.toString(),
            },
            marker: annotationMarker,
        };
        lineProps.push(lineProp);
    });
    return lineProps;
}
function computeLineAnnotationDimensions(annotationSpec, chartDimensions, chartRotation, yScales, xScale, isHistogramMode, axisPosition) {
    var _a, _b, _c;
    var domainType = annotationSpec.domainType, hideLines = annotationSpec.hideLines;
    if (hideLines) {
        return null;
    }
    var lineStyle = annotationSpec.style;
    var lineColor = (_c = (_b = (_a = lineStyle) === null || _a === void 0 ? void 0 : _a.line) === null || _b === void 0 ? void 0 : _b.stroke, (_c !== null && _c !== void 0 ? _c : 'red'));
    if (domainType === specs_1.AnnotationDomainTypes.XDomain) {
        return computeXDomainLineAnnotationDimensions(annotationSpec, xScale, chartRotation, chartDimensions, lineColor, isHistogramMode, axisPosition);
    }
    var groupId = annotationSpec.groupId;
    var yScale = yScales.get(groupId);
    if (!yScale) {
        return null;
    }
    return computeYDomainLineAnnotationDimensions(annotationSpec, yScale, chartRotation, chartDimensions, lineColor, axisPosition);
}
exports.computeLineAnnotationDimensions = computeLineAnnotationDimensions;
function getAnchorPosition(isXDomain, isChartHorizontal, specMarkerPosition, axisPosition) {
    var dflPositionFromAxis = getDefaultMarkerPositionFromAxis(isXDomain, isChartHorizontal, axisPosition);
    if (specMarkerPosition !== undefined) {
        var validatedPosFromMarkerPos = validateMarkerPosition(isXDomain, isChartHorizontal, specMarkerPosition);
        return (validatedPosFromMarkerPos !== null && validatedPosFromMarkerPos !== void 0 ? validatedPosFromMarkerPos : dflPositionFromAxis);
    }
    return dflPositionFromAxis;
}
function validateMarkerPosition(isXDomain, isHorizontal, position) {
    if ((isXDomain && isHorizontal) || (!isXDomain && !isHorizontal)) {
        return position === commons_1.Position.Top || position === commons_1.Position.Bottom ? position : undefined;
    }
    return position === commons_1.Position.Left || position === commons_1.Position.Right ? position : undefined;
}
function getDefaultMarkerPositionFromAxis(isXDomain, isHorizontal, axisPosition) {
    if (axisPosition) {
        return axisPosition;
    }
    if ((isXDomain && isHorizontal) || (!isXDomain && !isHorizontal)) {
        return commons_1.Position.Left;
    }
    return commons_1.Position.Bottom;
}
function getXLinePath(_a, value, rotation) {
    var width = _a.width, height = _a.height;
    return {
        start: {
            x1: value,
            y1: 0,
        },
        end: {
            x2: value,
            y2: rotation === -90 || rotation === 90 ? width : height,
        },
    };
}
function getYLinePath(_a, value, rotation) {
    var width = _a.width, height = _a.height;
    return {
        start: {
            x1: 0,
            y1: value,
        },
        end: {
            x2: rotation === -90 || rotation === 90 ? height : width,
            y2: value,
        },
    };
}
function getMarkerPositionForXAnnotation(_a, rotation, _b, position, value) {
    var width = _a.width, height = _a.height;
    var mWidth = _b.width, mHeight = _b.height;
    switch (position) {
        case commons_1.Position.Right:
            return {
                top: rotation === -90 ? height - value - mHeight / 2 : value - mHeight / 2,
                left: width,
            };
        case commons_1.Position.Left:
            return {
                top: rotation === -90 ? height - value - mHeight / 2 : value - mHeight / 2,
                left: -mWidth,
            };
        case commons_1.Position.Top:
            return {
                top: 0 - mHeight,
                left: rotation === 180 ? width - value - mWidth / 2 : value - mWidth / 2,
            };
        case commons_1.Position.Bottom:
        default:
            return {
                top: height,
                left: rotation === 180 ? width - value - mWidth / 2 : value - mWidth / 2,
            };
    }
}
function getMarkerPositionForYAnnotation(_a, rotation, _b, position, value) {
    var width = _a.width, height = _a.height;
    var mWidth = _b.width, mHeight = _b.height;
    switch (position) {
        case commons_1.Position.Right:
            return {
                top: rotation === 180 ? height - value - mHeight / 2 : value - mHeight / 2,
                left: width,
            };
        case commons_1.Position.Left:
            return {
                top: rotation === 180 ? height - value - mHeight / 2 : value - mHeight / 2,
                left: -mWidth,
            };
        case commons_1.Position.Top:
            return {
                top: 0 - mHeight,
                left: rotation === 90 ? width - value - mWidth / 2 : value - mWidth / 2,
            };
        case commons_1.Position.Bottom:
        default:
            return {
                top: height,
                left: rotation === 90 ? width - value - mWidth / 2 : value - mWidth / 2,
            };
    }
}
//# sourceMappingURL=dimensions.js.map