<?php
// This file was auto-generated from sdk-root/src/data/customer-profiles/2020-08-15/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-08-15', 'endpointPrefix' => 'profile', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'Customer Profiles', 'serviceFullName' => 'Amazon Connect Customer Profiles', 'serviceId' => 'Customer Profiles', 'signatureVersion' => 'v4', 'signingName' => 'profile', 'uid' => 'customer-profiles-2020-08-15', ], 'operations' => [ 'AddProfileKey' => [ 'name' => 'AddProfileKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/keys', ], 'input' => [ 'shape' => 'AddProfileKeyRequest', ], 'output' => [ 'shape' => 'AddProfileKeyResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateDomain' => [ 'name' => 'CreateDomain', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'CreateDomainRequest', ], 'output' => [ 'shape' => 'CreateDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateProfile' => [ 'name' => 'CreateProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles', ], 'input' => [ 'shape' => 'CreateProfileRequest', ], 'output' => [ 'shape' => 'CreateProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteDomain' => [ 'name' => 'DeleteDomain', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'DeleteDomainRequest', ], 'output' => [ 'shape' => 'DeleteDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteIntegration' => [ 'name' => 'DeleteIntegration', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/integrations/delete', ], 'input' => [ 'shape' => 'DeleteIntegrationRequest', ], 'output' => [ 'shape' => 'DeleteIntegrationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfile' => [ 'name' => 'DeleteProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/delete', ], 'input' => [ 'shape' => 'DeleteProfileRequest', ], 'output' => [ 'shape' => 'DeleteProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfileKey' => [ 'name' => 'DeleteProfileKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/keys/delete', ], 'input' => [ 'shape' => 'DeleteProfileKeyRequest', ], 'output' => [ 'shape' => 'DeleteProfileKeyResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfileObject' => [ 'name' => 'DeleteProfileObject', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/objects/delete', ], 'input' => [ 'shape' => 'DeleteProfileObjectRequest', ], 'output' => [ 'shape' => 'DeleteProfileObjectResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfileObjectType' => [ 'name' => 'DeleteProfileObjectType', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}', ], 'input' => [ 'shape' => 'DeleteProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'DeleteProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDomain' => [ 'name' => 'GetDomain', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'GetDomainRequest', ], 'output' => [ 'shape' => 'GetDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetIntegration' => [ 'name' => 'GetIntegration', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/integrations', ], 'input' => [ 'shape' => 'GetIntegrationRequest', ], 'output' => [ 'shape' => 'GetIntegrationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetProfileObjectType' => [ 'name' => 'GetProfileObjectType', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}', ], 'input' => [ 'shape' => 'GetProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'GetProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetProfileObjectTypeTemplate' => [ 'name' => 'GetProfileObjectTypeTemplate', 'http' => [ 'method' => 'GET', 'requestUri' => '/templates/{TemplateId}', ], 'input' => [ 'shape' => 'GetProfileObjectTypeTemplateRequest', ], 'output' => [ 'shape' => 'GetProfileObjectTypeTemplateResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListAccountIntegrations' => [ 'name' => 'ListAccountIntegrations', 'http' => [ 'method' => 'POST', 'requestUri' => '/integrations', ], 'input' => [ 'shape' => 'ListAccountIntegrationsRequest', ], 'output' => [ 'shape' => 'ListAccountIntegrationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListDomains' => [ 'name' => 'ListDomains', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains', ], 'input' => [ 'shape' => 'ListDomainsRequest', ], 'output' => [ 'shape' => 'ListDomainsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListIntegrations' => [ 'name' => 'ListIntegrations', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/integrations', ], 'input' => [ 'shape' => 'ListIntegrationsRequest', ], 'output' => [ 'shape' => 'ListIntegrationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileObjectTypeTemplates' => [ 'name' => 'ListProfileObjectTypeTemplates', 'http' => [ 'method' => 'GET', 'requestUri' => '/templates', ], 'input' => [ 'shape' => 'ListProfileObjectTypeTemplatesRequest', ], 'output' => [ 'shape' => 'ListProfileObjectTypeTemplatesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileObjectTypes' => [ 'name' => 'ListProfileObjectTypes', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/object-types', ], 'input' => [ 'shape' => 'ListProfileObjectTypesRequest', ], 'output' => [ 'shape' => 'ListProfileObjectTypesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileObjects' => [ 'name' => 'ListProfileObjects', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/objects', ], 'input' => [ 'shape' => 'ListProfileObjectsRequest', ], 'output' => [ 'shape' => 'ListProfileObjectsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'PutIntegration' => [ 'name' => 'PutIntegration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/integrations', ], 'input' => [ 'shape' => 'PutIntegrationRequest', ], 'output' => [ 'shape' => 'PutIntegrationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutProfileObject' => [ 'name' => 'PutProfileObject', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/profiles/objects', ], 'input' => [ 'shape' => 'PutProfileObjectRequest', ], 'output' => [ 'shape' => 'PutProfileObjectResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutProfileObjectType' => [ 'name' => 'PutProfileObjectType', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}', ], 'input' => [ 'shape' => 'PutProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'PutProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'SearchProfiles' => [ 'name' => 'SearchProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/search', ], 'input' => [ 'shape' => 'SearchProfilesRequest', ], 'output' => [ 'shape' => 'SearchProfilesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateDomain' => [ 'name' => 'UpdateDomain', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'UpdateDomainRequest', ], 'output' => [ 'shape' => 'UpdateDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateProfile' => [ 'name' => 'UpdateProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/profiles', ], 'input' => [ 'shape' => 'UpdateProfileRequest', ], 'output' => [ 'shape' => 'UpdateProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'name' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AddProfileKeyRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'KeyName', 'Values', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'AddProfileKeyResponse' => [ 'type' => 'structure', 'members' => [ 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], ], ], 'Address' => [ 'type' => 'structure', 'members' => [ 'Address1' => [ 'shape' => 'string1To255', ], 'Address2' => [ 'shape' => 'string1To255', ], 'Address3' => [ 'shape' => 'string1To255', ], 'Address4' => [ 'shape' => 'string1To255', ], 'City' => [ 'shape' => 'string1To255', ], 'County' => [ 'shape' => 'string1To255', ], 'State' => [ 'shape' => 'string1To255', ], 'Province' => [ 'shape' => 'string1To255', ], 'Country' => [ 'shape' => 'string1To255', ], 'PostalCode' => [ 'shape' => 'string1To255', ], ], ], 'Attributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'string1To255', ], 'value' => [ 'shape' => 'string1To255', ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'CreateDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'DefaultExpirationDays', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateDomainResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'DefaultExpirationDays', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'AccountNumber' => [ 'shape' => 'string1To255', ], 'AdditionalInformation' => [ 'shape' => 'string1To1000', ], 'PartyType' => [ 'shape' => 'PartyType', ], 'BusinessName' => [ 'shape' => 'string1To255', ], 'FirstName' => [ 'shape' => 'string1To255', ], 'MiddleName' => [ 'shape' => 'string1To255', ], 'LastName' => [ 'shape' => 'string1To255', ], 'BirthDate' => [ 'shape' => 'string1To255', ], 'Gender' => [ 'shape' => 'Gender', ], 'PhoneNumber' => [ 'shape' => 'string1To255', ], 'MobilePhoneNumber' => [ 'shape' => 'string1To255', ], 'HomePhoneNumber' => [ 'shape' => 'string1To255', ], 'BusinessPhoneNumber' => [ 'shape' => 'string1To255', ], 'EmailAddress' => [ 'shape' => 'string1To255', ], 'PersonalEmailAddress' => [ 'shape' => 'string1To255', ], 'BusinessEmailAddress' => [ 'shape' => 'string1To255', ], 'Address' => [ 'shape' => 'Address', ], 'ShippingAddress' => [ 'shape' => 'Address', ], 'MailingAddress' => [ 'shape' => 'Address', ], 'BillingAddress' => [ 'shape' => 'Address', ], 'Attributes' => [ 'shape' => 'Attributes', ], ], ], 'CreateProfileResponse' => [ 'type' => 'structure', 'required' => [ 'ProfileId', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'DeleteDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteDomainResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], ], ], 'DeleteIntegrationResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileKeyRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'KeyName', 'Values', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteProfileKeyResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileObjectRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'ProfileObjectUniqueKey', 'ObjectTypeName', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteProfileObjectResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], ], ], 'DeleteProfileObjectTypeResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DomainList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListDomainItem', ], ], 'DomainStats' => [ 'type' => 'structure', 'members' => [ 'ProfileCount' => [ 'shape' => 'long', ], 'MeteringProfileCount' => [ 'shape' => 'long', ], 'ObjectCount' => [ 'shape' => 'long', ], 'TotalSize' => [ 'shape' => 'long', ], ], ], 'FieldContentType' => [ 'type' => 'string', 'enum' => [ 'STRING', 'NUMBER', 'PHONE_NUMBER', 'EMAIL_ADDRESS', 'NAME', ], ], 'FieldMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'name', ], 'value' => [ 'shape' => 'ObjectTypeField', ], ], 'FieldNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'name', ], ], 'Gender' => [ 'type' => 'string', 'enum' => [ 'MALE', 'FEMALE', 'UNSPECIFIED', ], ], 'GetDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'GetDomainResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Stats' => [ 'shape' => 'DomainStats', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], ], ], 'GetIntegrationResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'ObjectTypeName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], ], ], 'GetProfileObjectTypeResponse' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Description', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'text', ], 'TemplateId' => [ 'shape' => 'name', ], 'ExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetProfileObjectTypeTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'TemplateId', ], 'members' => [ 'TemplateId' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'TemplateId', ], ], ], 'GetProfileObjectTypeTemplateResponse' => [ 'type' => 'structure', 'members' => [ 'TemplateId' => [ 'shape' => 'name', ], 'SourceName' => [ 'shape' => 'name', ], 'SourceObject' => [ 'shape' => 'name', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], ], ], 'IntegrationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListIntegrationItem', ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'KeyMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'name', ], 'value' => [ 'shape' => 'ObjectTypeKeyList', ], ], 'ListAccountIntegrationsRequest' => [ 'type' => 'structure', 'required' => [ 'Uri', ], 'members' => [ 'Uri' => [ 'shape' => 'string1To255', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListAccountIntegrationsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'IntegrationList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListDomainItem' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ListDomainsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListDomainsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'DomainList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListIntegrationItem' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'ObjectTypeName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ListIntegrationsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListIntegrationsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'IntegrationList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileObjectTypeItem' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Description', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'text', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ListProfileObjectTypeTemplateItem' => [ 'type' => 'structure', 'members' => [ 'TemplateId' => [ 'shape' => 'name', ], 'SourceName' => [ 'shape' => 'name', ], 'SourceObject' => [ 'shape' => 'name', ], ], ], 'ListProfileObjectTypeTemplatesRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListProfileObjectTypeTemplatesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileObjectTypeTemplateList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileObjectTypesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListProfileObjectTypesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileObjectTypeList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileObjectsItem' => [ 'type' => 'structure', 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], 'Object' => [ 'shape' => 'stringifiedJson', ], ], ], 'ListProfileObjectsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', 'ProfileId', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'ListProfileObjectsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileObjectList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TagArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ObjectTypeField' => [ 'type' => 'structure', 'members' => [ 'Source' => [ 'shape' => 'text', ], 'Target' => [ 'shape' => 'text', ], 'ContentType' => [ 'shape' => 'FieldContentType', ], ], ], 'ObjectTypeKey' => [ 'type' => 'structure', 'members' => [ 'StandardIdentifiers' => [ 'shape' => 'StandardIdentifierList', ], 'FieldNames' => [ 'shape' => 'FieldNameList', ], ], ], 'ObjectTypeKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ObjectTypeKey', ], ], 'PartyType' => [ 'type' => 'string', 'enum' => [ 'INDIVIDUAL', 'BUSINESS', 'OTHER', ], ], 'Profile' => [ 'type' => 'structure', 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'AccountNumber' => [ 'shape' => 'string1To255', ], 'AdditionalInformation' => [ 'shape' => 'string1To1000', ], 'PartyType' => [ 'shape' => 'PartyType', ], 'BusinessName' => [ 'shape' => 'string1To255', ], 'FirstName' => [ 'shape' => 'string1To255', ], 'MiddleName' => [ 'shape' => 'string1To255', ], 'LastName' => [ 'shape' => 'string1To255', ], 'BirthDate' => [ 'shape' => 'string1To255', ], 'Gender' => [ 'shape' => 'Gender', ], 'PhoneNumber' => [ 'shape' => 'string1To255', ], 'MobilePhoneNumber' => [ 'shape' => 'string1To255', ], 'HomePhoneNumber' => [ 'shape' => 'string1To255', ], 'BusinessPhoneNumber' => [ 'shape' => 'string1To255', ], 'EmailAddress' => [ 'shape' => 'string1To255', ], 'PersonalEmailAddress' => [ 'shape' => 'string1To255', ], 'BusinessEmailAddress' => [ 'shape' => 'string1To255', ], 'Address' => [ 'shape' => 'Address', ], 'ShippingAddress' => [ 'shape' => 'Address', ], 'MailingAddress' => [ 'shape' => 'Address', ], 'BillingAddress' => [ 'shape' => 'Address', ], 'Attributes' => [ 'shape' => 'Attributes', ], ], ], 'ProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Profile', ], ], 'ProfileObjectList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListProfileObjectsItem', ], ], 'ProfileObjectTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListProfileObjectTypeItem', ], ], 'ProfileObjectTypeTemplateList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListProfileObjectTypeTemplateItem', ], ], 'PutIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'ObjectTypeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'PutIntegrationResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'ObjectTypeName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'PutProfileObjectRequest' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Object', 'DomainName', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Object' => [ 'shape' => 'stringifiedJson', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'PutProfileObjectResponse' => [ 'type' => 'structure', 'members' => [ 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], ], ], 'PutProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', 'Description', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], 'Description' => [ 'shape' => 'text', ], 'TemplateId' => [ 'shape' => 'name', ], 'ExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'PutProfileObjectTypeResponse' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Description', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'text', ], 'TemplateId' => [ 'shape' => 'name', ], 'ExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'SearchProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'KeyName', 'Values', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], ], ], 'SearchProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'StandardIdentifier' => [ 'type' => 'string', 'enum' => [ 'PROFILE', 'UNIQUE', 'SECONDARY', 'LOOKUP_ONLY', 'NEW_ONLY', ], ], 'StandardIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StandardIdentifier', ], ], 'TagArn' => [ 'type' => 'string', 'max' => 256, 'pattern' => '^arn:[a-z0-9]{1,10}:profile', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TagArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TagArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAddress' => [ 'type' => 'structure', 'members' => [ 'Address1' => [ 'shape' => 'string0To255', ], 'Address2' => [ 'shape' => 'string0To255', ], 'Address3' => [ 'shape' => 'string0To255', ], 'Address4' => [ 'shape' => 'string0To255', ], 'City' => [ 'shape' => 'string0To255', ], 'County' => [ 'shape' => 'string0To255', ], 'State' => [ 'shape' => 'string0To255', ], 'Province' => [ 'shape' => 'string0To255', ], 'Country' => [ 'shape' => 'string0To255', ], 'PostalCode' => [ 'shape' => 'string0To255', ], ], ], 'UpdateAttributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'string1To255', ], 'value' => [ 'shape' => 'string0To255', ], ], 'UpdateDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateDomainResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileId' => [ 'shape' => 'uuid', ], 'AdditionalInformation' => [ 'shape' => 'string0To1000', ], 'AccountNumber' => [ 'shape' => 'string0To255', ], 'PartyType' => [ 'shape' => 'PartyType', ], 'BusinessName' => [ 'shape' => 'string0To255', ], 'FirstName' => [ 'shape' => 'string0To255', ], 'MiddleName' => [ 'shape' => 'string0To255', ], 'LastName' => [ 'shape' => 'string0To255', ], 'BirthDate' => [ 'shape' => 'string0To255', ], 'Gender' => [ 'shape' => 'Gender', ], 'PhoneNumber' => [ 'shape' => 'string0To255', ], 'MobilePhoneNumber' => [ 'shape' => 'string0To255', ], 'HomePhoneNumber' => [ 'shape' => 'string0To255', ], 'BusinessPhoneNumber' => [ 'shape' => 'string0To255', ], 'EmailAddress' => [ 'shape' => 'string0To255', ], 'PersonalEmailAddress' => [ 'shape' => 'string0To255', ], 'BusinessEmailAddress' => [ 'shape' => 'string0To255', ], 'Address' => [ 'shape' => 'UpdateAddress', ], 'ShippingAddress' => [ 'shape' => 'UpdateAddress', ], 'MailingAddress' => [ 'shape' => 'UpdateAddress', ], 'BillingAddress' => [ 'shape' => 'UpdateAddress', ], 'Attributes' => [ 'shape' => 'UpdateAttributes', ], ], ], 'UpdateProfileResponse' => [ 'type' => 'structure', 'required' => [ 'ProfileId', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'boolean' => [ 'type' => 'boolean', ], 'encryptionKey' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'expirationDaysInteger' => [ 'type' => 'integer', 'max' => 1098, 'min' => 1, ], 'long' => [ 'type' => 'long', ], 'maxSize100' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'message' => [ 'type' => 'string', ], 'requestValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], ], 'sqsQueueUrl' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'string0To1000' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, ], 'string0To255' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'string1To1000' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'string1To255' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'stringifiedJson' => [ 'type' => 'string', 'max' => 256000, 'min' => 1, ], 'text' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'timestamp' => [ 'type' => 'timestamp', ], 'token' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'typeName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z_][a-zA-Z_0-9-]*$', ], 'uuid' => [ 'type' => 'string', 'pattern' => '[a-f0-9]{32}', ], ],];
