/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OperationValidator {
    private static final OperationValidator FOR_INSTALL = new InstallValidator();
    private static final OperationValidator FOR_UNINSTALL = new UninstallValidator();
    private static final OperationValidator FOR_UPDATE = new UpdateValidator();
    private static final OperationValidator FOR_ENABLE = new EnableValidator();
    private static final OperationValidator FOR_DISABLE = new DisableValidator();
    private static final OperationValidator FOR_CUSTOM_INSTALL = new CustomInstallValidator();
    private static final OperationValidator FOR_CUSTOM_UNINSTALL = new CustomUninstallValidator();
    private static final Logger LOGGER = Logger.getLogger(OperationValidator.class.getName());
    private static Map<Module, Set<Module>> module2depending = new HashMap<Module, Set<Module>>();
    private static Map<Module, Set<Module>> module2required = new HashMap<Module, Set<Module>>();

    private OperationValidator() {
    }

    public static boolean isValidOperation(OperationContainerImpl.OperationType operationType, UpdateUnit updateUnit, UpdateElement updateElement) {
        if (updateUnit.isPending()) {
            return false;
        }
        boolean bl = false;
        switch (operationType) {
            case INSTALL: {
                bl = FOR_INSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case DIRECT_UNINSTALL: 
            case UNINSTALL: {
                bl = FOR_UNINSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case UPDATE: {
                bl = FOR_UPDATE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case ENABLE: {
                bl = FOR_ENABLE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case DIRECT_DISABLE: 
            case DISABLE: {
                bl = FOR_DISABLE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case CUSTOM_INSTALL: {
                bl = FOR_CUSTOM_INSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case CUSTOM_UNINSTALL: {
                bl = FOR_CUSTOM_UNINSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return bl;
    }

    public static List<UpdateElement> getRequiredElements(OperationContainerImpl.OperationType operationType, UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
        List<UpdateElement> list2 = Collections.emptyList();
        switch (operationType) {
            case INSTALL: {
                list2 = FOR_INSTALL.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            case DIRECT_UNINSTALL: 
            case UNINSTALL: {
                list2 = FOR_UNINSTALL.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            case UPDATE: {
                list2 = FOR_UPDATE.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            case ENABLE: {
                list2 = FOR_ENABLE.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            case DIRECT_DISABLE: 
            case DISABLE: {
                list2 = FOR_DISABLE.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            case CUSTOM_INSTALL: {
                list2 = FOR_CUSTOM_INSTALL.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            case CUSTOM_UNINSTALL: {
                list2 = FOR_CUSTOM_UNINSTALL.getRequiredElementsImpl(updateElement, list, collection);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "== do getRequiredElements for " + (Object)((Object)operationType) + " of " + updateElement + " ==");
            for (UpdateElement updateElement2 : list2) {
                LOGGER.log(Level.FINE, "--> " + updateElement2);
            }
            LOGGER.log(Level.FINE, "== done. ==");
        }
        return list2;
    }

    public static Set<String> getBrokenDependencies(OperationContainerImpl.OperationType operationType, UpdateElement updateElement, List<ModuleInfo> list) {
        Set<Object> set = new HashSet();
        switch (operationType) {
            case ENABLE: {
                set = Utilities.getBrokenDependenciesInInstalledModules(updateElement);
                break;
            }
            case INSTALL: 
            case UPDATE: {
                OperationValidator.getRequiredElements(operationType, updateElement, list, set);
                break;
            }
            case DIRECT_UNINSTALL: 
            case UNINSTALL: 
            case DIRECT_DISABLE: 
            case DISABLE: 
            case CUSTOM_INSTALL: 
            case CUSTOM_UNINSTALL: {
                set = Utilities.getBrokenDependencies(updateElement, list);
                break;
            }
            default: {
                assert (false) : "Unknown type of operation " + (Object)((Object)operationType);
                break;
            }
        }
        return set;
    }

    abstract boolean isValidOperationImpl(UpdateUnit var1, UpdateElement var2);

    abstract List<UpdateElement> getRequiredElementsImpl(UpdateElement var1, List<ModuleInfo> var2, Collection<String> var3);

    public static void clearMaps() {
        module2depending = new HashMap<Module, Set<Module>>();
        module2required = new HashMap<Module, Set<Module>>();
    }

    private static boolean containsElement(UpdateElement updateElement, UpdateUnit updateUnit) {
        return updateUnit.getAvailableUpdates().contains(updateElement);
    }

    private static Set<Module> findRequiredModulesForDeactivate(Set<Module> set, ModuleManager moduleManager) {
        Module module;
        HashSet<Module> hashSet;
        HashSet<Module> hashSet2 = new HashSet<Module>(set);
        boolean bl = true;
        while (bl) {
            bl = false;
            hashSet = new HashSet<Module>(hashSet2);
            for (Module object : hashSet) {
                module = Utilities.findDependingModules(object, moduleManager, module2depending);
                bl |= hashSet2.addAll((Collection<Module>)module);
            }
        }
        hashSet = new HashSet<Module>(hashSet2);
        bl = true;
        while (bl) {
            bl = false;
            HashSet<Module> hashSet3 = new HashSet<Module>(hashSet);
            Iterator iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                if ((Utilities.isKitModule((ModuleInfo)module) || Utilities.isEssentialModule((ModuleInfo)module)) && !hashSet2.contains(module)) continue;
                Set<Module> set2 = Utilities.findRequiredModules(module, moduleManager, module2required);
                bl |= hashSet.addAll(set2);
            }
        }
        return OperationValidator.filterCandidatesToDeactivate(hashSet2, hashSet, moduleManager);
    }

    private static Set<Module> filterCandidatesToDeactivate(Collection<Module> collection, Collection<Module> collection2, ModuleManager moduleManager) {
        HashSet<Module> hashSet = new HashSet<Module>();
        HashSet<Module> hashSet2 = new HashSet<Module>(collection2);
        HashSet<Module> hashSet3 = new HashSet<Module>();
        for (UpdateElement object2 : UpdateManagerImpl.getInstance().getInstalledEagers()) {
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(object2);
            assert (updateElementImpl instanceof ModuleUpdateElementImpl) : object2 + " is instanceof ModuleUpdateElementImpl";
            ModuleInfo moduleInfo = ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo();
            hashSet3.add(Utilities.toModule(moduleInfo));
        }
        hashSet2.addAll(hashSet3);
        HashSet hashSet4 = new HashSet();
        HashSet<Module> hashSet5 = new HashSet<Module>();
        for (Module module : collection2) {
            if ((Utilities.isKitModule((ModuleInfo)module) || Utilities.isEssentialModule((ModuleInfo)module)) && !collection.contains(module)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "The module " + module.getCodeNameBase() + " is KIT_MODULE and won't be deactivated now not even " + Utilities.findRequiredModules(module, moduleManager, module2required));
                }
                hashSet4.add(module);
                continue;
            }
            if (hashSet4.contains(module)) {
                LOGGER.log(Level.FINE, "The module " + module.getCodeNameBase() + " was investigated already and won't be deactivated now.");
                continue;
            }
            Set<Module> set = Utilities.findDependingModules(module, moduleManager, module2depending);
            if (!hashSet2.containsAll(set)) {
                hashSet4.add(module);
                hashSet4.addAll(Utilities.findRequiredModules(module, moduleManager, module2required));
                LOGGER.log(Level.FINE, "The module " + module.getCodeNameBase() + " is shared and cannot be deactivated now.");
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                HashSet<Module> hashSet6 = new HashSet<Module>(set);
                hashSet6.removeAll(hashSet2);
                LOGGER.log(Level.FINER, "On " + module.getCodeNameBase() + " depending modules outside of set now deactivating modules: " + hashSet6);
                continue;
            }
            hashSet.add(module);
            set.retainAll(hashSet3);
            if (set.isEmpty()) continue;
            hashSet5.addAll(set);
        }
        hashSet.removeAll(hashSet3);
        LOGGER.log(Level.FINE, "Affected eagers are " + hashSet5);
        hashSet.addAll(hashSet5);
        hashSet.removeAll(OperationValidator.findDeepRequired(hashSet4, moduleManager));
        return hashSet;
    }

    private static Set<Module> findDeepRequired(Set<Module> set, ModuleManager moduleManager) {
        HashSet<Module> hashSet = new HashSet<Module>(set);
        boolean bl = true;
        while (bl) {
            HashSet<Module> hashSet2 = new HashSet<Module>(hashSet);
            bl = false;
            for (Module module : hashSet2) {
                Set<Module> set2 = Utilities.findRequiredModules(module, moduleManager, module2required);
                bl |= hashSet.addAll(set2);
            }
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomUninstallValidator
    extends OperationValidator {
        private CustomUninstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            boolean bl = false;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            assert (updateElementImpl != null);
            if (updateElementImpl != null && updateElementImpl instanceof NativeComponentUpdateElementImpl) {
                NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl = (NativeComponentUpdateElementImpl)updateElementImpl;
                bl = nativeComponentUpdateElementImpl.getNativeItem().getUpdateItemDeploymentImpl().getCustomUninstaller() != null;
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            LOGGER.log(Level.INFO, "CustomUninstallValidator doesn't care about required elements.");
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomInstallValidator
    extends OperationValidator {
        private CustomInstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl;
            boolean bl = false;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            assert (updateElementImpl != null);
            if (updateElementImpl != null && updateElementImpl instanceof NativeComponentUpdateElementImpl && (nativeComponentUpdateElementImpl = (NativeComponentUpdateElementImpl)updateElementImpl).getInstallInfo().getCustomInstaller() != null) {
                bl = OperationValidator.containsElement(updateElement, updateUnit);
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            LOGGER.log(Level.INFO, "CustomInstallValidator doesn't care about required elements.");
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisableValidator
    extends OperationValidator {
        private DisableValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && this.isValidOperationImpl(Trampoline.API.impl(updateElement));
        }

        private boolean isValidOperationImpl(UpdateElementImpl updateElementImpl) {
            boolean bl = false;
            switch (updateElementImpl.getType()) {
                case KIT_MODULE: 
                case MODULE: {
                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                    bl = Utilities.canDisable(module);
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    for (ModuleInfo moduleInfo : ((FeatureUpdateElementImpl)updateElementImpl).getModuleInfos()) {
                        Module module = Utilities.toModule(moduleInfo);
                        bl |= Utilities.canDisable(module);
                    }
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    bl = false;
                    break;
                }
                default: {
                    assert (false) : "Not supported for impl " + updateElementImpl;
                    break;
                }
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            ModuleManager moduleManager = null;
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            for (ModuleInfo object2 : list) {
                Module bl = Utilities.toModule(object2);
                if (Utilities.canDisable(bl)) {
                    linkedHashSet.add(bl);
                }
                if (moduleManager != null) continue;
                moduleManager = bl.getManager();
            }
            if (moduleManager == null) {
                LOGGER.log(Level.WARNING, "No modules can be disabled when disabling UpdateElement " + updateElement);
                return Collections.emptyList();
            }
            Set set = OperationValidator.findRequiredModulesForDeactivate(linkedHashSet, moduleManager);
            List list2 = moduleManager.simulateDisable(linkedHashSet);
            boolean bl = set.addAll(list2);
            if (LOGGER.isLoggable(Level.FINE) && bl) {
                list2.removeAll(OperationValidator.filterCandidatesToDeactivate(linkedHashSet, set, moduleManager));
                LOGGER.log(Level.FINE, "requestedToDisable was enlarged by " + list2);
            }
            HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                UpdateUnit updateUnit;
                Module module = (Module)iterator.next();
                if (linkedHashSet.contains(module) || !Utilities.canDisable(module) || (updateUnit = Utilities.toUpdateUnit(module)) == null) continue;
                hashSet.add(updateUnit.getInstalled());
            }
            return new ArrayList<UpdateElement>(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnableValidator
    extends OperationValidator {
        private EnableValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && this.isValidOperationImpl(Trampoline.API.impl(updateElement));
        }

        private boolean isValidOperationImpl(UpdateElementImpl updateElementImpl) {
            boolean bl = false;
            switch (updateElementImpl.getType()) {
                case KIT_MODULE: 
                case MODULE: {
                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                    bl = Utilities.canEnable(module);
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    for (ModuleInfo moduleInfo : ((FeatureUpdateElementImpl)updateElementImpl).getModuleInfos()) {
                        Module module = Utilities.toModule(moduleInfo);
                        bl |= Utilities.canEnable(module);
                    }
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    bl = false;
                    break;
                }
                default: {
                    assert (false) : "Not supported for impl " + updateElementImpl;
                    break;
                }
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            ModuleManager moduleManager = null;
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            for (ModuleInfo object2 : list) {
                Module module = Utilities.toModule(object2);
                if (Utilities.canEnable(module)) {
                    linkedHashSet.add(module);
                }
                if (moduleManager != null) continue;
                moduleManager = module.getManager();
            }
            ArrayList arrayList = new ArrayList();
            if (moduleManager != null) {
                List list2 = moduleManager.simulateEnable(linkedHashSet);
                for (Module module : list2) {
                    if (linkedHashSet.contains(module) || !Utilities.canEnable(module)) continue;
                    arrayList.add(Utilities.toUpdateUnit(module).getInstalled());
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateValidator
    extends OperationValidator {
        private UpdateValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && OperationValidator.containsElement(updateElement, updateUnit);
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            return FOR_INSTALL.getRequiredElementsImpl(updateElement, list, collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UninstallValidator
    extends OperationValidator {
        private UninstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && this.isValidOperationImpl(Trampoline.API.impl(updateElement));
        }

        private boolean isValidOperationImpl(UpdateElementImpl updateElementImpl) {
            boolean bl = false;
            switch (updateElementImpl.getType()) {
                case KIT_MODULE: 
                case MODULE: {
                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                    bl = ModuleDeleterImpl.getInstance().canDelete((ModuleInfo)module);
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    for (ModuleInfo moduleInfo : ((FeatureUpdateElementImpl)updateElementImpl).getModuleInfos()) {
                        Module module = Utilities.toModule(moduleInfo);
                        bl |= ModuleDeleterImpl.getInstance().canDelete((ModuleInfo)module);
                    }
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    LOGGER.log(Level.INFO, "CUSTOM_HANDLED_COMPONENT doesn't support custom uninstaller yet.");
                    bl = false;
                    break;
                }
                default: {
                    assert (false) : "Not supported for impl " + updateElementImpl;
                    break;
                }
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            ModuleManager moduleManager = null;
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            for (ModuleInfo object2 : list) {
                Module module = Utilities.toModule(object2);
                if (module == null) continue;
                if (!Utilities.isEssentialModule((ModuleInfo)module)) {
                    linkedHashSet.add(module);
                }
                if (moduleManager != null) continue;
                moduleManager = module.getManager();
            }
            HashSet hashSet = new HashSet();
            if (moduleManager != null) {
                Set set = OperationValidator.findRequiredModulesForDeactivate(linkedHashSet, moduleManager);
                set.removeAll(linkedHashSet);
                for (Module module : set) {
                    if (Utilities.isEssentialModule((ModuleInfo)module)) {
                        LOGGER.log(Level.WARNING, "Essential module cannot be planned for uninstall but " + module);
                        continue;
                    }
                    if (!ModuleDeleterImpl.getInstance().canDelete((ModuleInfo)module)) {
                        LOGGER.log(Level.WARNING, "The module " + module + " cannot be planned for uninstall because is read-only.");
                        continue;
                    }
                    UpdateUnit updateUnit = Utilities.toUpdateUnit(module);
                    if (updateUnit == null) continue;
                    hashSet.add(updateUnit.getInstalled());
                }
            }
            return new ArrayList<UpdateElement>(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallValidator
    extends OperationValidator {
        private InstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() == null && OperationValidator.containsElement(updateElement, updateUnit);
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection) {
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            LinkedList<UpdateElement> linkedList = new LinkedList<UpdateElement>(Utilities.findRequiredUpdateElements(updateElement, list, hashSet));
            if (collection != null) {
                for (Dependency dependency : hashSet) {
                    collection.add(dependency.toString());
                }
            }
            return linkedList;
        }
    }
}

