/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.mimelookup.impl.CompoundFolderChildren;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Exceptions;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class FolderPathLookup
extends AbstractLookup {
    private static final Logger LOG = Logger.getLogger(FolderPathLookup.class.getName());
    private InstanceContent content;
    private CompoundFolderChildren children;
    private PCL listener = new PCL();

    public FolderPathLookup(String[] stringArray) {
        this(stringArray, new InstanceContent());
    }

    private FolderPathLookup(String[] stringArray, InstanceContent instanceContent) {
        super((AbstractLookup.Content)instanceContent);
        this.content = instanceContent;
        this.children = new CompoundFolderChildren(stringArray, false);
        this.children.addPropertyChangeListener(this.listener);
        this.rebuild();
    }

    private void rebuild() {
        ArrayList<ICItem> arrayList = new ArrayList<ICItem>();
        for (FileObject fileObject : this.children.getChildren()) {
            if (!fileObject.isValid()) continue;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie == null) continue;
                arrayList.add(new ICItem(dataObject, instanceCookie));
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't create DataObject", exception);
            }
        }
        this.content.setPairs(arrayList);
    }

    private static final class ICItem
    extends AbstractLookup.Pair {
        static final long serialVersionUID = 10L;
        static final ThreadLocal<ICItem> DANGEROUS = new ThreadLocal();
        private static final Logger ERR = Logger.getLogger(ICItem.class.getName());
        private FileObject fo;
        private transient InstanceCookie ic;
        private transient DataObject dataObject;
        private transient Reference<Object> ref;

        public ICItem(DataObject dataObject, InstanceCookie instanceCookie) {
            this.ic = instanceCookie;
            this.dataObject = dataObject;
            this.fo = dataObject.getPrimaryFile();
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("New ICItem: " + dataObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            if (this.ic != null) {
                return;
            }
            ICItem iCItem = DANGEROUS.get();
            try {
                DANGEROUS.set(this);
                if (this.dataObject == null) {
                    try {
                        this.dataObject = DataObject.find((FileObject)this.fo);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        this.ic = new BrokenInstance("No DataObject for " + this.fo.getPath(), (Exception)((Object)dataObjectNotFoundException));
                        DANGEROUS.set(iCItem);
                        return;
                    }
                }
                this.ic = (InstanceCookie)this.dataObject.getCookie(InstanceCookie.class);
                if (this.ic == null) {
                    this.ic = new BrokenInstance("No cookie for " + this.fo.getPath(), null);
                }
            }
            finally {
                DANGEROUS.set(iCItem);
            }
        }

        protected boolean instanceOf(Class clazz) {
            this.init();
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("instanceOf: " + clazz.getName() + " obj: " + this.dataObject);
            }
            if (this.ic instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.ic;
                boolean bl = of.instanceOf(clazz);
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  of: " + bl);
                }
                return bl;
            }
            try {
                boolean bl = clazz.isAssignableFrom(this.ic.instanceClass());
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  plain: " + bl);
                }
                return bl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ICItem.exception(classNotFoundException, this.fo);
            }
            catch (IOException iOException) {
                ICItem.exception(iOException, this.fo);
            }
            return false;
        }

        public Object getInstance() {
            this.init();
            try {
                Object object = this.ic.instanceCreate();
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  getInstance: " + object + " for " + this.dataObject);
                }
                this.ref = new WeakReference<Object>(object);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ICItem.exception(classNotFoundException, this.fo);
            }
            catch (IOException iOException) {
                ICItem.exception(iOException, this.fo);
            }
            return null;
        }

        public int hashCode() {
            this.init();
            return System.identityHashCode(this.ic);
        }

        public boolean equals(Object object) {
            if (object instanceof ICItem) {
                ICItem iCItem = (ICItem)((Object)object);
                iCItem.init();
                this.init();
                return this.ic == iCItem.ic;
            }
            return false;
        }

        public String getId() {
            this.init();
            if (this.dataObject == null) {
                return "<broken: " + this.fo.getPath() + ">";
            }
            return this.dataObject.getName();
        }

        public String getDisplayName() {
            this.init();
            if (this.dataObject == null) {
                return "<broken: " + this.fo.getPath() + ">";
            }
            return this.dataObject.getNodeDelegate().getDisplayName();
        }

        protected boolean creatorOf(Object object) {
            Reference<Object> reference = this.ref;
            if (reference != null && reference.get() == object) {
                return true;
            }
            if (this.dataObject instanceof InstanceDataObject) {
                try {
                    Method method = InstanceDataObject.class.getDeclaredMethod("creatorOf", Object.class);
                    return (Boolean)method.invoke((Object)this.dataObject, object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public Class getType() {
            this.init();
            try {
                return this.ic.instanceClass();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return Object.class;
        }

        private static void exception(Exception exception, FileObject fileObject) {
            Exceptions.attachMessage((Throwable)exception, (String)("Bad file: " + fileObject));
            LOG.log(Level.WARNING, null, exception);
        }

        private static final class BrokenInstance
        implements InstanceCookie.Of {
            private final String message;
            private final Exception ex;

            public BrokenInstance(String string, Exception exception) {
                this.message = string;
                this.ex = exception;
            }

            public String instanceName() {
                return "java.lang.Object";
            }

            private ClassNotFoundException die() {
                if (this.ex != null) {
                    return new ClassNotFoundException(this.message, this.ex);
                }
                return new ClassNotFoundException(this.message);
            }

            public Class instanceClass() throws IOException, ClassNotFoundException {
                throw this.die();
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                throw this.die();
            }

            public boolean instanceOf(Class clazz) {
                return false;
            }
        }
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FolderPathLookup.this.rebuild();
        }
    }
}

