/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.IdentityManager;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class AlertEventHandler
extends BaseEventHandler {
    private final IdentityManager identityManager;
    private final boolean ignoreDuplicateAlerts;

    public AlertEventHandler(Config config, IdentityManager identityManager) {
        this.identityManager = identityManager;
        this.ignoreDuplicateAlerts = config.getBoolean(Keys.EVENT_IGNORE_DUPLICATE_ALERTS);
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Object alarm = position.getAttributes().get("alarm");
        if (alarm != null) {
            Position lastPosition;
            boolean ignoreAlert = false;
            if (this.ignoreDuplicateAlerts && (lastPosition = this.identityManager.getLastPosition(position.getDeviceId())) != null && alarm.equals(lastPosition.getAttributes().get("alarm"))) {
                ignoreAlert = true;
            }
            if (!ignoreAlert) {
                Event event = new Event("alarm", position);
                event.set("alarm", (String)alarm);
                return Collections.singletonMap(event, position);
            }
        }
        return null;
    }
}

