/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.testutil;

import ca.sqlpower.testutil.MockJDBCConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MockJDBCDriver
implements Driver {
    private static final Logger logger = Logger.getLogger(MockJDBCDriver.class);
    private static final Map<String, MockJDBCConnection> namedConnections = new HashMap<String, MockJDBCConnection>();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String params = url.substring("jdbc:mock:".length());
        String[] keyValuePairs = params.split("&");
        for (String keyvalue : Arrays.asList(keyValuePairs)) {
            String[] kv = keyvalue.split("=");
            logger.debug((Object)("Found URL property '" + kv[0] + "' = '" + kv[1] + "'"));
            info.put(kv[0], kv[1]);
        }
        MockJDBCConnection newConnection = new MockJDBCConnection(url, info);
        if (info.getProperty("name") != null) {
            namedConnections.put(info.getProperty("name"), newConnection);
        }
        return newConnection;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:mock");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static MockJDBCConnection getConnection(String name) {
        return namedConnections.get(name);
    }
}

