/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;

public class UniverseResolver {
    private final UniverseFactoryLoader ufl;
    private Map<UniverseSpec, Universe<?>> resolvedUniverses = Collections.emptyMap();
    private final Map<FeaturePackLocation.FPID, Path> localFeaturePacks;

    public static Builder builder() throws ProvisioningException {
        return new Builder(null);
    }

    public static Builder builder(UniverseFactoryLoader ufl) throws ProvisioningException {
        return new Builder(ufl);
    }

    UniverseResolver(UniverseResolverBuilder<?> builder) throws ProvisioningException {
        this.ufl = builder.getUfl();
        this.localFeaturePacks = builder.getLocalFeaturePacks();
    }

    public UniverseFactoryLoader getFactoryLoader() {
        return this.ufl;
    }

    public Universe<?> getUniverse(UniverseSpec universeSpec) throws ProvisioningException {
        return this.getUniverse(universeSpec, false);
    }

    public Universe<?> getUniverse(UniverseSpec universeSpec, boolean absoluteLatest) throws ProvisioningException {
        Universe<?> resolved;
        Universe<?> universe = resolved = absoluteLatest ? null : this.resolvedUniverses.get(universeSpec);
        if (resolved == null) {
            resolved = this.ufl.getUniverse(universeSpec, absoluteLatest);
            this.resolvedUniverses = CollectionUtils.put(this.resolvedUniverses, universeSpec, resolved);
        }
        return resolved;
    }

    public FeaturePackLocation resolveLatestBuild(FeaturePackLocation fpl) throws ProvisioningException {
        Channel channel = this.getChannel(fpl);
        FeaturePackLocation latestLocation = new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), channel.getName(), fpl.getFrequency(), channel.getLatestBuild(fpl));
        channel.resolve(latestLocation);
        return latestLocation;
    }

    public Channel getChannel(FeaturePackLocation fpl) throws ProvisioningException {
        if (fpl.getUniverse() == null) {
            throw new ProvisioningException("Invalid feature-pack location: " + fpl);
        }
        return this.getUniverse(fpl.getUniverse()).getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName());
    }

    public Path resolve(FeaturePackLocation fpl) throws ProvisioningException {
        if (this.localFeaturePacks.containsKey(fpl.getFPID())) {
            return this.localFeaturePacks.get(fpl.getFPID());
        }
        return this.getUniverse(fpl.getUniverse()).getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName()).resolve(fpl);
    }

    public boolean isResolved(FeaturePackLocation fpl) throws ProvisioningException {
        return this.getUniverse(fpl.getUniverse()).getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName()).isResolved(fpl);
    }

    public RepositoryArtifactResolver getArtifactResolver(String repositoryId) throws ProvisioningException {
        RepositoryArtifactResolver ar = this.ufl.getArtifactResolverOrNull(repositoryId);
        if (ar == null) {
            throw new ProvisioningException("Repository artifact resolver " + repositoryId + " was not configured");
        }
        return ar;
    }

    public Set<UniverseSpec> getUniverses() {
        return this.resolvedUniverses.keySet();
    }

    public static class Builder
    extends UniverseResolverBuilder<Builder> {
        private Builder(UniverseFactoryLoader ufl) throws ProvisioningException {
            this.ufl = ufl;
        }

        public UniverseResolver build() throws ProvisioningException {
            return new UniverseResolver(this);
        }
    }
}

