/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.Path;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenUniverseException;

public class MavenArtifact {
    public static final String EXT_JAR = "jar";
    public static final String EXT_ZIP = "zip";
    private static final String DEFAULT_CLASSIFIER = "";
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier = "";
    private String extension = "jar";
    private String versionRange;
    private Path path;

    public static MavenArtifact fromString(String str) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact();
        int colon = str.indexOf(58);
        int length = str.length();
        if (colon < 1 || colon == length - 1) {
            MavenArtifact.illegalFormat(str);
        }
        artifact.setGroupId(str.substring(0, colon));
        int offset = colon + 1;
        colon = str.indexOf(58, offset);
        if (colon < 0) {
            artifact.setArtifactId(str.substring(offset, length));
            return artifact;
        }
        if (colon == length - 1) {
            MavenArtifact.illegalFormat(str);
        }
        artifact.setArtifactId(str.substring(offset, colon));
        offset = colon + 1;
        colon = str.indexOf(58, offset);
        if (colon < 0) {
            MavenArtifact.setVersionOrRange(artifact, str.substring(offset, length));
            return artifact;
        }
        if (colon == length - 1) {
            MavenArtifact.illegalFormat(str);
        }
        artifact.setExtension(str.substring(offset, colon));
        offset = colon + 1;
        colon = str.indexOf(58, offset);
        if (colon < 0) {
            MavenArtifact.setVersionOrRange(artifact, str.substring(offset, length));
            return artifact;
        }
        if (colon == length - 1) {
            MavenArtifact.illegalFormat(str);
        }
        artifact.setClassifier(str.substring(offset, colon));
        MavenArtifact.setVersionOrRange(artifact, str.substring(colon + 1));
        return artifact;
    }

    private static void setVersionOrRange(MavenArtifact artifact, String v) {
        switch (v.charAt(0)) {
            case '(': 
            case '[': {
                artifact.setVersionRange(v);
                break;
            }
            default: {
                artifact.setVersion(v);
            }
        }
    }

    private static void illegalFormat(String str) throws MavenUniverseException {
        throw new MavenUniverseException("Bad artifact coordinates " + str + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public MavenArtifact setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public MavenArtifact setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getVersion() {
        return this.version;
    }

    public MavenArtifact setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public MavenArtifact setClassifier(String classifier) {
        this.classifier = classifier == null ? DEFAULT_CLASSIFIER : classifier;
        return this;
    }

    public String getExtension() {
        return this.extension;
    }

    public MavenArtifact setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public MavenArtifact setVersionRange(String versionRange) {
        this.versionRange = versionRange;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public MavenArtifact setPath(Path localArtifact) {
        this.path = localArtifact;
        return this;
    }

    public boolean isResolved() {
        return this.path != null;
    }

    public String getArtifactFileName() throws MavenUniverseException {
        if (this.artifactId == null) {
            MavenErrors.missingArtifactId();
        }
        if (this.version == null) {
            MavenErrors.missingVersion(this);
        }
        if (this.extension == null) {
            MavenErrors.missingExtension(this);
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.artifactId).append('-').append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            fileName.append('-').append(this.classifier);
        }
        fileName.append('.').append(this.extension);
        return fileName.toString();
    }

    public String getCoordsAsString() {
        String v;
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        String string = v = this.version == null ? this.versionRange : this.version;
        if (v == null) {
            return buf.toString();
        }
        if (this.extension != null) {
            buf.append(':').append(this.extension);
        }
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        }
        return buf.append(':').append(v).toString();
    }

    public String toString() {
        return this.getCoordsAsString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.versionRange == null ? other.versionRange != null : !this.versionRange.equals(other.versionRange));
    }
}

