/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.CachingContext;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.UpToDateResult;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.caching.impl.DefaultCachingStateBuilder;
import org.gradle.internal.execution.caching.impl.LoggingCachingStateBuilder;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.overlap.OverlappingOutputs;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveCachingStateStep
implements Step<BeforeExecutionContext, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveCachingStateStep.class);
    private static final CachingDisabledReason BUILD_CACHE_DISABLED_REASON = new CachingDisabledReason(CachingDisabledReasonCategory.BUILD_CACHE_DISABLED, "Build cache is disabled");
    private static final CachingState BUILD_CACHE_DISABLED_STATE = CachingState.disabledWithoutInputs(BUILD_CACHE_DISABLED_REASON);
    private final BuildCacheController buildCache;
    private final boolean buildScansEnabled;
    private final Step<? super CachingContext, ? extends UpToDateResult> delegate;

    public ResolveCachingStateStep(BuildCacheController buildCache, boolean buildScansEnabled, Step<? super CachingContext, ? extends UpToDateResult> delegate) {
        this.buildCache = buildCache;
        this.buildScansEnabled = buildScansEnabled;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(final BeforeExecutionContext context) {
        final UnitOfWork work = context.getWork();
        final CachingState cachingState = !this.buildCache.isEnabled() && !this.buildScansEnabled ? BUILD_CACHE_DISABLED_STATE : context.getBeforeExecutionState().map(beforeExecutionState -> this.calculateCachingState((BeforeExecutionState)beforeExecutionState, work)).orElseGet(() -> (this.buildCache.isEnabled() ? work.shouldDisableCaching(null) : Optional.of(BUILD_CACHE_DISABLED_REASON)).map(CachingState::disabledWithoutInputs).orElse(CachingState.NOT_DETERMINED));
        ImmutableList<CachingDisabledReason> disabledReasons = cachingState.getDisabledReasons();
        if (disabledReasons.isEmpty()) {
            this.logCacheKey(cachingState.getKey().get(), work);
        } else {
            this.logDisabledReasons((List<CachingDisabledReason>)disabledReasons, work);
        }
        final UpToDateResult result = this.delegate.execute(new CachingContext(){

            @Override
            public CachingState getCachingState() {
                return cachingState;
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return context.getBeforeExecutionState();
            }

            @Override
            public UnitOfWork getWork() {
                return work;
            }
        });
        return new CachingResult(){

            @Override
            public CachingState getCachingState() {
                return cachingState;
            }

            @Override
            public ImmutableList<String> getExecutionReasons() {
                return result.getExecutionReasons();
            }

            @Override
            public ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getFinalOutputs() {
                return result.getFinalOutputs();
            }

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.getReusedOutputOriginMetadata();
            }

            @Override
            public Try<ExecutionOutcome> getOutcome() {
                return result.getOutcome();
            }
        };
    }

    private CachingState calculateCachingState(BeforeExecutionState executionState, UnitOfWork work) {
        DefaultCachingStateBuilder builder;
        DefaultCachingStateBuilder defaultCachingStateBuilder = builder = this.buildCache.isEmitDebugLogging() ? new LoggingCachingStateBuilder() : new DefaultCachingStateBuilder();
        if (!this.buildCache.isEnabled()) {
            builder.markNotCacheable(BUILD_CACHE_DISABLED_REASON);
        }
        OverlappingOutputs detectedOverlappingOutputs = executionState.getDetectedOverlappingOutputs().orElse(null);
        work.shouldDisableCaching(detectedOverlappingOutputs).ifPresent(builder::markNotCacheable);
        builder.withImplementation(executionState.getImplementation());
        builder.withAdditionalImplementations((Iterable<ImplementationSnapshot>)executionState.getAdditionalImplementations());
        builder.withInputValueFingerprints((Map<String, ValueSnapshot>)executionState.getInputProperties());
        builder.withInputFilePropertyFingerprints((Map<String, CurrentFileCollectionFingerprint>)executionState.getInputFileProperties());
        builder.withOutputPropertyNames((Iterable<String>)executionState.getOutputFileProperties().keySet());
        return builder.build();
    }

    private void logCacheKey(BuildCacheKey cacheKey, UnitOfWork work) {
        if (this.buildCache.isEmitDebugLogging()) {
            LOGGER.warn("Build cache key for {} is {}", (Object)work.getDisplayName(), (Object)cacheKey.getDisplayName());
        } else {
            LOGGER.info("Build cache key for {} is {}", (Object)work.getDisplayName(), (Object)cacheKey.getDisplayName());
        }
    }

    private void logDisabledReasons(List<CachingDisabledReason> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("Caching disabled for %s because:", work.getDisplayName());
            for (CachingDisabledReason reason : reasons) {
                formatter.format("%n  %s", reason.getMessage());
            }
            LOGGER.info(formatter.toString());
        }
    }
}

