/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.Translate;
import org.eclipse.jetty.server.Server;

public class ErrorServlet
extends HttpServlet {
    private static final long serialVersionUID = 99356750L;
    private final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private static final String CONSOLE_BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final String PROP_THEME_NAME = "routerconsole.theme";
    private static final String PROP_THEME_PFX = "routerconsole.theme.";
    private static final String DEFAULT_THEME = "light";
    private static final String BASE_THEME_PATH = "/themes/console/";
    private static final String DEFAULT_ICO = "images/favicon.ico";
    private static final String DEFAULT_CSS = "console.css";
    private final String _icoPath = "/themes/console//images/favicon.ico";
    private String _cssPath;
    private String _webappName;
    private String _bundleName;
    private String _defaultBundle;

    public void init() throws ServletException {
        super.init();
        this._cssPath = this.getInitParameter("CSSPath");
        if (this._cssPath == null) {
            String dir = BASE_THEME_PATH + this._context.getProperty(PROP_THEME_NAME, DEFAULT_THEME);
            this._cssPath = dir + '/' + DEFAULT_CSS;
        }
        this._webappName = this.getInitParameter("name");
        if (this._webappName == null) {
            this._webappName = "unknown";
        }
        this._bundleName = this.getInitParameter("bundle");
        this._defaultBundle = this._bundleName != null ? this._bundleName : CONSOLE_BUNDLE_NAME;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int errorCode;
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("X-Content-Type-Options", "nosniff");
        resp.setHeader("Accept-Ranges", "none");
        resp.setDateHeader("Expires", 0L);
        resp.setHeader("Cache-Control", "no-store, max-age=0, no-cache, must-revalidate");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Content-Security-Policy", "default-src 'self'; script-src 'none'; form-action 'none'; frame-ancestors 'self'; object-src 'none'; media-src 'none'");
        Integer ERROR_CODE = (Integer)req.getAttribute("javax.servlet.error.status_code");
        String ERROR_URI = (String)req.getAttribute("javax.servlet.error.request_uri");
        String ERROR_MESSAGE = (String)req.getAttribute("javax.servlet.error.message");
        Throwable ERROR_THROWABLE = (Throwable)req.getAttribute("javax.servlet.error.exception");
        int n = errorCode = ERROR_CODE != null ? ERROR_CODE : 0;
        if (ERROR_CODE != null) {
            resp.setStatus(errorCode);
        }
        ERROR_URI = ERROR_URI == null ? "" : DataHelper.escapeHTML((String)ERROR_URI);
        ERROR_MESSAGE = ERROR_MESSAGE == null ? "" : DataHelper.escapeHTML((String)ERROR_MESSAGE);
        if (errorCode == 404 && (ERROR_URI.endsWith(".png") || ERROR_URI.endsWith(".jpg") || ERROR_URI.endsWith(".gif") || ERROR_URI.endsWith(".ico") || ERROR_URI.endsWith(".svg") || ERROR_URI.endsWith(".txt") || ERROR_URI.endsWith(".js") || ERROR_URI.endsWith(".css"))) {
            resp.setContentType("text/plain");
            PrintWriter out = resp.getWriter();
            out.println(this._t("Error {0}", 404) + ": " + ERROR_URI + ' ' + this._t("not found"));
            out.close();
            return;
        }
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.print("<html><head><title>");
        if (errorCode == 404) {
            out.print(this._t("Page Not Found"));
        } else {
            out.print(this._t("Internal Error"));
        }
        out.println("</title>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        if ("/themes/console//images/favicon.ico" != null) {
            out.println("<link rel=\"icon\" href=\"/themes/console//images/favicon.ico\">");
        }
        out.println("<link href=\"" + this._cssPath + '?' + "0.9.50" + "\" rel=\"stylesheet\" type=\"text/css\">");
        out.println("</head><body>");
        out.println("<div class=\"routersummaryouter\"><div class=\"routersummary\">");
        out.println("<a href=\"/\" title=\"" + this._t("Router Console") + "\"><img src=\"/themes/console/images/i2plogo.png\" alt=\"" + this._t("I2P Router Console") + "\" border=\"0\"></a><hr>");
        out.println("<a href=\"/config\">" + this._t("Configuration") + "</a> <a href=\"/help\">" + this._t("Help") + "</a>");
        out.println("</div></div>");
        out.println("<div class=\"sorry\" id=\"warning\">");
        out.println("<h2>" + this._t("Error {0}", errorCode) + ":&nbsp;" + ERROR_MESSAGE + "</h2>");
        out.println("<h3>" + this._t("WebApp") + ": " + this._w(this._webappName) + "</h3>");
        this.outputMessage(out, errorCode, ERROR_MESSAGE, ERROR_URI, ERROR_THROWABLE);
        out.println("</div></body></html>");
        out.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void outputMessage(PrintWriter out, int errorCode, String errorMsg, String errorURI, Throwable errorCause) {
        if (errorCode == 404) {
            out.println(this._t("Sorry! You appear to be requesting a nonexistent Router Console page or resource."));
            out.println("<hr>");
            out.println(this._t("Error {0}", 404) + ": " + errorURI + "&nbsp;" + this._t("not found"));
        } else if (errorCode == 403 || errorCode >= 500 || errorCause != null) {
            out.println(this._t("Sorry! There has been an internal error."));
            out.println("<hr>");
            out.println("<p>");
            out.println(this._t("Please report bugs on {0} or {1}.", "<a href=\"http://git.idk.i2p/i2p-hackers/i2p.i2p/-/issues/new\">git.idk.i2p</a>", "<a href=\"https://i2pgit.org/i2p-hackers/i2p.i2p/-/issues/new\">i2pgit.org</a>"));
            out.println("<p>");
            out.println(this._t("Please include this information in bug reports") + ':');
            out.print("</p></div><div class=\"sorry\" id=\"warning2\"><h3>");
            out.print(this._t("Error Details"));
            out.println("</h3><p>");
            out.println(this._t("Error {0}", errorCode) + ": " + errorURI + "&nbsp;" + errorMsg);
            out.println("</p><p>");
            if (errorCause != null) {
                StringWriter sw = new StringWriter(2048);
                PrintWriter pw = new PrintWriter(sw);
                errorCause.printStackTrace(pw);
                pw.flush();
                String trace = sw.toString();
                trace = trace.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                trace = trace.replace("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;\n");
                out.print(trace);
            }
            out.print("</p><h3>");
            out.println(this._t("I2P Version and Running Environment"));
            out.println("</h3><p>");
            String version = System.getProperty("router.version", "0.9.50");
            out.println("<b>I2P version:</b> " + version + "<br>");
            out.println("<b>Java version:</b> " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version") + ")<br>");
            out.println("<b>Wrapper version:</b> " + System.getProperty("wrapper.version", "none") + "<br>");
            try {
                out.println("<b>Server version:</b> " + Server.getVersion() + "<br>");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("<b>Platform:</b> " + System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + ' ' + System.getProperty("os.version") + "<br>");
            out.println("<b>Processor:</b> " + NativeBigInteger.cpuModel() + " (" + NativeBigInteger.cpuType() + ")<br>");
            out.println("<b>Jbigi:</b> " + NativeBigInteger.loadStatus() + "<br>");
            out.println("<b>Encoding:</b> " + System.getProperty("file.encoding") + "<br>");
            out.println("<b>Charset:</b> " + Charset.defaultCharset().name());
            out.println("</p><p>");
            out.println(this._t("Note that system information, log timestamps, and log messages may provide clues to your location; please review everything you include in a bug report."));
            out.println("</p>");
        } else {
            out.println("<p>Unsupported error " + errorCode + "</p>");
        }
    }

    protected String _w(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)this._defaultBundle);
    }

    protected String _t(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)CONSOLE_BUNDLE_NAME);
    }

    protected String _t(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)CONSOLE_BUNDLE_NAME);
    }

    protected String _t(String s, Object o, Object o2) {
        return Translate.getString((String)s, (Object)o, (Object)o2, (I2PAppContext)this._context, (String)CONSOLE_BUNDLE_NAME);
    }
}

