/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.BOB.I2Plistener;
import net.i2p.BOB.Lifted;
import net.i2p.BOB.Logger;
import net.i2p.BOB.NamedDB;
import net.i2p.BOB.TCPlistener;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.util.I2PAppThread;

public class MUXlisten
implements Runnable {
    private final NamedDB database;
    private final NamedDB info;
    private final Logger _log;
    private final I2PSocketManager socketManager;
    private final ByteArrayInputStream prikey;
    private ThreadGroup tg;
    private final String N;
    private ServerSocket listener;
    private static final int backlog = 50;
    private final boolean go_out;
    private final boolean come_in;
    private final AtomicBoolean lock;
    private final AtomicBoolean lives;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MUXlisten(AtomicBoolean lock, NamedDB database, NamedDB info, Logger _log) throws I2PException, IOException, RuntimeException {
        int port = 0;
        InetAddress host = null;
        this.lock = lock;
        this.tg = null;
        this.database = database;
        this.info = info;
        this._log = _log;
        this.lives = new AtomicBoolean(false);
        try {
            this.wlock();
            try {
                this.info.add("STARTING", Boolean.TRUE);
            }
            finally {
                this.wunlock();
            }
            Properties Q = new Properties();
            this.rlock();
            try {
                this.N = this.info.get("NICKNAME").toString();
                this.prikey = new ByteArrayInputStream((byte[])info.get("KEYS"));
                Properties R = (Properties)info.get("PROPERTIES");
                Lifted.copyProperties(R, Q);
                this.go_out = info.exists("OUTPORT");
                this.come_in = info.exists("INPORT");
                if (this.come_in) {
                    port = Integer.parseInt(info.get("INPORT").toString());
                    host = InetAddress.getByName(info.get("INHOST").toString());
                }
            }
            finally {
                this.runlock();
            }
            String i2cpHost = Q.getProperty("i2cp.tcp.host", "127.0.0.1");
            int i2cpPort = 7654;
            String i2cpPortStr = Q.getProperty("i2cp.tcp.port");
            if (i2cpPortStr != null) {
                try {
                    i2cpPort = Integer.parseInt(i2cpPortStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid I2CP port specified [" + i2cpPortStr + "]");
                }
            }
            if (this.come_in) {
                this.listener = new ServerSocket(port, 50, host);
            }
            this.socketManager = I2PSocketManagerFactory.createManager((InputStream)this.prikey, (String)i2cpHost, (int)i2cpPort, (Properties)Q);
        }
        catch (IOException e) {
            this.wlock();
            try {
                this.info.add("STARTING", Boolean.FALSE);
            }
            finally {
                this.wunlock();
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.wlock();
            try {
                this.info.add("STARTING", Boolean.FALSE);
            }
            finally {
                this.wunlock();
            }
            throw e;
        }
        catch (Exception e) {
            this.wlock();
            try {
                this.info.add("STARTING", Boolean.FALSE);
            }
            finally {
                this.wunlock();
            }
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void rlock() {
        this.database.getReadLock();
        this.info.getReadLock();
    }

    private void runlock() {
        this.info.releaseReadLock();
        this.database.releaseReadLock();
    }

    private void wlock() {
        this.database.getWriteLock();
        this.info.getWriteLock();
    }

    private void wunlock() {
        this.info.releaseWriteLock();
        this.database.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        I2PServerSocket SS = null;
        I2PAppThread t = null;
        I2PAppThread q = null;
        this.wlock();
        try {
            try {
                this.info.add("RUNNING", Boolean.TRUE);
            }
            catch (Exception e) {
                this.lock.set(false);
                this.wunlock();
                this.lives.set(false);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.wlock();
                    try {
                        this.info.add("STARTING", Boolean.FALSE);
                        this.info.add("STOPPING", Boolean.TRUE);
                        this.info.add("RUNNING", Boolean.FALSE);
                    }
                    catch (Exception e2) {
                        this.lock.set(false);
                        this.wunlock();
                        return;
                    }
                }
                catch (Exception e2) {
                }
                finally {
                    this.wunlock();
                }
                while (!this.lock.compareAndSet(false, true)) {
                }
                if (SS != null) {
                    try {
                        SS.close();
                    }
                    catch (I2PException e2) {
                        // empty catch block
                    }
                }
                if (this.listener != null) {
                    try {
                        this.listener.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                String groupName = this.tg.getName();
                try {
                    this._log.warn("destroySocketManager " + groupName);
                    this.socketManager.destroySocketManager();
                    this._log.warn("destroySocketManager Successful" + groupName);
                }
                catch (Exception e3) {
                    this._log.warn("destroySocketManager Failed" + groupName);
                    this._log.warn(e3.toString());
                }
                try {
                    this.wlock();
                    try {
                        this.info.add("STARTING", Boolean.FALSE);
                        this.info.add("STOPPING", Boolean.FALSE);
                        this.info.add("RUNNING", Boolean.FALSE);
                    }
                    catch (Exception e4) {
                        this.lock.set(false);
                        return;
                    }
                    finally {
                        this.wunlock();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                this.lock.set(false);
                if (this.tg != null) {
                    groupName = this.tg.getName();
                    this._log.warn("BOB: MUXlisten: Starting thread collection for: " + groupName);
                    if (this.tg.activeCount() + this.tg.activeGroupCount() != 0) {
                        int foo = this.tg.activeCount() + this.tg.activeGroupCount();
                        while (foo != 0) {
                            foo = this.tg.activeCount() + this.tg.activeGroupCount();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    this._log.warn("BOB: MUXlisten: Threads went away. Success: " + groupName);
                    this.tg.destroy();
                    this.tg = null;
                }
                try {
                    this.socketManager.destroySocketManager();
                    return;
                }
                catch (Exception groupName2) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Exception e) {
            this.lock.set(false);
            return;
        }
        finally {
            this.wunlock();
        }
        this.lives.set(true);
        this.lock.set(false);
        try {
            Runnable conn;
            this.tg = new ThreadGroup(this.N);
            if (this.go_out) {
                SS = this.socketManager.getServerSocket();
                conn = new I2Plistener(SS, this.socketManager, this.info, this.database, this._log, this.lives);
                t = new I2PAppThread(this.tg, conn, "BOBI2Plistener " + this.N);
                t.start();
            }
            if (this.come_in) {
                conn = new TCPlistener(this.listener, this.socketManager, this.info, this.database, this._log, this.lives);
                q = new I2PAppThread(this.tg, conn, "BOBTCPlistener " + this.N);
                q.start();
            }
            this.wlock();
            try {
                try {
                    this.info.add("STARTING", Boolean.FALSE);
                }
                catch (Exception e) {
                    this.wunlock();
                    return;
                }
                this.wunlock();
            }
            catch (Exception e) {
                this.wunlock();
                return;
                catch (Throwable throwable) {
                    this.wunlock();
                    throw throwable;
                }
            }
            boolean spin = true;
            while (spin) {
                if (!this.lives.get()) return;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                this.rlock();
                try {
                    try {
                        spin = this.info.get("STOPPING").equals(Boolean.FALSE);
                    }
                    catch (Exception e) {
                        this.runlock();
                        return;
                    }
                    this.runlock();
                }
                catch (Exception e) {
                    this.runlock();
                    return;
                    catch (Throwable throwable) {
                        this.runlock();
                        throw throwable;
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            // empty catch block
            return;
        }
        finally {
            this.lives.set(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.wlock();
                try {
                    this.info.add("STARTING", Boolean.FALSE);
                    this.info.add("STOPPING", Boolean.TRUE);
                    this.info.add("RUNNING", Boolean.FALSE);
                }
                catch (Exception e) {
                    this.lock.set(false);
                    this.wunlock();
                    return;
                }
            }
            catch (Exception e) {
            }
            finally {
                this.wunlock();
            }
            while (!this.lock.compareAndSet(false, true)) {
            }
            if (SS != null) {
                try {
                    SS.close();
                }
                catch (I2PException e) {}
            }
            if (this.listener != null) {
                try {
                    this.listener.close();
                }
                catch (IOException e) {}
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
            String groupName = this.tg.getName();
            try {
                this._log.warn("destroySocketManager " + groupName);
                this.socketManager.destroySocketManager();
                this._log.warn("destroySocketManager Successful" + groupName);
            }
            catch (Exception e) {
                this._log.warn("destroySocketManager Failed" + groupName);
                this._log.warn(e.toString());
            }
            try {
                this.wlock();
                try {
                    this.info.add("STARTING", Boolean.FALSE);
                    this.info.add("STOPPING", Boolean.FALSE);
                    this.info.add("RUNNING", Boolean.FALSE);
                }
                catch (Exception e) {
                    this.lock.set(false);
                    return;
                }
                finally {
                    this.wunlock();
                }
            }
            catch (Exception e) {}
            this.lock.set(false);
            if (this.tg != null) {
                groupName = this.tg.getName();
                this._log.warn("BOB: MUXlisten: Starting thread collection for: " + groupName);
                if (this.tg.activeCount() + this.tg.activeGroupCount() != 0) {
                    int foo = this.tg.activeCount() + this.tg.activeGroupCount();
                    while (foo != 0) {
                        foo = this.tg.activeCount() + this.tg.activeGroupCount();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this._log.warn("BOB: MUXlisten: Threads went away. Success: " + groupName);
                this.tg.destroy();
                this.tg = null;
            }
            try {
                this.socketManager.destroySocketManager();
            }
            catch (Exception exception) {}
        }
    }

    private void visitAllThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        MUXlisten.visit(root, 0, root.getName());
    }

    private static void visit(ThreadGroup group, int level, String tn) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        String indent = "------------------------------------".substring(0, level) + "-> ";
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            System.out.println("BOB: MUXlisten: " + tn + ": " + indent + thread.toString());
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            MUXlisten.visit(groups[i], level + 1, groups[i].getName());
        }
    }
}

