/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.i2p.I2PAppContext;
import net.i2p.data.router.RouterAddress;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public abstract class TransportUtil {
    public static final String NTCP_IPV6_CONFIG = "i2np.ntcp.ipv6";
    public static final String SSU_IPV6_CONFIG = "i2np.udp.ipv6";
    public static final String PROP_IPV4_FIREWALLED = "i2np.ipv4.firewalled";
    public static final String PROP_IPV6_FIREWALLED = "i2np.ipv6.firewalled";
    private static final String PROP_PORT_PFX = "i2np.";
    private static final String PROP_MIN_PORT_SFX = ".minPort";
    private static final String PROP_MAX_PORT_SFX = ".maxPort";
    private static final int MIN_RANDOM_PORT = 9151;
    private static final int MAX_RANDOM_PORT = 30777;
    private static final Pattern YGGDRASIL_PATTERN = Pattern.compile("^[2-3][0-9a-fA-F]{2}:[0-9a-fA-F:]*");
    private static final Map<String, IPv6Config> BY_NAME = new HashMap<String, IPv6Config>();
    public static final IPv6Config DEFAULT_IPV6_CONFIG = IPv6Config.IPV6_PREFERRED;

    public static IPv6Config getIPv6Config(RouterContext ctx, String transportStyle) {
        String cfg;
        if (transportStyle.equals("NTCP")) {
            cfg = ctx.getProperty(NTCP_IPV6_CONFIG);
        } else if (transportStyle.equals("SSU")) {
            cfg = ctx.getProperty(SSU_IPV6_CONFIG);
        } else {
            return DEFAULT_IPV6_CONFIG;
        }
        return TransportUtil.getIPv6Config(cfg);
    }

    public static IPv6Config getIPv6Config(String cfg) {
        if (cfg == null) {
            return DEFAULT_IPV6_CONFIG;
        }
        IPv6Config c = BY_NAME.get(cfg);
        if (c != null) {
            return c;
        }
        return DEFAULT_IPV6_CONFIG;
    }

    public static boolean isIPv4Firewalled(RouterContext ctx, String transportStyle) {
        return ctx.getBooleanProperty(PROP_IPV4_FIREWALLED);
    }

    public static boolean isIPv6Firewalled(RouterContext ctx, String transportStyle) {
        return ctx.getBooleanProperty(PROP_IPV6_FIREWALLED);
    }

    public static boolean isIPv6(RouterAddress addr) {
        String host = addr.getHost();
        if (host != null) {
            return host.contains(":");
        }
        String caps = addr.getOption("caps");
        return caps != null && caps.contains("6") && !caps.contains("4");
    }

    public static boolean isYggdrasil(RouterAddress addr) {
        String host = addr.getHost();
        return host != null && YGGDRASIL_PATTERN.matcher(host).matches();
    }

    public static boolean isPubliclyRoutable(byte[] addr, boolean allowIPv6) {
        return TransportUtil.isPubliclyRoutable(addr, true, allowIPv6);
    }

    public static boolean isPubliclyRoutable(byte[] addr, boolean allowIPv4, boolean allowIPv6) {
        if (I2PAppContext.getGlobalContext().getBooleanProperty("i2np.allowLocal")) {
            return true;
        }
        if (addr.length == 4) {
            if (!allowIPv4) {
                return false;
            }
            int a0 = addr[0] & 0xFF;
            if (a0 == 0) {
                return false;
            }
            if (a0 == 10) {
                return false;
            }
            if (a0 == 25) {
                return false;
            }
            if (a0 == 127) {
                return false;
            }
            int a1 = addr[1] & 0xFF;
            if (a0 == 100 && a1 >= 64 && a1 <= 127) {
                return false;
            }
            if (a0 == 169 && a1 == 254) {
                return false;
            }
            if (a0 == 172 && a1 >= 16 && a1 <= 31) {
                return false;
            }
            if (a0 == 192) {
                int a2;
                if (a1 == 168) {
                    return false;
                }
                if (a1 == 0 && ((a2 = addr[2] & 0xFF) == 0 || a2 == 2)) {
                    return false;
                }
                if (a1 == 88 && (addr[2] & 0xFF) == 99) {
                    return false;
                }
            }
            if (a0 == 198) {
                if (a1 == 18 || a1 == 19) {
                    return false;
                }
                if (a1 == 51 && (addr[2] & 0xFF) == 100) {
                    return false;
                }
            }
            if (a0 == 203 && a1 == 0 && (addr[2] & 0xFF) == 113) {
                return false;
            }
            return a0 < 224;
        }
        if (addr.length == 16 && allowIPv6) {
            int a0 = addr[0] & 0xFF;
            if (a0 == 32) {
                if (addr[1] == 2) {
                    return false;
                }
                if (addr[1] == 1) {
                    if (addr[2] == 0 && addr[3] == 0) {
                        return false;
                    }
                    if (addr[2] == 13 && (addr[3] & 0xFF) == 184) {
                        return false;
                    }
                }
                return true;
            }
            if (a0 == 38) {
                return addr[1] != 32 || addr[2] != 0 || (addr[3] & 0xFF) != 155;
            }
            if (a0 >= 32 && a0 <= 63) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPort(int port) {
        return !(port < 1024 || port > 65535 || port == 1900 || port == 1719 || port == 1720 || port == 2049 || port == 2827 || port == 3659 || port == 4045 || port == 4444 || port == 4445 || port == 5060 || port == 5061 || port == 6000 || port >= 6665 && port <= 6669 || port == 6697 || port >= 7650 && port <= 7668 || port == 8998 || port == 9001 || port == 9030 || port == 9050 || port == 9100 || port == 9150 || port == 31000 || port == 32000);
    }

    public static void logInvalidPort(Log log, String transportStyle, int port) {
        log.error("Specified " + transportStyle + " port " + port + " is not valid, selecting a new port");
        log.error("Invalid ports are: 0-1023, 1719, 1720, 1900, 2049, 2827, 3659, 4045, 4444, 4445, 5060, 5061, 6000, 6665-6669, 6697, 7650-7668, 8998, 9001, 9030, 9050, 9100, 9150, 31000, 32000, 65536+");
    }

    public static int selectRandomPort(RouterContext ctx, String transportStyle) {
        transportStyle = transportStyle.equals("SSU") ? "udp" : transportStyle.toLowerCase(Locale.US);
        String minprop = PROP_PORT_PFX + transportStyle + PROP_MIN_PORT_SFX;
        String maxprop = PROP_PORT_PFX + transportStyle + PROP_MAX_PORT_SFX;
        int minPort = Math.min(65535, Math.max(1, ctx.getProperty(minprop, 9151)));
        int maxPort = Math.min(65535, Math.max(minPort, ctx.getProperty(maxprop, 30777)));
        return minPort + ctx.random().nextInt(1 + maxPort - minPort);
    }

    static {
        for (IPv6Config cfg : IPv6Config.values()) {
            BY_NAME.put(cfg.toConfigString(), cfg);
        }
        BY_NAME.put("true", IPv6Config.IPV6_ENABLED);
        BY_NAME.put("disable", IPv6Config.IPV6_DISABLED);
    }

    public static enum IPv6Config {
        IPV6_DISABLED("false"),
        IPV6_NOT_PREFERRED("preferIPv4"),
        IPV6_ENABLED("enable"),
        IPV6_PREFERRED("preferIPv6"),
        IPV6_ONLY("only");

        private final String cfgstr;

        private IPv6Config(String cfgstr) {
            this.cfgstr = cfgstr;
        }

        public String toConfigString() {
            return this.cfgstr;
        }
    }
}

