/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.data.EmptyProperties;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;

public abstract class BuildMessageGenerator {
    public static void createRecord(int recordNum, int hop, TunnelBuildMessage msg, TunnelCreatorConfig cfg, Hash replyRouter, long replyTunnel, RouterContext ctx, PublicKey peerKey) {
        EncryptedBuildRecord erec;
        if (peerKey != null) {
            boolean isEC = peerKey.getType() == EncType.ECIES_X25519;
            BuildRequestRecord req = !cfg.isInbound() && hop + 1 == cfg.getLength() ? BuildMessageGenerator.createUnencryptedRecord(ctx, cfg, hop, replyRouter, replyTunnel, isEC) : BuildMessageGenerator.createUnencryptedRecord(ctx, cfg, hop, null, -1L, isEC);
            if (req == null) {
                throw new IllegalArgumentException("hop bigger than config");
            }
            Hash peer = cfg.getPeer(hop);
            if (isEC) {
                erec = req.encryptECIESRecord(ctx, peerKey, peer);
                cfg.setChaChaReplyKeys(hop, req.getChaChaReplyKey(), req.getChaChaReplyAD());
            } else {
                erec = req.encryptRecord(ctx, peerKey, peer);
            }
        } else {
            byte[] encrypted = new byte[528];
            if (cfg.isInbound() && hop + 1 == cfg.getLength()) {
                System.arraycopy(cfg.getPeer(hop).getData(), 0, encrypted, 0, 16);
                ctx.random().nextBytes(encrypted, 16, 512);
                byte[] h = new byte[32];
                ctx.sha().calculateHash(encrypted, 0, 528, h, 0);
                cfg.setBlankHash(new Hash(h));
            } else {
                ctx.random().nextBytes(encrypted);
            }
            erec = new EncryptedBuildRecord(encrypted);
        }
        msg.setRecord(recordNum, erec);
    }

    private static BuildRequestRecord createUnencryptedRecord(I2PAppContext ctx, TunnelCreatorConfig cfg, int hop, Hash replyRouter, long replyTunnel, boolean isEC) {
        if (hop < cfg.getLength()) {
            HopConfig hopConfig = cfg.getConfig(hop);
            Hash peer = cfg.getPeer(hop);
            long recvTunnelId = -1L;
            recvTunnelId = cfg.isInbound() || hop > 0 ? hopConfig.getReceiveTunnelId() : 0L;
            long nextTunnelId = -1L;
            Hash nextPeer = null;
            if (hop + 1 < cfg.getLength()) {
                nextTunnelId = cfg.getConfig(hop + 1).getReceiveTunnelId();
                nextPeer = cfg.getPeer(hop + 1);
            } else if (replyTunnel >= 0L && replyRouter != null) {
                nextTunnelId = replyTunnel;
                nextPeer = replyRouter;
            } else {
                nextTunnelId = 0L;
                nextPeer = peer;
            }
            SessionKey layerKey = hopConfig.getLayerKey();
            SessionKey ivKey = hopConfig.getIVKey();
            SessionKey replyKey = cfg.getAESReplyKey(hop);
            byte[] iv = cfg.getAESReplyIV(hop);
            if (iv == null) {
                throw new IllegalStateException();
            }
            boolean isInGW = cfg.isInbound() && hop == 0;
            boolean isOutEnd = !cfg.isInbound() && hop + 1 >= cfg.getLength();
            long nextMsgId = -1L;
            nextMsgId = isOutEnd || cfg.isInbound() && hop + 2 >= cfg.getLength() ? cfg.getReplyMessageId() : ctx.random().nextLong(0xFFFFFFFFL);
            BuildRequestRecord rec = isEC ? new BuildRequestRecord(ctx, recvTunnelId, nextTunnelId, nextPeer, nextMsgId, layerKey, ivKey, replyKey, iv, isInGW, isOutEnd, EmptyProperties.INSTANCE) : new BuildRequestRecord(ctx, recvTunnelId, peer, nextTunnelId, nextPeer, nextMsgId, layerKey, ivKey, replyKey, iv, isInGW, isOutEnd);
            return rec;
        }
        return null;
    }

    public static void layeredEncrypt(I2PAppContext ctx, TunnelBuildMessage msg, TunnelCreatorConfig cfg, List<Integer> order) {
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            EncryptedBuildRecord rec = msg.getRecord(i);
            Integer hopNum = order.get(i);
            int hop = hopNum;
            if (BuildMessageGenerator.isBlank(cfg, hop) && (!cfg.isInbound() || hop + 1 != cfg.getLength()) || !cfg.isInbound() && hop == 1) continue;
            int stop = cfg.isInbound() ? 0 : 1;
            for (int j = hop - 1; j >= stop; --j) {
                SessionKey key = cfg.getAESReplyKey(j);
                byte[] iv = cfg.getAESReplyIV(j);
                ctx.aes().decrypt(rec.getData(), 0, rec.getData(), 0, key, iv, 528);
            }
        }
    }

    public static boolean isBlank(TunnelCreatorConfig cfg, int hop) {
        if (cfg.isInbound()) {
            return hop + 1 >= cfg.getLength();
        }
        if (hop == 0) {
            return true;
        }
        return hop >= cfg.getLength();
    }
}

