/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.VariableTunnelBuildMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ExpireJob;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.Log;

abstract class BuildRequestor {
    private static final List<Integer> ORDER;
    private static final boolean SEND_VARIABLE = true;
    private static final int SHORT_RECORDS = 4;
    private static final List<Integer> SHORT_ORDER;
    private static final int MEDIUM_RECORDS = 5;
    private static final List<Integer> MEDIUM_ORDER;
    private static final int PRIORITY = 500;
    static final int REQUEST_TIMEOUT = 13000;
    private static final int FIRST_HOP_TIMEOUT = 10000;
    private static final int BUILD_MSG_TIMEOUT = 60000;

    BuildRequestor() {
    }

    private static boolean usePairedTunnels(RouterContext ctx) {
        return true;
    }

    private static void prepare(RouterContext ctx, PooledTunnelCreatorConfig cfg) {
        int len = cfg.getLength();
        boolean isIB = cfg.isInbound();
        for (int i = 0; i < len; ++i) {
            TunnelId id;
            HopConfig hop = cfg.getConfig(i);
            if (!isIB && i == 0) {
                if (len <= 1) {
                    id = ctx.tunnelDispatcher().getNewOBGWID();
                    hop.setSendTunnelId(id);
                }
            } else {
                id = isIB && len == 1 ? ctx.tunnelDispatcher().getNewIBZeroHopID() : (isIB && i == len - 1 ? ctx.tunnelDispatcher().getNewIBEPID() : new TunnelId(1L + ctx.random().nextLong(0xFFFFFFFFL)));
                hop.setReceiveTunnelId(id);
            }
            if (i > 0) {
                cfg.getConfig(i - 1).setSendTunnelId(hop.getReceiveTunnelId());
            }
            byte[] iv = new byte[16];
            ctx.random().nextBytes(iv);
            cfg.setAESReplyKeys(i, ctx.keyGenerator().generateSessionKey(), iv);
        }
    }

    public static boolean request(RouterContext ctx, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        BuildRequestor.prepare(ctx, cfg);
        if (cfg.getLength() <= 1) {
            BuildRequestor.buildZeroHop(ctx, cfg, exec);
            return true;
        }
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        TunnelPool pool = cfg.getTunnelPool();
        TunnelPoolSettings settings = pool.getSettings();
        TunnelInfo pairedTunnel = null;
        Hash farEnd = cfg.getFarEnd();
        TunnelManagerFacade mgr = ctx.tunnelManager();
        boolean isInbound = settings.isInbound();
        if (settings.isExploratory() || !BuildRequestor.usePairedTunnels(ctx)) {
            pairedTunnel = isInbound ? mgr.selectOutboundExploratoryTunnel(farEnd) : mgr.selectInboundExploratoryTunnel(farEnd);
        } else {
            pairedTunnel = isInbound ? mgr.selectOutboundTunnel(settings.getDestination(), farEnd) : mgr.selectInboundTunnel(settings.getDestination(), farEnd);
            if (pairedTunnel == null) {
                if (isInbound) {
                    pairedTunnel = mgr.selectOutboundTunnel();
                    if (pairedTunnel != null && pairedTunnel.getLength() <= 1 && mgr.getOutboundSettings().getLength() > 0 && mgr.getOutboundSettings().getLength() + mgr.getOutboundSettings().getLengthVariance() > 0) {
                        pairedTunnel = null;
                    }
                } else {
                    pairedTunnel = mgr.selectInboundTunnel();
                    if (pairedTunnel != null && pairedTunnel.getLength() <= 1 && mgr.getInboundSettings().getLength() > 0 && mgr.getInboundSettings().getLength() + mgr.getInboundSettings().getLengthVariance() > 0) {
                        pairedTunnel = null;
                    }
                }
                if (pairedTunnel != null && log.shouldLog(20)) {
                    log.info("Couldn't find a paired tunnel for " + cfg + ", using exploratory tunnel");
                }
            }
        }
        if (pairedTunnel == null) {
            if (log.shouldLog(30)) {
                log.warn("Tunnel build failed, as we couldn't find a paired tunnel for " + cfg);
            }
            exec.buildComplete(cfg);
            int ms = settings.isExploratory() ? 250 : 25;
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        I2NPMessageImpl msg = BuildRequestor.createTunnelBuildMessage(ctx, pool, cfg, pairedTunnel, exec);
        if (msg == null) {
            if (log.shouldLog(30)) {
                log.warn("Tunnel build failed, as we couldn't create the tunnel build message for " + cfg);
            }
            exec.buildComplete(cfg);
            return false;
        }
        if (cfg.isInbound()) {
            Hash ibgw = cfg.getPeer(0);
            if (msg.getType() == 27) {
                RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(ibgw);
                if (peer != null) {
                    GarlicMessage enc = MessageWrapper.wrap(ctx, (I2NPMessage)msg, peer);
                    if (enc != null) {
                        msg = enc;
                    } else if (log.shouldWarn()) {
                        log.warn("failed to wrap IB TBM to " + ibgw);
                    }
                } else if (log.shouldWarn()) {
                    log.warn("no RI, failed to wrap IB TBM to " + ibgw);
                }
            }
            if (log.shouldLog(20)) {
                log.info("Sending the tunnel build request " + msg.getUniqueId() + " out the tunnel " + pairedTunnel + " to " + ibgw + " for " + cfg + " waiting for the reply of " + cfg.getReplyMessageId());
            }
            ctx.tunnelDispatcher().dispatchOutbound(msg, pairedTunnel.getSendTunnelId(0), ibgw);
        } else {
            if (log.shouldLog(20)) {
                log.info("Sending the tunnel build request directly to " + cfg.getPeer(1) + " for " + cfg + " waiting for the reply of " + cfg.getReplyMessageId() + " with msgId=" + msg.getUniqueId());
            }
            msg.setMessageExpiration(ctx.clock().now() + 60000L + ctx.random().nextLong(20000L));
            RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(cfg.getPeer(1));
            if (peer == null) {
                if (log.shouldLog(30)) {
                    log.warn("Could not find the next hop to send the outbound request to: " + cfg);
                }
                exec.buildComplete(cfg);
                return false;
            }
            OutNetMessage outMsg = new OutNetMessage(ctx, msg, ctx.clock().now() + 10000L, 500, peer);
            outMsg.setOnFailedSendJob(new TunnelBuildFirstHopFailJob(ctx, cfg, exec));
            try {
                ctx.outNetMessagePool().add(outMsg);
            }
            catch (RuntimeException re) {
                log.error("failed sending build message", re);
                return false;
            }
        }
        return true;
    }

    private static TunnelBuildMessage createTunnelBuildMessage(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, TunnelInfo pairedTunnel, BuildExecutor exec) {
        ArrayList<Integer> order;
        TunnelBuildMessage msg;
        Hash replyRouter;
        boolean useVariable;
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        long replyTunnel = 0L;
        boolean bl = useVariable = cfg.getLength() <= 5;
        if (cfg.isInbound()) {
            replyRouter = ctx.routerHash();
        } else {
            replyTunnel = pairedTunnel.getReceiveTunnelId(0).getTunnelId();
            replyRouter = pairedTunnel.getPeer(0);
        }
        if (useVariable) {
            if (cfg.getLength() <= 4) {
                msg = new VariableTunnelBuildMessage(ctx, 4);
                order = new ArrayList<Integer>(SHORT_ORDER);
            } else {
                msg = new VariableTunnelBuildMessage(ctx, 5);
                order = new ArrayList<Integer>(MEDIUM_ORDER);
            }
        } else {
            msg = new TunnelBuildMessage(ctx);
            order = new ArrayList<Integer>(ORDER);
        }
        Collections.shuffle(order, ctx.random());
        cfg.setReplyOrder(order);
        if (log.shouldLog(10)) {
            log.debug("Build order: " + order + " for " + cfg);
        }
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            int hop = (Integer)order.get(i);
            PublicKey key = null;
            if (!BuildMessageGenerator.isBlank(cfg, hop)) {
                Hash peer = cfg.getPeer(hop);
                RouterInfo peerInfo = ctx.netDb().lookupRouterInfoLocally(peer);
                if (peerInfo == null) {
                    if (log.shouldLog(30)) {
                        log.warn("Peer selected for hop " + i + "/" + hop + " was not found locally: " + peer + " for " + cfg);
                    }
                    return null;
                }
                key = peerInfo.getIdentity().getPublicKey();
            }
            if (log.shouldLog(10)) {
                log.debug(cfg.getReplyMessageId() + ": record " + i + "/" + hop + " has key " + key);
            }
            BuildMessageGenerator.createRecord(i, hop, msg, cfg, replyRouter, replyTunnel, ctx, key);
        }
        BuildMessageGenerator.layeredEncrypt(ctx, msg, cfg, order);
        return msg;
    }

    private static void buildZeroHop(RouterContext ctx, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        if (log.shouldLog(10)) {
            log.debug("Build zero hop tunnel " + cfg);
        }
        exec.buildComplete(cfg);
        if (cfg.isInbound()) {
            ctx.tunnelDispatcher().joinInbound(cfg);
        } else {
            ctx.tunnelDispatcher().joinOutbound(cfg);
        }
        cfg.getTunnelPool().addTunnel(cfg);
        exec.buildSuccessful(cfg);
        ExpireJob expireJob = new ExpireJob(ctx, cfg);
        ctx.jobQueue().addJob(expireJob);
    }

    static {
        int i;
        ORDER = new ArrayList<Integer>(8);
        SHORT_ORDER = new ArrayList<Integer>(4);
        MEDIUM_ORDER = new ArrayList<Integer>(5);
        for (i = 0; i < 8; ++i) {
            ORDER.add(i);
        }
        for (i = 0; i < 4; ++i) {
            SHORT_ORDER.add(i);
        }
        for (i = 0; i < 5; ++i) {
            MEDIUM_ORDER.add(i);
        }
    }

    private static class TunnelBuildFirstHopFailJob
    extends JobImpl {
        private final PooledTunnelCreatorConfig _cfg;
        private final BuildExecutor _exec;

        private TunnelBuildFirstHopFailJob(RouterContext ctx, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
            super(ctx);
            this._cfg = cfg;
            this._exec = exec;
        }

        @Override
        public String getName() {
            return "Timeout contacting first peer for OB tunnel";
        }

        @Override
        public void runJob() {
            this._exec.buildComplete(this._cfg);
            this.getContext().profileManager().tunnelTimedOut(this._cfg.getPeer(1));
            this.getContext().statManager().addRateData("tunnel.buildFailFirstHop", 1L, 0L);
        }
    }
}

