/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.Locale;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.Markers;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.ValueScaler;

class CommentText
implements RrdGraphConstants {
    protected final String text;
    String resolvedText;
    Markers marker;
    boolean enabled;
    int x;
    int y;

    CommentText(String text) {
        this.text = text;
    }

    void resolveText(Locale l, DataProcessor dproc, ValueScaler valueScaler) {
        this.resolvedText = this.text;
        this.marker = null;
        if (this.resolvedText != null) {
            for (Markers m : Markers.values()) {
                String tryMarker = m.marker;
                if (!this.resolvedText.endsWith(tryMarker)) continue;
                this.marker = m;
                this.resolvedText = this.resolvedText.substring(0, this.resolvedText.length() - tryMarker.length());
                this.trimIfGlue();
                break;
            }
        }
        this.enabled = this.resolvedText != null;
    }

    void trimIfGlue() {
        if (Markers.GLUE_MARKER == this.marker) {
            this.resolvedText = this.resolvedText.replaceFirst("\\s+$", "");
        }
    }

    boolean isPrint() {
        return false;
    }

    boolean isValidGraphElement() {
        return !this.isPrint() && this.enabled;
    }
}

